/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.jdt.internal.corext.dom.Bindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportRemover {
    private Set<String> fAddedImports = new HashSet<String>();
    private Set<StaticImportData> fAddedStaticImports = new HashSet<StaticImportData>();
    private final IJavaProject fProject;
    private List<ASTNode> fRemovedNodes = new ArrayList<ASTNode>();
    private List<ImportDeclaration> fInlinedStaticImports = new ArrayList<ImportDeclaration>();
    private final CompilationUnit fRoot;

    public ImportRemover(IJavaProject project, CompilationUnit root) {
        this.fProject = project;
        this.fRoot = root;
    }

    private void divideTypeRefs(List<SimpleName> importNames, List<SimpleName> staticNames, List<SimpleName> removedRefs, List<SimpleName> unremovedRefs) {
        int[] removedStartsEnds = new int[2 * this.fRemovedNodes.size()];
        int index = 0;
        while (index < this.fRemovedNodes.size()) {
            int start;
            ASTNode node = this.fRemovedNodes.get(index);
            removedStartsEnds[2 * index] = start = node.getStartPosition();
            removedStartsEnds[2 * index + 1] = start + node.getLength();
            ++index;
        }
        for (SimpleName name : importNames) {
            if (this.isInRemoved(name, removedStartsEnds)) {
                removedRefs.add(name);
                continue;
            }
            unremovedRefs.add(name);
        }
        for (SimpleName name : staticNames) {
            if (this.isInRemoved(name, removedStartsEnds)) {
                removedRefs.add(name);
                continue;
            }
            unremovedRefs.add(name);
        }
        for (ImportDeclaration importDecl : this.fInlinedStaticImports) {
            Name name = importDecl.getName();
            if (name instanceof QualifiedName) {
                name = ((QualifiedName)name).getName();
            }
            removedRefs.add((SimpleName)name);
        }
    }

    public IBinding[] getImportsToRemove() {
        ArrayList<SimpleName> importNames = new ArrayList<SimpleName>();
        ArrayList<SimpleName> staticNames = new ArrayList<SimpleName>();
        ImportReferencesCollector.collect((ASTNode)this.fRoot, this.fProject, null, importNames, staticNames);
        ArrayList<SimpleName> removedRefs = new ArrayList<SimpleName>();
        ArrayList<SimpleName> unremovedRefs = new ArrayList<SimpleName>();
        this.divideTypeRefs(importNames, staticNames, removedRefs, unremovedRefs);
        if (removedRefs.size() == 0) {
            return new IBinding[0];
        }
        HashMap<String, IBinding> potentialRemoves = this.getPotentialRemoves(removedRefs);
        for (SimpleName name : unremovedRefs) {
            potentialRemoves.remove(name.getIdentifier());
        }
        Collection<IBinding> importsToRemove = potentialRemoves.values();
        return importsToRemove.toArray(new IBinding[importsToRemove.size()]);
    }

    private HashMap<String, IBinding> getPotentialRemoves(List<SimpleName> removedRefs) {
        HashMap<String, IBinding> potentialRemoves = new HashMap<String, IBinding>();
        for (SimpleName name : removedRefs) {
            IBinding binding;
            if (this.fAddedImports.contains(name.getIdentifier()) || this.hasAddedStaticImport(name) || (binding = name.resolveBinding()) == null) continue;
            potentialRemoves.put(name.getIdentifier(), binding);
        }
        return potentialRemoves;
    }

    private boolean hasAddedStaticImport(SimpleName name) {
        IBinding binding = name.resolveBinding();
        if (binding instanceof IVariableBinding) {
            IVariableBinding variable = (IVariableBinding)binding;
            return this.hasAddedStaticImport(variable.getDeclaringClass().getQualifiedName(), variable.getName(), true);
        }
        if (binding instanceof IMethodBinding) {
            IMethodBinding method = (IMethodBinding)binding;
            return this.hasAddedStaticImport(method.getDeclaringClass().getQualifiedName(), method.getName(), false);
        }
        return false;
    }

    private boolean hasAddedStaticImport(String qualifier, String member, boolean field) {
        StaticImportData data2 = null;
        for (StaticImportData data2 : this.fAddedStaticImports) {
            if (!data2.fQualifier.equals(qualifier) || !data2.fMember.equals(member) || data2.fField != field) continue;
            return true;
        }
        return false;
    }

    public boolean hasRemovedNodes() {
        return this.fRemovedNodes.size() != 0 || this.fInlinedStaticImports.size() != 0;
    }

    private boolean isInRemoved(SimpleName ref, int[] removedStartsEnds) {
        int start = ref.getStartPosition();
        int end = start + ref.getLength();
        int index = 0;
        while (index < removedStartsEnds.length) {
            if (start >= removedStartsEnds[index] && end <= removedStartsEnds[index + 1]) {
                return true;
            }
            index += 2;
        }
        return false;
    }

    public void registerAddedImport(String typeName) {
        int dot = typeName.lastIndexOf(46);
        if (dot == -1) {
            this.fAddedImports.add(typeName);
        } else {
            this.fAddedImports.add(typeName.substring(dot + 1));
        }
    }

    public void registerAddedImports(Type newTypeNode) {
        newTypeNode.accept(new ASTVisitor(true){

            private void addName(SimpleName name) {
                ImportRemover.this.fAddedImports.add(name.getIdentifier());
            }

            public boolean visit(QualifiedName node) {
                this.addName(node.getName());
                return false;
            }

            public boolean visit(QualifiedType node) {
                this.addName(node.getName());
                return false;
            }

            public boolean visit(SimpleName node) {
                this.addName(node);
                return false;
            }
        });
    }

    public void registerAddedStaticImport(String qualifier, String member, boolean field) {
        this.fAddedStaticImports.add(new StaticImportData(qualifier, member, field));
    }

    public void registerAddedStaticImport(IBinding binding) {
        if (binding instanceof IVariableBinding) {
            ITypeBinding declaringType = ((IVariableBinding)binding).getDeclaringClass();
            this.fAddedStaticImports.add(new StaticImportData(Bindings.getRawQualifiedName(declaringType), binding.getName(), true));
        } else if (binding instanceof IMethodBinding) {
            ITypeBinding declaringType = ((IMethodBinding)binding).getDeclaringClass();
            this.fAddedStaticImports.add(new StaticImportData(Bindings.getRawQualifiedName(declaringType), binding.getName(), false));
        } else {
            throw new IllegalArgumentException(binding.toString());
        }
    }

    public void registerRemovedNode(ASTNode removed) {
        this.fRemovedNodes.add(removed);
    }

    public void applyRemoves(ImportRewrite importRewrite) {
        IBinding[] bindings = this.getImportsToRemove();
        int i = 0;
        while (i < bindings.length) {
            IMethodBinding binding;
            if (bindings[i] instanceof ITypeBinding) {
                ITypeBinding typeBinding = (ITypeBinding)bindings[i];
                importRewrite.removeImport(typeBinding.getTypeDeclaration().getQualifiedName());
            } else if (bindings[i] instanceof IMethodBinding) {
                binding = (IMethodBinding)bindings[i];
                importRewrite.removeStaticImport(String.valueOf(binding.getDeclaringClass().getQualifiedName()) + '.' + binding.getName());
            } else if (bindings[i] instanceof IVariableBinding) {
                binding = (IVariableBinding)bindings[i];
                importRewrite.removeStaticImport(String.valueOf(binding.getDeclaringClass().getQualifiedName()) + '.' + binding.getName());
            }
            ++i;
        }
    }

    public void registerInlinedStaticImport(ImportDeclaration importDecl) {
        this.fInlinedStaticImports.add(importDecl);
    }

    private static class StaticImportData {
        private boolean fField;
        private String fMember;
        private String fQualifier;

        private StaticImportData(String qualifier, String member, boolean field) {
            this.fQualifier = qualifier;
            this.fMember = member;
            this.fField = field;
        }
    }
}

