/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.populationmodels.standard.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stem.core.STEMObjectPool;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.impl.IntegrationDecoratorImpl;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.edges.MigrationEdge;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.PopulationLabelValue;
import org.eclipse.stem.definitions.labels.RelativePhysicalRelationshipLabel;
import org.eclipse.stem.definitions.transport.PipeStyleTransportSystem;
import org.eclipse.stem.definitions.transport.PipeTransportEdge;
import org.eclipse.stem.definitions.transport.PipeTransportEdgeLabel;
import org.eclipse.stem.definitions.transport.PipeTransportEdgeLabelValue;
import org.eclipse.stem.populationmodels.Activator;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.StandardPackage;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabelValue;
import org.eclipse.stem.populationmodels.standard.impl.Messages;

public abstract class PopulationModelImpl
extends IntegrationDecoratorImpl
implements PopulationModel {
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = "human";
    protected String populationIdentifier = "human";
    protected static final String NAME_EDEFAULT = "HumanPopulationModel";
    protected String name = "HumanPopulationModel";
    protected static final String TARGET_ISO_KEY_EDEFAULT = "";
    protected String targetISOKey = "";
    protected static final double INITIAL_RESCALING_FACTOR_EDEFAULT = 1.0;
    protected double initialRescalingFactor = 1.0;
    protected static final long TIME_PERIOD_EDEFAULT = 86400000L;
    protected long timePeriod = 86400000L;
    protected Map<Node, List<PipeTransportEdge>> pipeTransportationNodeEdgesMap;
    protected HashMap<String, STEMObjectPool> labelValueObjectPools = new HashMap();

    protected EClass eStaticClass() {
        return StandardPackage.Literals.POPULATION_MODEL;
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String newPopulationIdentifier) {
        this.populationIdentifier = newPopulationIdentifier;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public String getTargetISOKey() {
        return this.targetISOKey;
    }

    @Override
    public void setTargetISOKey(String newTargetISOKey) {
        this.targetISOKey = newTargetISOKey;
    }

    @Override
    public double getInitialRescalingFactor() {
        return this.initialRescalingFactor;
    }

    @Override
    public void setInitialRescalingFactor(double newInitialRescalingFactor) {
        this.initialRescalingFactor = newInitialRescalingFactor;
    }

    @Override
    public long getTimePeriod() {
        return this.timePeriod;
    }

    @Override
    public void setTimePeriod(long newTimePeriod) {
        this.timePeriod = newTimePeriod;
    }

    @Override
    public EList<String> getAllLabelIdentifiers() {
        BasicEList identifiers = new BasicEList();
        identifiers.add((Object)this.getPopulationIdentifier());
        return identifiers;
    }

    @Override
    public PopulationModelLabel createPopulationModelLabel(String populationIdentifier) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PopulationModelLabelValue createPopulationModelLabelValue(String populationIdentifier) {
        throw new UnsupportedOperationException();
    }

    public void decorateGraph(STEMTime time) throws ScenarioInitializationException {
        if (this.isGraphDecorated()) {
            return;
        }
        boolean success = false;
        for (PopulationLabel populationLabel : this.getPopulationLabels(this.getPopulationIdentifier(), this.getGraph())) {
            success = true;
            if (!this.getPopulationIdentifier().equals(populationLabel.getPopulationIdentifier())) continue;
            boolean found = false;
            for (NodeLabel l : populationLabel.getNode().getLabels()) {
                if (!(l instanceof PopulationModelLabel) || !((PopulationModelLabel)l).getPopulationIdentifier().equals(this.getPopulationIdentifier())) continue;
                found = true;
                break;
            }
            if (found) continue;
            found = false;
            for (Decorator d : this.getGraph().getDecorators()) {
                if (d.equals(this) || !(d instanceof PopulationModel) || !((PopulationModel)d).getPopulationIdentifier().equals(this.getPopulationIdentifier()) || Utility.keyLevel((String)((PopulationModel)d).getTargetISOKey()) <= Utility.keyLevel((String)this.getTargetISOKey()) || !this.isContained(populationLabel.getNode(), ((PopulationModel)d).getTargetISOKey())) continue;
                found = true;
                break;
            }
            if (found || !this.isLeaf(populationLabel.getNode())) continue;
            PopulationModelLabel pl = this.createPopulationModelLabel(this.getPopulationIdentifier());
            pl.setPopulationLabel(populationLabel);
            pl.setPopulationIdentifier(populationLabel.getPopulationIdentifier());
            URI unique = STEMURI.createURI((String)("label/" + populationLabel.getNode().getURI().lastSegment() + "/" + this.getName() + "/" + this.getPopulationIdentifier()));
            pl.setURI(unique);
            pl.getDublinCore().setIdentifier(unique.toString());
            this.getLabelsToUpdate().add((Object)pl);
            populationLabel.getNode().getLabels().add((Object)pl);
            pl.setNode(populationLabel.getNode());
            this.getGraph().putNodeLabel((NodeLabel)pl);
        }
        if (!success) {
            throw new ScenarioInitializationException(NLS.bind((String)Messages.POP_MODEL_MISSING_POP_LABELS, (Object[])new Object[]{this.getURI().toString(), this.getPopulationIdentifier()}), (Identifiable)this, new Exception());
        }
        this.resetLabels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeAdditionalDeltasAndExchanges(IntegrationLabel integrationLabel, STEMTime time, double t, long timeDelta) {
        PopulationModelImpl populationModelImpl = this;
        synchronized (populationModelImpl) {
            if (this.labelValueObjectPools.size() == 0) {
                for (final String pop : this.getAllLabelIdentifiers()) {
                    this.labelValueObjectPools.put(pop, new STEMObjectPool(5, 5){

                        protected Object createNewObject() {
                            return PopulationModelImpl.this.createPopulationModelLabelValue(pop);
                        }

                        protected void resetObject(Object o) {
                        }
                    });
                }
            }
        }
        StandardPopulationModelLabelValue delta = (StandardPopulationModelLabelValue)integrationLabel.getDeltaValue();
        while (delta.getArrivals().size() > 0) {
            ExchangePool.POOL.release(delta.getArrivals().remove(0));
        }
        while (delta.getDepartures().size() > 0) {
            ExchangePool.POOL.release(delta.getDepartures().remove(0));
        }
        Exchange birthExchange = (Exchange)ExchangePool.POOL.get();
        Exchange deathExchange = (Exchange)ExchangePool.POOL.get();
        birthExchange.setType(ExchangeType.BIRTHS_AND_DEATHS);
        birthExchange.setCount(delta.getBirths());
        deathExchange.setType(ExchangeType.BIRTHS_AND_DEATHS);
        deathExchange.setCount(delta.getDeaths());
        delta.getArrivals().add((Object)birthExchange);
        delta.getDepartures().add((Object)deathExchange);
        this.handleMigration(integrationLabel, (EList<Exchange>)delta.getArrivals(), (EList<Exchange>)delta.getDepartures(), timeDelta, delta, t);
        this.handlePipeTransport(integrationLabel, (EList<Exchange>)delta.getArrivals(), (EList<Exchange>)delta.getDepartures(), timeDelta, delta);
        ECollections.sort((EList)delta.getArrivals());
        ECollections.sort((EList)delta.getDepartures());
    }

    protected boolean checkAndAdjustForNegative(PopulationModelLabel label) {
        StandardPopulationModelLabel slabel;
        StandardPopulationModelLabelValue pval;
        if (label instanceof StandardPopulationModelLabel && (pval = (StandardPopulationModelLabelValue)(slabel = (StandardPopulationModelLabel)label).getProbeValue()).getCount() < 0.0) {
            double negPop = pval.getCount();
            StandardPopulationModelLabelValue pdelta = (StandardPopulationModelLabelValue)slabel.getDeltaValue();
            pdelta.setCount(-negPop);
            pdelta.setBirths(-negPop);
            pdelta.setDeaths(0.0);
            Exchange birthExchange = (Exchange)ExchangePool.POOL.get();
            Exchange deathExchange = (Exchange)ExchangePool.POOL.get();
            birthExchange.setType(ExchangeType.BIRTHS_AND_DEATHS);
            birthExchange.setCount(-negPop);
            deathExchange.setType(ExchangeType.BIRTHS_AND_DEATHS);
            deathExchange.setCount(0.0);
            while (pdelta.getArrivals().size() > 0) {
                ExchangePool.POOL.release(pdelta.getArrivals().remove(0));
            }
            while (pdelta.getDepartures().size() > 0) {
                ExchangePool.POOL.release(pdelta.getDepartures().remove(0));
            }
            pdelta.getArrivals().add((Object)birthExchange);
            pdelta.getDepartures().add((Object)deathExchange);
            return true;
        }
        return false;
    }

    public void doStochasticProcess(IntegrationLabel iLabel, long timeDelta) {
        IntegrationLabelValue nextVal = (IntegrationLabelValue)iLabel.getNextValue();
        EList attrs = nextVal.eClass().getEAllAttributes();
        int i = 0;
        while (i < attrs.size()) {
            EAttribute attr = (EAttribute)attrs.get(i);
            if (attr.getEType().getClassifierID() == 31 && attr.isChangeable()) {
                nextVal.eSetDouble(attr.getFeatureID(), (double)Math.round(nextVal.eGetDouble(attr.getFeatureID())));
            }
            ++i;
        }
    }

    public boolean isLeaf(Node n) {
        for (Edge e : n.getEdges()) {
            if (!(e.getLabel() instanceof RelativePhysicalRelationshipLabel) || !e.getA().equals(n)) continue;
            return false;
        }
        return true;
    }

    protected Collection<PopulationLabel> getPopulationLabels(String populationIdentifier, Graph graph) {
        ArrayList<PopulationLabel> retValue = new ArrayList<PopulationLabel>();
        EList labels = graph.getNodeLabelsByTypeURI(PopulationLabel.URI_TYPE_POPULATION_LABEL);
        for (NodeLabel pl : labels) {
            PopulationLabel populationLabel;
            if (this.getTargetISOKey() != null && !this.getTargetISOKey().trim().equals(TARGET_ISO_KEY_EDEFAULT) && pl.getNode() != null && !this.isContained(pl.getNode(), this.getTargetISOKey()) && !pl.getNode().getURI().lastSegment().equals("ZZZ") || !(populationLabel = (PopulationLabel)pl).getPopulationIdentifier().equals(populationIdentifier) || populationLabel.getNode() == null) continue;
            retValue.add(populationLabel);
        }
        return retValue;
    }

    protected boolean isContained(Node node, String targetISOKey) {
        if (node.getURI().lastSegment().equals(targetISOKey)) {
            return true;
        }
        EList edges = node.getEdges();
        for (Edge e : edges) {
            if (!(e.getLabel() instanceof RelativePhysicalRelationshipLabel) && !(e.getLabel() instanceof PipeTransportEdgeLabel) || e.getA().equals(node) || Utility.keyLevel((String)e.getA().getURI().lastSegment()) > Utility.keyLevel((String)node.getURI().lastSegment())) continue;
            return this.isContained(e.getA(), targetISOKey);
        }
        return false;
    }

    public void applyExternalDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        int i = 0;
        while (i < labels.size()) {
            StandardPopulationModelLabel plabel = (StandardPopulationModelLabel)labels.get(i);
            StandardPopulationModelLabelValue myDelta = (StandardPopulationModelLabelValue)plabel.getDeltaValue();
            Node n = plabel.getNode();
            EList labs = n.getLabels();
            int j = 0;
            while (j < labs.size()) {
                NodeLabel l = (NodeLabel)labs.get(j);
                if (l instanceof IntegrationLabel && !l.equals(plabel) && ((IntegrationLabel)l).getIdentifier().equals(plabel.getIdentifier())) {
                    Exchange entry;
                    int k;
                    IntegrationLabelValue sdeLabelValue = ((IntegrationLabel)l).getDeltaValue();
                    EList arrivals = sdeLabelValue.getArrivals();
                    EList departures = sdeLabelValue.getDepartures();
                    if (arrivals != null) {
                        k = 0;
                        while (k < arrivals.size()) {
                            entry = (Exchange)arrivals.get(k);
                            if (entry.getType() == ExchangeType.BIRTHS_AND_DEATHS) {
                                myDelta.setCount(myDelta.getCount() + entry.getCount());
                                myDelta.setBirths(myDelta.getBirths() + entry.getCount());
                            }
                            ++k;
                        }
                    }
                    if (departures != null) {
                        k = 0;
                        while (k < departures.size()) {
                            entry = (Exchange)departures.get(k);
                            if (entry.getType() == ExchangeType.BIRTHS_AND_DEATHS) {
                                myDelta.setCount(myDelta.getCount() - entry.getCount());
                                myDelta.setDeaths(myDelta.getDeaths() + entry.getCount());
                                entry.getOtherLabels().add((Object)plabel);
                            }
                            ++k;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected void handleMigration(IntegrationLabel label, EList<Exchange> arrivals, EList<Exchange> departures, long timeDelta, IntegrationLabelValue idelta, double timeInCycles) {
        Node n = (Node)label.getIdentifiable();
        StandardPopulationModelLabelValue delta = (StandardPopulationModelLabelValue)idelta;
        EList edges = n.getEdges();
        int i = 0;
        while (i < edges.size()) {
            MigrationEdge me;
            Edge e = (Edge)edges.get(i);
            if (e instanceof MigrationEdge && (me = (MigrationEdge)e).getPopulationIdentifier().equals(((PopulationModelLabel)label).getPopulationIdentifier())) {
                Node source = me.getA();
                Node dest = me.getB();
                boolean leaving = source.equals(n);
                double rate = me.getLabel().getCurrentValue().getMigrationRate();
                long timeperiod = me.getLabel().getCurrentValue().getTimePeriod();
                if (leaving) {
                    StandardPopulationModelLabelValue val = (StandardPopulationModelLabelValue)label.getTempValue();
                    double count = val.getCount();
                    double goodbye = me.isUseAbsoluteValues() ? rate * (double)timeDelta / (double)timeperiod : count * rate * (double)timeDelta / (double)timeperiod;
                    delta.setCount(delta.getCount() - goodbye);
                    Exchange migrationExchange = (Exchange)ExchangePool.POOL.get();
                    Label otherLabel = null;
                    EList destLabels = dest.getLabels();
                    int j = 0;
                    while (j < destLabels.size()) {
                        Label lab = (Label)destLabels.get(j);
                        if (lab instanceof StandardPopulationModelLabel && ((StandardPopulationModelLabel)lab).getPopulationIdentifier().equals(((PopulationModelLabel)label).getPopulationIdentifier())) {
                            otherLabel = lab;
                            break;
                        }
                        ++j;
                    }
                    if (otherLabel == null) {
                        Activator.logError(NLS.bind((String)Messages.EDGE_POP_MODEL_MISSING, (Object[])new Object[]{dest.getURI().toString(), ((PopulationModelLabel)label).getPopulationIdentifier()}), new Exception());
                        return;
                    }
                    migrationExchange.setType(ExchangeType.MIGRATION);
                    migrationExchange.getOtherLabels().add(otherLabel);
                    migrationExchange.setCount(goodbye);
                    delta.getDepartures().add((Object)migrationExchange);
                } else {
                    StandardPopulationModelLabelValue otherVal = null;
                    NodeLabel otherLabel = null;
                    EList sourceLabels = source.getLabels();
                    int j = 0;
                    while (j < sourceLabels.size()) {
                        NodeLabel lab = (NodeLabel)sourceLabels.get(j);
                        if (lab instanceof StandardPopulationModelLabel && ((PopulationModelLabel)lab).getPopulationIdentifier().equals(((PopulationModelLabel)label).getPopulationIdentifier())) {
                            otherVal = (StandardPopulationModelLabelValue)((StandardPopulationModelLabel)lab).getTempValue();
                            otherLabel = lab;
                            break;
                        }
                        ++j;
                    }
                    if (otherVal == null) {
                        Activator.logError(NLS.bind((String)Messages.EDGE_POP_MODEL_MISSING, (Object[])new Object[]{dest.getURI().toString(), ((PopulationModelLabel)label).getPopulationIdentifier()}), new Exception());
                        return;
                    }
                    double count = otherVal.getCount();
                    double welcome = me.isUseAbsoluteValues() ? rate * (double)timeDelta / (double)timeperiod : count * rate * (double)timeDelta / (double)timeperiod;
                    delta.setCount(delta.getCount() + welcome);
                    Exchange migrationExchange = (Exchange)ExchangePool.POOL.get();
                    migrationExchange.setType(ExchangeType.MIGRATION);
                    migrationExchange.getOtherLabels().add((Object)otherLabel);
                    migrationExchange.setCount(welcome);
                    delta.getArrivals().add((Object)migrationExchange);
                }
            }
            ++i;
        }
    }

    protected void handlePipeTransport(IntegrationLabel populationLabel, EList<Exchange> arrivals, EList<Exchange> departures, long timeDelta, IntegrationLabelValue delta) {
        Node node = populationLabel.getNode();
        List<PipeTransportEdge> pedges = this.pipeTransportationNodeEdgesMap.get(node);
        if (pedges == null) {
            return;
        }
        int i = 0;
        while (i < pedges.size()) {
            PipeTransportEdge pedge = pedges.get(i);
            if (pedge.getPopulationIdentifier().equals(this.getPopulationIdentifier())) {
                Exchange migrationExchange;
                double factor;
                long timePeriod;
                double maxFlow;
                PipeTransportEdgeLabelValue edgeLabelValue;
                StandardPopulationModelLabelValue change;
                StandardPopulationModelLabel otherLabel;
                NodeLabel lab;
                int j;
                EList labs;
                boolean incomming = pedge.getB().equals(node);
                if (incomming) {
                    labs = pedge.getA().getLabels();
                    j = 0;
                    while (j < labs.size()) {
                        lab = (NodeLabel)labs.get(j);
                        if (lab instanceof StandardPopulationModelLabel && ((StandardPopulationModelLabel)lab).getPopulationIdentifier().equals(((PopulationModelLabel)populationLabel).getPopulationIdentifier())) {
                            otherLabel = (StandardPopulationModelLabel)lab;
                            StandardPopulationModelLabelValue otherValue = (StandardPopulationModelLabelValue)otherLabel.getTempValue();
                            change = (StandardPopulationModelLabelValue)this.labelValueObjectPools.get(otherLabel.getIdentifier()).get();
                            change.set(otherValue);
                            edgeLabelValue = (PipeTransportEdgeLabelValue)pedge.getLabel().getCurrentValue();
                            double flow = maxFlow = edgeLabelValue.getMaxFlow();
                            double popCount = ((StandardPopulationModelLabelValue)otherLabel.getTempValue()).getCount();
                            if (flow > popCount) {
                                flow = popCount;
                            }
                            timePeriod = edgeLabelValue.getTimePeriod();
                            factor = flow / popCount;
                            if (Double.isNaN(factor = factor * (double)timeDelta / (double)timePeriod) || Double.isInfinite(factor)) {
                                factor = 0.0;
                            }
                            change.scale(factor);
                            delta.add((IntegrationLabelValue)change);
                            migrationExchange = (Exchange)ExchangePool.POOL.get();
                            migrationExchange.setType(ExchangeType.MIGRATION);
                            migrationExchange.getOtherLabels().add((Object)otherLabel);
                            migrationExchange.setCount(change.getCount());
                            delta.getArrivals().add((Object)migrationExchange);
                            this.labelValueObjectPools.get(otherLabel.getIdentifier()).release((Object)change);
                            break;
                        }
                        ++j;
                    }
                } else {
                    labs = pedge.getB().getLabels();
                    j = 0;
                    while (j < labs.size()) {
                        lab = (NodeLabel)labs.get(j);
                        if (lab instanceof StandardPopulationModelLabel && ((StandardPopulationModelLabel)lab).getPopulationIdentifier().equals(((PopulationModelLabel)populationLabel).getPopulationIdentifier())) {
                            otherLabel = (StandardPopulationModelLabel)lab;
                            StandardPopulationModelLabelValue thisValue = (StandardPopulationModelLabelValue)populationLabel.getTempValue();
                            change = (StandardPopulationModelLabelValue)this.labelValueObjectPools.get(otherLabel.getIdentifier()).get();
                            change.set(thisValue);
                            edgeLabelValue = (PipeTransportEdgeLabelValue)pedge.getLabel().getCurrentValue();
                            maxFlow = edgeLabelValue.getMaxFlow();
                            double popCount = ((StandardPopulationModelLabelValue)populationLabel.getTempValue()).getCount();
                            double flow = maxFlow;
                            if (flow > popCount) {
                                flow = popCount;
                            }
                            timePeriod = edgeLabelValue.getTimePeriod();
                            factor = flow / popCount;
                            if (Double.isNaN(factor = factor * (double)timeDelta / (double)timePeriod) || Double.isInfinite(factor)) {
                                factor = 0.0;
                            }
                            change.scale(factor);
                            delta.sub((IntegrationLabelValue)change);
                            migrationExchange = (Exchange)ExchangePool.POOL.get();
                            migrationExchange.setType(ExchangeType.MIGRATION);
                            migrationExchange.getOtherLabels().add((Object)otherLabel);
                            migrationExchange.setCount(change.getCount());
                            delta.getDepartures().add((Object)migrationExchange);
                            this.labelValueObjectPools.get(otherLabel.getIdentifier()).release((Object)change);
                            break;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    protected void populatePipeSystemNodes() {
        Graph graph = this.getGraph();
        if (this.pipeTransportationNodeEdgesMap == null) {
            this.initPipeTransport(graph);
        }
        for (Map.Entry<Node, List<PipeTransportEdge>> entry : this.pipeTransportationNodeEdgesMap.entrySet()) {
            Node n = entry.getKey();
            if (!(n instanceof PipeStyleTransportSystem)) continue;
            List<PipeTransportEdge> pipeEdges = entry.getValue();
            double totalPop = 0.0;
            for (PipeTransportEdge pedge : pipeEdges) {
                if (!pedge.getB().equals(n)) continue;
                totalPop += ((PipeTransportEdgeLabelValue)pedge.getLabel().getCurrentValue()).getMaxFlow();
            }
            for (NodeLabel nlabel : n.getLabels()) {
                if (!(nlabel instanceof StandardPopulationModelLabel) || !((StandardPopulationModelLabel)nlabel).getPopulationIdentifier().equals(this.getPopulationIdentifier())) continue;
                StandardPopulationModelLabelValue splv = (StandardPopulationModelLabelValue)((StandardPopulationModelLabel)nlabel).getCurrentValue();
                splv.setCount(totalPop);
                PopulationLabelValue plv = ((StandardPopulationModelLabel)nlabel).getPopulationLabel().getCurrentPopulationValue();
                plv.setCount(totalPop);
            }
        }
    }

    private void initPipeTransport(Graph graph) {
        this.pipeTransportationNodeEdgesMap = new HashMap<Node, List<PipeTransportEdge>>();
        for (URI edgeURI : graph.getEdges().keySet()) {
            ArrayList<PipeTransportEdge> newList;
            Edge edge = (Edge)graph.getEdges().get((Object)edgeURI);
            if (!(edge instanceof PipeTransportEdge)) continue;
            PipeTransportEdge pedge = (PipeTransportEdge)edge;
            Node a = edge.getA();
            Node b = edge.getB();
            if (a != null) {
                if (this.pipeTransportationNodeEdgesMap.containsKey(a)) {
                    this.pipeTransportationNodeEdgesMap.get(a).add(pedge);
                } else {
                    newList = new ArrayList<PipeTransportEdge>();
                    newList.add(pedge);
                    this.pipeTransportationNodeEdgesMap.put(a, newList);
                }
            }
            if (b == null) continue;
            if (this.pipeTransportationNodeEdgesMap.containsKey(b)) {
                this.pipeTransportationNodeEdgesMap.get(b).add(pedge);
                continue;
            }
            newList = new ArrayList();
            newList.add(pedge);
            this.pipeTransportationNodeEdgesMap.put(b, newList);
        }
    }

    public void resetLabels() throws ScenarioInitializationException {
        super.resetLabels();
        this.populatePipeSystemNodes();
    }

    public List<IItemPropertyDescriptor> getCompartments(String populationIdentifier) {
        PopulationModelLabel label = this.createPopulationModelLabel(populationIdentifier);
        RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)label, RelativeValueProvider.class);
        if (rvp != null) {
            rvp.setTarget((Notifier)label);
            return rvp.getProperties();
        }
        return null;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 11: {
                return this.getPopulationIdentifier();
            }
            case 12: {
                return this.getName();
            }
            case 13: {
                return this.getTargetISOKey();
            }
            case 14: {
                return this.getInitialRescalingFactor();
            }
            case 15: {
                return this.getTimePeriod();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 11: {
                this.setPopulationIdentifier((String)newValue);
                return;
            }
            case 12: {
                this.setName((String)newValue);
                return;
            }
            case 13: {
                this.setTargetISOKey((String)newValue);
                return;
            }
            case 14: {
                this.setInitialRescalingFactor((Double)newValue);
                return;
            }
            case 15: {
                this.setTimePeriod((Long)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 11: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
            case 12: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 13: {
                this.setTargetISOKey(TARGET_ISO_KEY_EDEFAULT);
                return;
            }
            case 14: {
                this.setInitialRescalingFactor(1.0);
                return;
            }
            case 15: {
                this.setTimePeriod(86400000L);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 11: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
            case 12: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 13: {
                return TARGET_ISO_KEY_EDEFAULT == null ? this.targetISOKey != null : !TARGET_ISO_KEY_EDEFAULT.equals(this.targetISOKey);
            }
            case 14: {
                return this.initialRescalingFactor != 1.0;
            }
            case 15: {
                return this.timePeriod != 86400000L;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (populationIdentifier: ");
        result.append(this.populationIdentifier);
        result.append(", name: ");
        result.append(this.name);
        result.append(", targetISOKey: ");
        result.append(this.targetISOKey);
        result.append(", initialRescalingFactor: ");
        result.append(this.initialRescalingFactor);
        result.append(", timePeriod: ");
        result.append(this.timePeriod);
        result.append(')');
        return result.toString();
    }
}

