/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.views.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public abstract class ExecutablePluginView
extends ViewPart {
    private ListViewer lv;

    protected abstract ExecutableViewModel getInput();

    public void createPartControl(Composite parent) {
        this.lv = new ListViewer(parent);
        this.lv.setContentProvider((IContentProvider)new ExecutableContentProvider());
        this.lv.setLabelProvider((IBaseLabelProvider)new ExecutableLabelProvider());
        this.lv.setInput((Object)this.getInput());
        this.getSite().setSelectionProvider((ISelectionProvider)this.lv);
    }

    public void setFocus() {
    }

    public void dispose() {
        super.dispose();
    }

    public static class ExecutableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            return ((ExecutableViewModel)inputElement).getExecutables().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected static class ExecutableLabelProvider
    implements ILabelProvider {
        protected ExecutableLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            IConfigurationElement configElement = (IConfigurationElement)element;
            String retValue = configElement.getAttribute("name");
            return retValue;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    public static abstract class ExecutableViewModel {
        private List<IConfigurationElement> executables = new ArrayList<IConfigurationElement>();

        protected ExecutableViewModel(String extensionPointID, String executableElementName) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] configElements = registry.getConfigurationElementsFor(extensionPointID);
            int i = 0;
            while (i < configElements.length) {
                IConfigurationElement element = configElements[i];
                if (executableElementName.equals(element.getName())) {
                    this.executables.add(element);
                } else {
                    Activator.logError(MessageFormat.format(Messages.getString("IPView.Unexpected_Element"), element.getName(), extensionPointID), null);
                }
                ++i;
            }
        }

        protected final List<IConfigurationElement> getExecutables() {
            return this.executables;
        }
    }
}

