/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stem.core.common.provider.CommonItemProviderAdapterFactory;
import org.eclipse.stem.core.experiment.provider.ExperimentItemProviderAdapterFactory;
import org.eclipse.stem.core.graph.provider.GraphItemProviderAdapterFactory;
import org.eclipse.stem.core.model.provider.ModelItemProviderAdapterFactory;
import org.eclipse.stem.core.scenario.provider.ScenarioItemProviderAdapterFactory;
import org.eclipse.stem.core.sequencer.provider.SequencerItemProviderAdapterFactory;
import org.eclipse.stem.ui.Activator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.PropertySheet;

public abstract class IdentifiableEditor
extends MultiPageEditorPart
implements IMenuListener,
ISelectionProvider,
IEditingDomainProvider {
    protected static final Map<Object, Object> saveOptions = new HashMap<Object, Object>();
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected Viewer currentViewer;
    private final WorkspaceModifyOperation saveOperation = new WorkspaceModifyOperation(){

        protected void execute(IProgressMonitor monitor) {
            for (Resource resource : IdentifiableEditor.this.editingDomain.getResourceSet().getResources()) {
                if (resource.getContents().isEmpty() || IdentifiableEditor.this.editingDomain.isReadOnly(resource)) continue;
                try {
                    resource.save(saveOptions);
                }
                catch (Exception e) {
                    Activator.logError("Problem saving", e);
                }
            }
        }
    };
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (!(part instanceof ContentOutline) && !(part instanceof PropertySheet) && part == IdentifiableEditor.this) {
                IdentifiableEditor.this.handleActivate();
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private final ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            IdentifiableEditor.this.setSelection(event.getSelection());
        }
    };
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;

    static {
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
    }

    public IdentifiableEditor() {
        this.adapterFactory = this.createAdapterFactory();
        this.editingDomain = this.createEditingDomain((AdapterFactory)this.adapterFactory);
    }

    protected ComposedAdapterFactory createAdapterFactory() {
        ComposedAdapterFactory retValue = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        retValue.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        retValue.addAdapterFactory((AdapterFactory)new CommonItemProviderAdapterFactory());
        retValue.addAdapterFactory((AdapterFactory)new ExperimentItemProviderAdapterFactory());
        retValue.addAdapterFactory((AdapterFactory)new GraphItemProviderAdapterFactory());
        retValue.addAdapterFactory((AdapterFactory)new ModelItemProviderAdapterFactory());
        retValue.addAdapterFactory((AdapterFactory)new ScenarioItemProviderAdapterFactory());
        retValue.addAdapterFactory((AdapterFactory)new SequencerItemProviderAdapterFactory());
        retValue.addAdapterFactory((AdapterFactory)new EcoreItemProviderAdapterFactory());
        retValue.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        return retValue;
    }

    private AdapterFactoryEditingDomain createEditingDomain(AdapterFactory adapterFactory) {
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                IdentifiableEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IdentifiableEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                    }

                    private void setSelectionToViewer(final Collection<?> selection) {
                        if (selection != null && !selection.isEmpty()) {
                            new Runnable(){

                                @Override
                                public void run() {
                                    if (((this).this).IdentifiableEditor.this.currentViewer != null) {
                                        ((this).this).IdentifiableEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection((Object)selection));
                                    }
                                }
                            }.run();
                        }
                    }
                });
            }
        });
        return new AdapterFactoryEditingDomain(adapterFactory, (CommandStack)commandStack, new HashMap()){

            public Command createCommand(Class<? extends Command> commandClass, CommandParameter commandParameter) {
                if (commandClass == DeleteCommand.class) {
                    return super.createCommand(commandClass, commandParameter);
                }
                return super.createCommand(commandClass, commandParameter);
            }
        };
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
    }

    protected void createPages() {
        this.loadIdentifiable();
        if (!this.editingDomain.getResourceSet().getResources().isEmpty() && !((Resource)this.editingDomain.getResourceSet().getResources().get(0)).getContents().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            TreeViewer treeViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)treeViewer);
            treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
            treeViewer.setInput(this.editingDomain.getResourceSet().getResources().get(0));
            new AdapterFactoryTreeEditor(treeViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenu((StructuredViewer)treeViewer);
            this.addDragNDropSupport((StructuredViewer)treeViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, "tree editor");
            this.createIdentifiableSpecificPages();
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IdentifiableEditor.this.setActivePage(0);
                }
            });
        }
    }

    private void loadIdentifiable() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput());
        try {
            this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
    }

    private void setCurrentViewer(Viewer newViewer) {
        if (newViewer != this.currentViewer) {
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (newViewer != null) {
                newViewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = newViewer;
            this.setSelection((ISelection)(newViewer == null ? StructuredSelection.EMPTY : newViewer.getSelection()));
        }
    }

    private void createContextMenu(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    private void addDragNDropSupport(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), TextTransfer.getInstance()};
        viewer.addDragSupport(7, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(7, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer){

            public void dragEnter(DropTargetEvent event) {
                event.detail = 4;
                super.dragEnter(event);
            }

            protected Collection<?> extractDragSource(Object object) {
                if (object instanceof Collection) {
                    return (Collection)object;
                }
                return super.extractDragSource(object);
            }
        });
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    protected EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
    }

    protected void createIdentifiableSpecificPages() {
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)this.saveOperation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception e) {
            Activator.logError("Problem saving", e);
        }
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), new FileEditorInput(file));
        }
    }

    private void doSaveAs(URI uri, FileEditorInput fileEditorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify((IEditorInput)fileEditorInput);
        this.setPartName(fileEditorInput.getName());
        EditingDomainActionBarContributor edac = (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
        IStatusLineManager islm = edac.getActionBars().getStatusLineManager();
        IProgressMonitor progressMonitor = islm != null ? islm.getProgressMonitor() : new NullProgressMonitor();
        this.doSave(progressMonitor);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }
}

