/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.vector;

import java.util.List;
import org.eclipse.stem.core.STEMObjectPool;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.definitions.edges.MixingEdge;
import org.eclipse.stem.definitions.edges.impl.MixingEdgeLabelImpl;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.RoadTransportRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.impl.CommonBorderRelationshipLabelImpl;
import org.eclipse.stem.definitions.labels.impl.RoadTransportRelationshipLabelImpl;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.vector.DengueModelHostLabel;
import org.eclipse.stem.diseasemodels.vector.DengueModelHostLabelValue;
import org.eclipse.stem.diseasemodels.vector.SimpleDengueModelHostLabelValue;

public class DengueUtil {
    public STEMObjectPool dArrayObjectPool = new STEMObjectPool(5, 5){

        protected Object createNewObject() {
            return new double[16];
        }

        protected void resetObject(Object o) {
        }
    };

    public void getNormalizedEffectiveInfectious(StandardDiseaseModel diseaseModel, StandardDiseaseModelLabel diseaseLabel, double[] totalInfectious, boolean doCommonBorderMixing, STEMObjectPool edgeListObjectPool, double characteristicMixingDistance, double roadNetworkInfectiousProportion, String populationIdentifier, boolean frequencyDependent) {
        Node otherNode;
        int i;
        SimpleDengueModelHostLabelValue value = (SimpleDengueModelHostLabelValue)diseaseLabel.getProbeValue();
        totalInfectious[0] = value.getI1();
        totalInfectious[1] = value.getI12();
        totalInfectious[2] = value.getI13();
        totalInfectious[3] = value.getI14();
        totalInfectious[4] = value.getI2();
        totalInfectious[5] = value.getI21();
        totalInfectious[6] = value.getI23();
        totalInfectious[7] = value.getI24();
        totalInfectious[8] = value.getI3();
        totalInfectious[9] = value.getI31();
        totalInfectious[10] = value.getI32();
        totalInfectious[11] = value.getI34();
        totalInfectious[12] = value.getI4();
        totalInfectious[13] = value.getI41();
        totalInfectious[14] = value.getI42();
        totalInfectious[15] = value.getI43();
        if (characteristicMixingDistance == 0.0 && roadNetworkInfectiousProportion == 0.0) {
            return;
        }
        Node node = diseaseLabel.getNode();
        double totalPopulation = value.getPopulationCount();
        if (doCommonBorderMixing) {
            List cEdges = (List)edgeListObjectPool.get();
            cEdges.clear();
            CommonBorderRelationshipLabelImpl.getCommonBorderEdgesFromNode((Node)node, (List)cEdges);
            i = 0;
            while (i < cEdges.size()) {
                Edge borderEdge = (Edge)cEdges.get(i);
                otherNode = borderEdge.getOtherNode(node);
                double borderLength = ((CommonBorderRelationshipLabelValue)borderEdge.getLabel().getCurrentValue()).getBorderLength();
                double otherArea = 0.0;
                for (NodeLabel otherLabel : otherNode.getLabels()) {
                    if (!(otherLabel instanceof AreaLabel)) continue;
                    otherArea = ((AreaLabel)otherLabel).getCurrentAreaValue().getArea();
                    break;
                }
                double mixingFactor = Math.min(characteristicMixingDistance * borderLength / otherArea, 1.0);
                for (NodeLabel otherLabel : otherNode.getLabels()) {
                    StandardDiseaseModelLabel otherDiseaseLabel;
                    if (!(otherLabel instanceof StandardDiseaseModelLabel) || (otherDiseaseLabel = (StandardDiseaseModelLabel)otherLabel).getDecorator() != diseaseModel || !otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier()) || !(otherDiseaseLabel.getTempValue() instanceof SimpleDengueModelHostLabelValue)) continue;
                    SimpleDengueModelHostLabelValue otherValue = (SimpleDengueModelHostLabelValue)otherDiseaseLabel.getTempValue();
                    totalInfectious[0] = totalInfectious[0] + mixingFactor * otherValue.getI1();
                    totalInfectious[1] = totalInfectious[1] + mixingFactor * otherValue.getI12();
                    totalInfectious[2] = totalInfectious[2] + mixingFactor * otherValue.getI13();
                    totalInfectious[3] = totalInfectious[3] + mixingFactor * otherValue.getI14();
                    totalInfectious[4] = totalInfectious[4] + mixingFactor * otherValue.getI2();
                    totalInfectious[5] = totalInfectious[5] + mixingFactor * otherValue.getI21();
                    totalInfectious[6] = totalInfectious[6] + mixingFactor * otherValue.getI23();
                    totalInfectious[7] = totalInfectious[7] + mixingFactor * otherValue.getI24();
                    totalInfectious[8] = totalInfectious[8] + mixingFactor * otherValue.getI3();
                    totalInfectious[9] = totalInfectious[9] + mixingFactor * otherValue.getI31();
                    totalInfectious[10] = totalInfectious[10] + mixingFactor * otherValue.getI32();
                    totalInfectious[11] = totalInfectious[11] + mixingFactor * otherValue.getI34();
                    totalInfectious[12] = totalInfectious[12] + mixingFactor * otherValue.getI4();
                    totalInfectious[13] = totalInfectious[13] + mixingFactor * otherValue.getI41();
                    totalInfectious[14] = totalInfectious[14] + mixingFactor * otherValue.getI42();
                    totalInfectious[15] = totalInfectious[15] + mixingFactor * otherValue.getI43();
                    totalPopulation += mixingFactor * otherValue.getPopulationCount();
                    break;
                }
                ++i;
            }
            edgeListObjectPool.release((Object)cEdges);
        } else {
            List mEdges = (List)edgeListObjectPool.get();
            mEdges.clear();
            MixingEdgeLabelImpl.getMixingEdgesFromNode((Node)node, (String)populationIdentifier, (List)mEdges);
            i = 0;
            while (i < mEdges.size()) {
                MixingEdge mixingEdge = (MixingEdge)mEdges.get(i);
                otherNode = mixingEdge.getOtherNode(node);
                for (NodeLabel otherLabel : otherNode.getLabels()) {
                    DengueModelHostLabel otherDiseaseLabel;
                    if (!(otherLabel instanceof DengueModelHostLabel) || (otherDiseaseLabel = (DengueModelHostLabel)otherLabel).getDecorator() != this || !otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier())) continue;
                    DengueModelHostLabelValue otherValue = (DengueModelHostLabelValue)otherDiseaseLabel.getTempValue();
                    double otherPopulation = otherValue.getPopulationCount();
                    boolean useAbsoluteValue = mixingEdge.isUseAbsoluteValues();
                    double mixingRateOrAbs = mixingEdge.getLabel().getCurrentValue().getMixingRate();
                    if (useAbsoluteValue && otherPopulation > 0.0) {
                        if (mixingRateOrAbs > otherPopulation) {
                            mixingRateOrAbs = otherPopulation;
                        }
                        double fraction = mixingRateOrAbs / otherPopulation;
                        totalInfectious[0] = totalInfectious[0] + fraction * otherValue.getI1();
                        totalInfectious[1] = totalInfectious[1] + fraction * otherValue.getI12();
                        totalInfectious[2] = totalInfectious[2] + fraction * otherValue.getI13();
                        totalInfectious[3] = totalInfectious[3] + fraction * otherValue.getI14();
                        totalInfectious[4] = totalInfectious[4] + fraction * otherValue.getI2();
                        totalInfectious[5] = totalInfectious[5] + fraction * otherValue.getI21();
                        totalInfectious[6] = totalInfectious[6] + fraction * otherValue.getI23();
                        totalInfectious[7] = totalInfectious[7] + fraction * otherValue.getI24();
                        totalInfectious[8] = totalInfectious[8] + fraction * otherValue.getI3();
                        totalInfectious[9] = totalInfectious[9] + fraction * otherValue.getI31();
                        totalInfectious[10] = totalInfectious[10] + fraction * otherValue.getI32();
                        totalInfectious[11] = totalInfectious[11] + fraction * otherValue.getI34();
                        totalInfectious[12] = totalInfectious[12] + fraction * otherValue.getI4();
                        totalInfectious[13] = totalInfectious[13] + fraction * otherValue.getI41();
                        totalInfectious[14] = totalInfectious[14] + fraction * otherValue.getI42();
                        totalInfectious[15] = totalInfectious[15] + fraction * otherValue.getI43();
                        break;
                    }
                    if (frequencyDependent) {
                        totalInfectious[0] = totalInfectious[0] + mixingRateOrAbs * otherValue.getI1();
                        totalInfectious[1] = totalInfectious[1] + mixingRateOrAbs * otherValue.getI12();
                        totalInfectious[2] = totalInfectious[2] + mixingRateOrAbs * otherValue.getI13();
                        totalInfectious[3] = totalInfectious[3] + mixingRateOrAbs * otherValue.getI14();
                        totalInfectious[4] = totalInfectious[4] + mixingRateOrAbs * otherValue.getI2();
                        totalInfectious[5] = totalInfectious[5] + mixingRateOrAbs * otherValue.getI21();
                        totalInfectious[6] = totalInfectious[6] + mixingRateOrAbs * otherValue.getI23();
                        totalInfectious[7] = totalInfectious[7] + mixingRateOrAbs * otherValue.getI24();
                        totalInfectious[8] = totalInfectious[8] + mixingRateOrAbs * otherValue.getI3();
                        totalInfectious[9] = totalInfectious[9] + mixingRateOrAbs * otherValue.getI31();
                        totalInfectious[10] = totalInfectious[10] + mixingRateOrAbs * otherValue.getI32();
                        totalInfectious[11] = totalInfectious[11] + mixingRateOrAbs * otherValue.getI34();
                        totalInfectious[12] = totalInfectious[12] + mixingRateOrAbs * otherValue.getI4();
                        totalInfectious[13] = totalInfectious[13] + mixingRateOrAbs * otherValue.getI41();
                        totalInfectious[14] = totalInfectious[14] + mixingRateOrAbs * otherValue.getI42();
                        totalInfectious[15] = totalInfectious[15] + mixingRateOrAbs * otherValue.getI43();
                    }
                    totalPopulation += mixingRateOrAbs * otherPopulation;
                    break;
                }
                ++i;
            }
            edgeListObjectPool.release((Object)mEdges);
        }
        List rEdges = (List)edgeListObjectPool.get();
        rEdges.clear();
        RoadTransportRelationshipLabelImpl.getRoadEdgesFromNode((Node)node, (List)rEdges);
        i = 0;
        while (i < rEdges.size()) {
            Edge roadEdge = (Edge)rEdges.get(i);
            EdgeLabel edgeLabel = roadEdge.getLabel();
            double numCrossings = ((RoadTransportRelationshipLabelValue)edgeLabel.getCurrentValue()).getNumberCrossings();
            double infectiousProportion = Math.min(roadNetworkInfectiousProportion * numCrossings, 1.0);
            Node otherNode2 = roadEdge.getOtherNode(node);
            for (NodeLabel otherLabel : otherNode2.getLabels()) {
                DengueModelHostLabel otherDiseaseLabel;
                if (!(otherLabel instanceof DengueModelHostLabel) || (otherDiseaseLabel = (DengueModelHostLabel)otherLabel).getDecorator() != this || !otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier())) continue;
                DengueModelHostLabelValue otherValue = (DengueModelHostLabelValue)otherDiseaseLabel.getTempValue();
                if (frequencyDependent) {
                    totalInfectious[0] = totalInfectious[0] + infectiousProportion * otherValue.getI1();
                    totalInfectious[1] = totalInfectious[1] + infectiousProportion * otherValue.getI12();
                    totalInfectious[2] = totalInfectious[2] + infectiousProportion * otherValue.getI13();
                    totalInfectious[3] = totalInfectious[3] + infectiousProportion * otherValue.getI14();
                    totalInfectious[4] = totalInfectious[4] + infectiousProportion * otherValue.getI2();
                    totalInfectious[5] = totalInfectious[5] + infectiousProportion * otherValue.getI21();
                    totalInfectious[6] = totalInfectious[6] + infectiousProportion * otherValue.getI23();
                    totalInfectious[7] = totalInfectious[7] + infectiousProportion * otherValue.getI24();
                    totalInfectious[8] = totalInfectious[8] + infectiousProportion * otherValue.getI3();
                    totalInfectious[9] = totalInfectious[9] + infectiousProportion * otherValue.getI31();
                    totalInfectious[10] = totalInfectious[10] + infectiousProportion * otherValue.getI32();
                    totalInfectious[11] = totalInfectious[11] + infectiousProportion * otherValue.getI34();
                    totalInfectious[12] = totalInfectious[12] + infectiousProportion * otherValue.getI4();
                    totalInfectious[13] = totalInfectious[13] + infectiousProportion * otherValue.getI41();
                    totalInfectious[14] = totalInfectious[14] + infectiousProportion * otherValue.getI42();
                    totalInfectious[15] = totalInfectious[15] + infectiousProportion * otherValue.getI43();
                }
                totalPopulation += infectiousProportion * otherValue.getPopulationCount();
                break;
            }
            ++i;
        }
        edgeListObjectPool.release((Object)rEdges);
        if (totalPopulation > 0.0) {
            i = 0;
            while (i < totalInfectious.length) {
                totalInfectious[i] = totalInfectious[i] / totalPopulation;
                ++i;
            }
        } else {
            i = 0;
            while (i < totalInfectious.length) {
                totalInfectious[i] = 0.0;
                ++i;
            }
        }
    }
}

