/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.loggers.imagewriter.logger.projections;

import java.awt.geom.Rectangle2D;
import org.eclipse.stem.loggers.imagewriter.logger.projections.IMapProjection;

public class Mercator
implements IMapProjection {
    public static final double MAX_LAT = 85.05113;
    public static final double MIN_LAT = -85.05113;
    public static final Rectangle2D PROJECTION_BOUNDS = new Rectangle2D.Double(-180.0, -180.0, 360.0, 360.0);

    @Override
    public double[] project(double lat, double lon) {
        if (Math.abs(lat) > 85.05113) {
            return null;
        }
        double latR = Math.toRadians(lat);
        latR = Math.toDegrees(Math.log(Math.tan(latR) + 1.0 / Math.cos(latR)));
        return new double[]{latR, lon};
    }

    @Override
    public double[] project(double lat, double lon, double lat0, double lon0, boolean distort) {
        return this.project(lat, lon);
    }

    @Override
    public double[] inverseProject(double lat, double lon) {
        return new double[]{lat, lon};
    }

    @Override
    public double[] inverseProject(double lat, double lon, double lat0, double lon0, boolean distort) {
        return this.inverseProject(lat, lon);
    }

    @Override
    public void setOrigin(double lat, double lon) {
    }

    @Override
    public Rectangle2D getBounds() {
        return PROJECTION_BOUNDS;
    }
}

