/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stem.model.common.ModelProjectUtils;

public class ModelProjectNature
implements IProjectNature {
    public static final String ID = "org.eclipse.stem.model.common.ModelProjectNature";
    public static final String BUILDER_ID = "org.eclipse.stem.model.builder.MetamodelBuilder";
    public static final String OLD_BUILDER_ID = "org.eclipse.stem.model.codegen.MetamodelBuilder";
    private IProject project;

    public void configure() throws CoreException {
        ModelProjectNature.updateBuilders(this.getProject());
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(BUILDER_ID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                this.project.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                return;
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public static void updateBuilders(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        ArrayList<ICommand> builders = new ArrayList<ICommand>(commands.length);
        builders.addAll(Arrays.asList(commands));
        boolean hasCurrentBuilder = false;
        ListIterator iterator = builders.listIterator();
        while (iterator.hasNext()) {
            ICommand builder = (ICommand)iterator.next();
            if (builder.getBuilderName().equals(BUILDER_ID)) {
                hasCurrentBuilder = true;
            }
            if (!builder.getBuilderName().equals(OLD_BUILDER_ID)) continue;
            iterator.remove();
        }
        if (!hasCurrentBuilder) {
            ICommand command = desc.newCommand();
            command.setBuilderName(BUILDER_ID);
            builders.add(0, command);
        }
        desc.setBuildSpec(builders.toArray(new ICommand[builders.size()]));
        project.setDescription(desc, null);
    }

    public static void addNature(IProject project) throws CoreException {
        ModelProjectUtils.addProjectNature(project, ID);
    }

    public static void removeNature(IProject project) throws CoreException {
        ModelProjectUtils.removeProjectNature(project, ID);
    }

    public static boolean hasNature(IProject project) throws CoreException {
        return project.hasNature(ID);
    }
}

