/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.solvers.fd.impl;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.IntegrationDecorator;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.model.TransformationDecorator;
import org.eclipse.stem.core.solver.SolverException;
import org.eclipse.stem.core.solver.impl.SolverImpl;
import org.eclipse.stem.core.trigger.Trigger;
import org.eclipse.stem.core.trigger.TriggerList;
import org.eclipse.stem.solvers.fd.FdPackage;
import org.eclipse.stem.solvers.fd.FiniteDifference;
import org.eclipse.stem.solvers.fd.impl.FdJob;
import org.eclipse.stem.ui.Activator;

public class FiniteDifferenceImpl
extends SolverImpl
implements FiniteDifference {
    protected static final double MIN_STEP_EDEFAULT = 1.0E-15;
    protected double minStep = 1.0E-15;
    private FdJob[] jobs;
    private short num_threads;
    private static final int MAX_PROGRESS_REPORTS = 5;

    public boolean step(STEMTime time, long timeDelta, int cycle) throws SolverException {
        Activator act = Activator.getDefault();
        if (act != null) {
            IPreferenceStore preferenceStore = act.getPreferenceStore();
            this.num_threads = (short)preferenceStore.getInt("simulationThreads");
        } else {
            this.num_threads = (short)2;
        }
        this.partitioner.setNumProcesses((int)this.num_threads);
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            if (!(decorator instanceof Trigger) && !(decorator instanceof TriggerList) && !(decorator instanceof TransformationDecorator)) continue;
            decorator.updateLabels(time, timeDelta, cycle);
        }
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            EList allLabels = decorator.getLabelsToUpdate();
            Iterator currentStateLabelIter = allLabels.iterator();
            while (currentStateLabelIter.hasNext()) {
                if (decorator instanceof IntegrationDecorator) {
                    IntegrationLabel iLabel = (IntegrationLabel)currentStateLabelIter.next();
                    ((IntegrationLabelValue)iLabel.getCurrentValue()).prepareCycle();
                    iLabel.getProbeValue().set((IntegrationLabelValue)iLabel.getCurrentValue());
                    iLabel.getTempValue().set((IntegrationLabelValue)iLabel.getCurrentValue());
                    continue;
                }
                currentStateLabelIter.next();
            }
        }
        if (this.jobs == null || this.jobs.length != this.num_threads) {
            this.jobs = new FdJob[this.num_threads];
            int i = 0;
            while (i < this.num_threads) {
                short threadnum = (short)i;
                this.jobs[i] = new FdJob("Finite Difference Worker " + i, threadnum, this);
                this.jobs[i].setSystem(true);
                ++i;
            }
        }
        this.iterativeStep(time, timeDelta, cycle);
        return true;
    }

    protected void iterativeStep(STEMTime time, long timeDelta, int cycle) throws SolverException {
        block26: {
            double factor;
            double t0;
            double scaling = 1.0;
            double t = t0 = cycle == 0 ? (double)cycle : (double)cycle - 1.0;
            while (true) {
                FdJob j;
                Object object = this.jobs;
                int n = this.jobs.length;
                int n2 = 0;
                while (n2 < n) {
                    j = object[n2];
                    j.cycle = cycle;
                    j.time = time;
                    j.timeDelta = timeDelta;
                    j.t = t;
                    j.step = FdJob.COMPUTE_DELTAS;
                    j.schedule();
                    ++n2;
                }
                object = this.jobs;
                n = this.jobs.length;
                n2 = 0;
                while (n2 < n) {
                    j = object[n2];
                    try {
                        j.join();
                        if (j.getResult().getSeverity() == 8 && j.getResult().getException() != null) {
                            throw new SolverException(j.getResult().getException().getMessage(), null, j.getResult().getException());
                        }
                    }
                    catch (InterruptedException ie) {
                        Activator.logError((String)ie.getMessage(), (Throwable)ie);
                    }
                    ++n2;
                }
                this.scaleAllDeltas(scaling);
                object = this.jobs;
                n = this.jobs.length;
                n2 = 0;
                while (n2 < n) {
                    j = object[n2];
                    j.step = FdJob.CHECK_DELTAS;
                    j.schedule();
                    ++n2;
                }
                object = this.jobs;
                n = this.jobs.length;
                n2 = 0;
                while (n2 < n) {
                    j = object[n2];
                    try {
                        j.join();
                        if (j.getResult().getSeverity() == 8 && j.getResult().getException() != null) {
                            throw new SolverException(j.getResult().getException().getMessage(), null, j.getResult().getException());
                        }
                    }
                    catch (InterruptedException ie) {
                        Activator.logError((String)ie.getMessage(), (Throwable)ie);
                    }
                    ++n2;
                }
                factor = 1.0;
                FdJob[] fdJobArray = this.jobs;
                int ie = this.jobs.length;
                int n3 = 0;
                while (n3 < ie) {
                    FdJob j2 = fdJobArray[n3];
                    factor = Math.min(factor, j2.adjustmentFactor);
                    ++n3;
                }
                if (factor == 1.0) {
                    fdJobArray = this.jobs;
                    ie = this.jobs.length;
                    n3 = 0;
                    while (n3 < ie) {
                        FdJob j3 = fdJobArray[n3];
                        j3.step = FdJob.APPLY_DELTAS;
                        j3.schedule();
                        ++n3;
                    }
                    fdJobArray = this.jobs;
                    ie = this.jobs.length;
                    n3 = 0;
                    while (n3 < ie) {
                        FdJob j4 = fdJobArray[n3];
                        try {
                            j4.join();
                            if (j4.getResult().getSeverity() == 8 && j4.getResult().getException() != null) {
                                throw new SolverException(j4.getResult().getException().getMessage(), null, j4.getResult().getException());
                            }
                        }
                        catch (InterruptedException ie2) {
                            Activator.logError((String)ie2.getMessage(), (Throwable)ie2);
                        }
                        ++n3;
                    }
                    break block26;
                }
                if (!(factor > 0.0)) break;
                this.scaleAllDeltas(factor);
                fdJobArray = this.jobs;
                ie = this.jobs.length;
                n3 = 0;
                while (n3 < ie) {
                    FdJob j5 = fdJobArray[n3];
                    j5.step = FdJob.APPLY_DELTAS;
                    j5.schedule();
                    ++n3;
                }
                fdJobArray = this.jobs;
                ie = this.jobs.length;
                n3 = 0;
                while (n3 < ie) {
                    FdJob j6 = fdJobArray[n3];
                    try {
                        j6.join();
                        if (j6.getResult().getSeverity() == 8 && j6.getResult().getException() != null) {
                            throw new SolverException(j6.getResult().getException().getMessage(), null, j6.getResult().getException());
                        }
                    }
                    catch (InterruptedException ie3) {
                        Activator.logError((String)ie3.getMessage(), (Throwable)ie3);
                    }
                    ++n3;
                }
                for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
                    EList allLabels = decorator.getLabelsToUpdate();
                    Iterator currentStateLabelIter = allLabels.iterator();
                    while (currentStateLabelIter.hasNext()) {
                        if (decorator instanceof IntegrationDecorator) {
                            IntegrationLabel iLabel = (IntegrationLabel)currentStateLabelIter.next();
                            iLabel.getProbeValue().set((IntegrationLabelValue)iLabel.getNextValue());
                            iLabel.getTempValue().set((IntegrationLabelValue)iLabel.getNextValue());
                            continue;
                        }
                        currentStateLabelIter.next();
                    }
                }
                scaling -= factor * scaling;
                t = t0 + (1.0 - scaling);
            }
            System.out.println("factor: " + factor);
            Activator.logError((String)"Attempted finite difference step rescaling but the scaling factor was 0", (Throwable)new Exception());
        }
    }

    protected void computeDeltasStep(STEMTime time, double t, long timeDelta, short threadnum) {
        BasicEList iDecorators = new BasicEList();
        BasicEList transDecorators = new BasicEList();
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            if (decorator.isEnabled() && decorator instanceof IntegrationDecorator) {
                iDecorators.add((Object)((IntegrationDecorator)decorator));
            }
            if (!(decorator instanceof TransformationDecorator)) continue;
            transDecorators.add((Object)((TransformationDecorator)decorator));
        }
        for (IntegrationDecorator imodel : iDecorators) {
            imodel.calculateDeltas(time, t, timeDelta, this.partitioner.partitionDecoratorLabels((Decorator)imodel, (int)threadnum));
        }
        for (IntegrationDecorator imodel : iDecorators) {
            imodel.applyExternalDeltas(time, t, timeDelta, this.partitioner.partitionDecoratorLabels((Decorator)imodel, (int)threadnum));
        }
    }

    protected double checkDeltasStep(short threadnum) throws SolverException {
        BasicEList iDecorators = new BasicEList();
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            if (!decorator.isEnabled() || !(decorator instanceof IntegrationDecorator)) continue;
            iDecorators.add((Object)((IntegrationDecorator)decorator));
        }
        double factor = 1.0;
        for (IntegrationDecorator imodel : iDecorators) {
            factor = Math.min(factor, this.getDeltaAdjustment((Decorator)imodel, threadnum));
        }
        return factor;
    }

    protected void applyDeltasStep(short threadnum, long timeDelta) {
        BasicEList iDecorators = new BasicEList();
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            if (!decorator.isEnabled() || !(decorator instanceof IntegrationDecorator)) continue;
            iDecorators.add((Object)((IntegrationDecorator)decorator));
        }
        for (IntegrationDecorator imodel : iDecorators) {
            this.updateStandardDiseaseModelLabels((Decorator)imodel, threadnum, timeDelta);
        }
    }

    protected void scaleAllDeltas(double scaling) {
        for (Decorator decorator : this.getCanonicalGraph().getDecorators()) {
            EList allLabels = decorator.getLabelsToUpdate();
            Iterator currentStateLabelIter = allLabels.iterator();
            while (currentStateLabelIter.hasNext()) {
                if (decorator instanceof IntegrationDecorator) {
                    IntegrationLabel iLabel = (IntegrationLabel)currentStateLabelIter.next();
                    iLabel.getDeltaValue().scale(scaling);
                    continue;
                }
                currentStateLabelIter.next();
            }
        }
    }

    protected double getDeltaAdjustment(Decorator model, short threadnum) throws SolverException {
        EList myLabels = this.partitioner.partitionDecoratorLabels(model, (int)threadnum);
        double factor = 1.0;
        for (IntegrationLabel label : myLabels) {
            IntegrationLabelValue delta = label.getDeltaValue();
            if (!((factor = Math.min(factor, delta.computeDeltaAdjustment(label.getTempValue()))) < this.minStep)) continue;
            String current = label.getTempValue().toString();
            String deltaSTR = label.getDeltaValue().toString();
            String msg = "Error: \n FiniteDifferenceImpl.getDeltaAdjustment(): Step size is below minimum!!.\n Probably Error in Disease or Population Model: current label: " + current + " deltaLabel: " + deltaSTR;
            throw new SolverException(msg, null, null);
        }
        return factor;
    }

    protected void updateStandardDiseaseModelLabels(Decorator model, short threadnum, long timeDelta) {
        EList myLabels = this.partitioner.partitionDecoratorLabels(model, (int)threadnum);
        IntegrationDecorator imodel = (IntegrationDecorator)model;
        int numLabels = myLabels.size();
        int setProgressEveryNthNode = this.num_threads * numLabels / 5;
        if (setProgressEveryNthNode == 0) {
            setProgressEveryNthNode = 1;
        }
        int n = 0;
        for (IntegrationLabel label : myLabels) {
            LabelValue nextState = label.getNextValue();
            IntegrationLabelValue delta = label.getDeltaValue();
            delta.avoidNegative(label.getProbeValue());
            nextState.reset();
            ((IntegrationLabelValue)nextState).add(delta);
            ((IntegrationLabelValue)nextState).add(label.getTempValue());
            if (imodel.isAddStochasticNoise()) {
                imodel.doStochasticProcess(label, timeDelta);
            }
            label.setNextValueValid(true);
            double progress = (double)n / (double)numLabels;
            this.jobs[threadnum].setProgress(progress);
            if (n % setProgressEveryNthNode == 0) {
                int i = 0;
                while (i < this.num_threads) {
                    if (i != threadnum && this.jobs[i] != null) {
                        progress += this.jobs[i].getProgress();
                    }
                    ++i;
                }
                model.setProgress(progress /= (double)this.num_threads);
            }
            ++n;
        }
    }

    public void reset() {
        this.setInitialized(false);
    }

    protected EClass eStaticClass() {
        return FdPackage.Literals.FINITE_DIFFERENCE;
    }

    @Override
    public double getMinStep() {
        return this.minStep;
    }

    @Override
    public void setMinStep(double newMinStep) {
        double oldMinStep = this.minStep;
        this.minStep = newMinStep;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldMinStep, this.minStep));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getMinStep();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setMinStep((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setMinStep(1.0E-15);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.minStep != 1.0E-15;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (minStep: ");
        result.append(this.minStep);
        result.append(')');
        return result.toString();
    }
}

