/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.featuremodifiereditcomposite;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.modifier.DoubleRangeModifier;
import org.eclipse.stem.core.modifier.FeatureModifier;
import org.eclipse.stem.core.modifier.IntegerRangeModifier;
import org.eclipse.stem.core.modifier.LongRangeModifier;
import org.eclipse.stem.core.modifier.STEMTimeRangeModifier;
import org.eclipse.stem.ui.adapters.featuremodifiereditcomposite.FeatureModifierEditCompositeAdapter;
import org.eclipse.stem.ui.wizards.NewModifierPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class RangeFeatureModifierEditCompositeAdapter
extends FeatureModifierEditCompositeAdapter {
    @Override
    public void setSelectedButton(Button noneButton, Button singleValueButton, Button rangeButton, Button sequenceButton) {
        noneButton.setSelection(false);
        singleValueButton.setSelection(false);
        rangeButton.setSelection(true);
        sequenceButton.setSelection(false);
    }

    public static class DoubleRangeFeatureModifierEditCompositeAdapter
    extends NumericRangeFeatureModifierEditCompositeAdapter {
        @Override
        protected void initializeFeatureModifier(EObject target) {
            DoubleRangeModifier rangeModifier = (DoubleRangeModifier)this.getFeatureModifier();
            rangeModifier.setStartValue(((Double)this.getFeatureModifier().getTarget().eGet(this.getFeatureModifier().getEStructuralFeature())).doubleValue());
            rangeModifier.setEndValue(rangeModifier.getStartValue());
        }

        @Override
        protected String getInitialEndText() {
            return Double.toString(((DoubleRangeModifier)this.getFeatureModifier()).getEndValue());
        }

        @Override
        protected String getInitialIncrementText() {
            return Double.toString(((DoubleRangeModifier)this.getFeatureModifier()).getIncrement());
        }

        @Override
        protected String getInitialStartText() {
            return Double.toString(((DoubleRangeModifier)this.getFeatureModifier()).getStartValue());
        }

        @Override
        protected NewModifierPage.FeatureModifierEditComposite getFeatureModifierEditComposite(Composite parent, NewModifierPage parentNewModifierPage) {
            NewModifierPage.FeatureModifierEditComposite retValue = new NewModifierPage.FeatureModifierEditComposite(parent, parentNewModifierPage, (FeatureModifier)this.getTarget()){

                @Override
                protected boolean validate() {
                    boolean retValue = true;
                    String message = null;
                    double startValue = 0.0;
                    double endValue = 0.0;
                    double incValue = 0.0;
                    if (retValue) {
                        try {
                            startValue = Double.parseDouble(DoubleRangeFeatureModifierEditCompositeAdapter.this.startText.getText());
                            ((DoubleRangeModifier)this.featureModifier).setStartValue(startValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            retValue = false;
                            message = "Start value not valid";
                        }
                    }
                    if (retValue) {
                        try {
                            endValue = Double.parseDouble(DoubleRangeFeatureModifierEditCompositeAdapter.this.endText.getText());
                            ((DoubleRangeModifier)this.featureModifier).setEndValue(endValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            retValue = false;
                            message = "End value not valid";
                        }
                    }
                    if (retValue) {
                        try {
                            incValue = Double.parseDouble(DoubleRangeFeatureModifierEditCompositeAdapter.this.incText.getText());
                            ((DoubleRangeModifier)this.featureModifier).setIncrement(incValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            retValue = false;
                            message = "Increment value not valid";
                        }
                    }
                    if (retValue) {
                        if (startValue <= endValue && incValue < 0.0) {
                            retValue = false;
                            message = "If the start is <= the end, then the increment cannont be < 0.0";
                        } else if (startValue > endValue && incValue >= 0.0) {
                            retValue = false;
                            message = "If the start is > the end, then the increment cannont be >= 0.0";
                        }
                    }
                    if (message != null) {
                        this.parentNewModifierPage.setErrorMessage(message);
                    }
                    if (retValue) {
                        retValue = this.parentNewModifierPage.validatePage();
                    }
                    return retValue;
                }
            };
            return retValue;
        }
    }

    public static class IntegerRangeFeatureModifierEditCompositeAdapter
    extends NumericRangeFeatureModifierEditCompositeAdapter {
        @Override
        protected void initializeFeatureModifier(EObject target) {
            IntegerRangeModifier rangeModifier = (IntegerRangeModifier)this.getFeatureModifier();
            rangeModifier.setStartValue(((Integer)this.getFeatureModifier().getTarget().eGet(this.getFeatureModifier().getEStructuralFeature())).intValue());
            rangeModifier.setEndValue(rangeModifier.getStartValue());
        }

        @Override
        protected String getInitialEndText() {
            return Integer.toString(((IntegerRangeModifier)this.getFeatureModifier()).getEndValue());
        }

        @Override
        protected String getInitialIncrementText() {
            return Integer.toString(((IntegerRangeModifier)this.getFeatureModifier()).getIncrement());
        }

        @Override
        protected String getInitialStartText() {
            return Integer.toString(((IntegerRangeModifier)this.getFeatureModifier()).getStartValue());
        }

        @Override
        protected NewModifierPage.FeatureModifierEditComposite getFeatureModifierEditComposite(Composite parent, NewModifierPage parentNewModifierPage) {
            NewModifierPage.FeatureModifierEditComposite retValue = new NewModifierPage.FeatureModifierEditComposite(parent, parentNewModifierPage, (FeatureModifier)this.getTarget()){

                @Override
                protected boolean validate() {
                    boolean retValue = true;
                    String message = null;
                    int startValue = 0;
                    int endValue = 0;
                    int incValue = 0;
                    if (retValue) {
                        try {
                            startValue = Integer.parseInt(IntegerRangeFeatureModifierEditCompositeAdapter.this.startText.getText());
                            ((IntegerRangeModifier)this.featureModifier).setStartValue(startValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            retValue = false;
                            message = "Start value not valid";
                        }
                    }
                    if (retValue) {
                        try {
                            endValue = Integer.parseInt(IntegerRangeFeatureModifierEditCompositeAdapter.this.endText.getText());
                            ((IntegerRangeModifier)this.featureModifier).setEndValue(endValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            retValue = false;
                            message = "End value not valid";
                        }
                    }
                    if (retValue) {
                        try {
                            incValue = Integer.parseInt(IntegerRangeFeatureModifierEditCompositeAdapter.this.incText.getText());
                            ((IntegerRangeModifier)this.featureModifier).setIncrement(incValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            retValue = false;
                            message = "Increment value not valid";
                        }
                    }
                    if (retValue) {
                        if (startValue <= endValue && (long)incValue < 0L) {
                            retValue = false;
                            message = "If the start is <= the end, then the increment cannont be < 0.0";
                        } else if (startValue > endValue && (long)incValue >= 0L) {
                            retValue = false;
                            message = "If the start is > the end, then the increment cannont be >= 0.0";
                        }
                    }
                    if (message != null) {
                        this.parentNewModifierPage.setErrorMessage(message);
                    }
                    if (retValue) {
                        retValue = this.parentNewModifierPage.validatePage();
                    }
                    return retValue;
                }
            };
            return retValue;
        }
    }

    public static class LongRangeFeatureModifierEditCompositeAdapter
    extends NumericRangeFeatureModifierEditCompositeAdapter {
        @Override
        protected void initializeFeatureModifier(EObject target) {
            LongRangeModifier rangeModifier = (LongRangeModifier)this.getFeatureModifier();
            rangeModifier.setStartValue(((Long)this.getFeatureModifier().getTarget().eGet(this.getFeatureModifier().getEStructuralFeature())).longValue());
            rangeModifier.setEndValue(rangeModifier.getStartValue());
        }

        @Override
        protected String getInitialEndText() {
            return Long.toString(((LongRangeModifier)this.getFeatureModifier()).getEndValue());
        }

        @Override
        protected String getInitialIncrementText() {
            return Long.toString(((LongRangeModifier)this.getFeatureModifier()).getIncrement());
        }

        @Override
        protected String getInitialStartText() {
            return Long.toString(((LongRangeModifier)this.getFeatureModifier()).getStartValue());
        }

        @Override
        protected NewModifierPage.FeatureModifierEditComposite getFeatureModifierEditComposite(Composite parent, NewModifierPage parentNewModifierPage) {
            NewModifierPage.FeatureModifierEditComposite retValue = new NewModifierPage.FeatureModifierEditComposite(parent, parentNewModifierPage, (FeatureModifier)this.getTarget()){

                @Override
                protected boolean validate() {
                    boolean retValue = true;
                    String message = null;
                    long startValue = 0L;
                    long endValue = 0L;
                    long incValue = 0L;
                    if (retValue) {
                        try {
                            startValue = Long.parseLong(LongRangeFeatureModifierEditCompositeAdapter.this.startText.getText());
                            ((LongRangeModifier)this.featureModifier).setStartValue(startValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            retValue = false;
                            message = "Start value not valid";
                        }
                    }
                    if (retValue) {
                        try {
                            endValue = Long.parseLong(LongRangeFeatureModifierEditCompositeAdapter.this.endText.getText());
                            ((LongRangeModifier)this.featureModifier).setEndValue(endValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            retValue = false;
                            message = "End value not valid";
                        }
                    }
                    if (retValue) {
                        try {
                            incValue = Long.parseLong(LongRangeFeatureModifierEditCompositeAdapter.this.incText.getText());
                            ((LongRangeModifier)this.featureModifier).setIncrement(incValue);
                        }
                        catch (NumberFormatException numberFormatException) {
                            retValue = false;
                            message = "Increment value not valid";
                        }
                    }
                    if (retValue) {
                        if (startValue <= endValue && incValue < 0L) {
                            retValue = false;
                            message = "If the start is <= the end, then the increment cannont be < 0.0";
                        } else if (startValue > endValue && incValue >= 0L) {
                            retValue = false;
                            message = "If the start is > the end, then the increment cannont be >= 0.0";
                        }
                    }
                    if (message != null) {
                        this.parentNewModifierPage.setErrorMessage(message);
                    }
                    if (retValue) {
                        retValue = this.parentNewModifierPage.validatePage();
                    }
                    return retValue;
                }
            };
            return retValue;
        }
    }

    protected static abstract class NumericRangeFeatureModifierEditCompositeAdapter
    extends RangeFeatureModifierEditCompositeAdapter {
        private static final int TEXT_WIDTH = 30;
        protected Text startText;
        protected Text endText;
        protected Text incText;

        protected NumericRangeFeatureModifierEditCompositeAdapter() {
        }

        protected abstract void initializeFeatureModifier(EObject var1);

        protected abstract String getInitialStartText();

        protected abstract String getInitialEndText();

        protected abstract String getInitialIncrementText();

        @Override
        public NewModifierPage.FeatureModifierEditComposite createEditComposite(Composite parent, EObject target, NewModifierPage parentNewModifierPage) {
            this.initializeFeatureModifier(target);
            NewModifierPage.FeatureModifierEditComposite retValue = this.getFeatureModifierEditComposite(parent, parentNewModifierPage);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            retValue.setLayout((Layout)layout);
            this.startText = new Text((Composite)retValue, 133120);
            this.startText.setText(this.getInitialStartText());
            this.startText.setToolTipText("Starting value");
            this.startText.addModifyListener(retValue.getModifyListener());
            Label toLabel = new Label((Composite)retValue, 0);
            toLabel.setText(" to ");
            this.endText = new Text((Composite)retValue, 133120);
            this.endText.setText(this.getInitialEndText());
            this.endText.setToolTipText("Ending value");
            this.endText.addModifyListener(retValue.getModifyListener());
            Label byLabel = new Label((Composite)retValue, 0);
            byLabel.setText(" by ");
            this.incText = new Text((Composite)retValue, 133120);
            this.incText.setText(this.getInitialIncrementText());
            this.incText.setToolTipText("Increment");
            this.incText.addModifyListener(retValue.getModifyListener());
            FormData formData = null;
            formData = new FormData();
            formData.width = 30;
            formData.left = new FormAttachment(0, 0);
            formData.bottom = new FormAttachment(100, 0);
            this.startText.setLayoutData((Object)formData);
            formData = new FormData();
            formData.left = new FormAttachment((Control)this.startText, 0, 131072);
            formData.bottom = new FormAttachment((Control)this.startText, 0, 1024);
            toLabel.setLayoutData((Object)formData);
            formData = new FormData();
            formData.width = 30;
            formData.left = new FormAttachment((Control)toLabel, 0, 131072);
            formData.bottom = new FormAttachment((Control)toLabel, 0, 1024);
            this.endText.setLayoutData((Object)formData);
            formData = new FormData();
            formData.left = new FormAttachment((Control)this.endText, 0, 131072);
            formData.bottom = new FormAttachment((Control)this.endText, 0, 1024);
            byLabel.setLayoutData((Object)formData);
            formData = new FormData();
            formData.width = 30;
            formData.left = new FormAttachment((Control)byLabel, 0, 131072);
            formData.right = new FormAttachment(100, 0);
            formData.bottom = new FormAttachment((Control)byLabel, 0, 1024);
            this.incText.setLayoutData((Object)formData);
            return retValue;
        }

        protected abstract NewModifierPage.FeatureModifierEditComposite getFeatureModifierEditComposite(Composite var1, NewModifierPage var2);
    }

    public static class STEMTimeRangeFeatureModifierEditCompositeAdapter
    extends RangeFeatureModifierEditCompositeAdapter {
        @Override
        public NewModifierPage.FeatureModifierEditComposite createEditComposite(Composite parent, EObject target, NewModifierPage parentNewModifierPage) {
            NewModifierPage.FeatureModifierEditComposite retValue = new NewModifierPage.FeatureModifierEditComposite(parent, parentNewModifierPage, (FeatureModifier)this.getTarget()){

                @Override
                protected boolean validate() {
                    boolean retValue = this.parentNewModifierPage.validatePage();
                    return retValue;
                }
            };
            retValue.setLayout((Layout)new RowLayout());
            Label label = new Label((Composite)retValue, 0);
            STEMTimeRangeModifier rangeModifier = (STEMTimeRangeModifier)this.getFeatureModifier();
            rangeModifier.setStartValue((STEMTime)this.getFeatureModifier().getTarget().eGet(this.getFeatureModifier().getEStructuralFeature()));
            rangeModifier.setEndValue(rangeModifier.getStartValue());
            StringBuilder sb = new StringBuilder(rangeModifier.getStartValue().toString());
            sb.append(" to ");
            sb.append(rangeModifier.getEndValue().toString());
            sb.append(" by ");
            sb.append(rangeModifier.getIncrement());
            label.setText(sb.toString());
            return retValue;
        }
    }
}

