/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.TreePath;

public class FilterTransform {
    private Node root = new Node();

    public boolean addFilteredIndex(TreePath parentPath, int childIndex, Object element) {
        return this.root.addFilter(parentPath, childIndex, 0, element);
    }

    public void clear() {
        this.root = new Node();
    }

    public void clear(TreePath path) {
        this.root.clear(path, 0);
    }

    public void clear(TreePath parentPath, int index) {
        this.root.clear(parentPath, index, 0);
    }

    public int indexOfFilteredElement(TreePath parentPath, Object element) {
        Node parentNode = this.root.find(parentPath, 0);
        if (parentNode == null) {
            return -1;
        }
        return parentNode.indexOfFilteredElement(element);
    }

    public int modelToViewIndex(TreePath parentPath, int childIndex) {
        Node parentNode = this.root.find(parentPath, 0);
        if (parentNode == null) {
            return childIndex;
        }
        return parentNode.modelToView(childIndex);
    }

    public int viewToModelIndex(TreePath parentPath, int childIndex) {
        Node parentNode = this.root.find(parentPath, 0);
        if (parentNode == null) {
            return childIndex;
        }
        return parentNode.viewToModel(childIndex);
    }

    public int viewToModelCount(TreePath parentPath, int viewCount) {
        Node parentNode = this.root.find(parentPath, 0);
        if (parentNode != null && parentNode.filteredIndexes != null) {
            return viewCount + parentNode.filteredIndexes.length;
        }
        return viewCount;
    }

    public int modelToViewCount(TreePath parentPath, int count) {
        Node parentNode = this.root.find(parentPath, 0);
        if (parentNode == null) {
            return count;
        }
        return parentNode.modelToViewCount(count);
    }

    public boolean isFiltered(TreePath parentPath, int index) {
        Node parentNode = this.root.find(parentPath, 0);
        if (parentNode == null) {
            return false;
        }
        return parentNode.isFiltered(index);
    }

    public int[] getFilteredChildren(TreePath parentPath) {
        Node parentNode = this.root.find(parentPath, 0);
        if (parentNode == null) {
            return null;
        }
        return parentNode.filteredIndexes;
    }

    public void setModelChildCount(TreePath parentPath, int childCount) {
        Node parentNode = this.root.find(parentPath, 0);
        if (parentNode != null) {
            parentNode.setModelChildCount(childCount);
        }
    }

    public void removeElementFromFilters(TreePath parentPath, int index) {
        Node parentNode = this.root.find(parentPath, 0);
        if (parentNode != null) {
            parentNode.removeElementFromFilters(index);
        }
    }

    public boolean removeElementFromFilters(TreePath parentPath, Object element) {
        int index;
        Node parentNode = this.root.find(parentPath, 0);
        if (parentNode != null && (index = parentNode.indexOfFilteredElement(element)) >= 0) {
            parentNode.removeElementFromFilters(index);
            return true;
        }
        return false;
    }

    class Node {
        private int[] filteredIndexes = null;
        private Object[] filteredElements = null;
        private Map children = null;

        Node() {
        }

        boolean addFilter(TreePath path, int childIndex, int pathIndex, Object filtered) {
            Object element;
            Node node;
            if (pathIndex == path.getSegmentCount()) {
                if (this.filteredIndexes == null) {
                    this.filteredIndexes = new int[]{childIndex};
                    this.filteredElements = new Object[]{filtered};
                    return true;
                }
                int location = Arrays.binarySearch(this.filteredIndexes, childIndex);
                if (location >= 0) {
                    return false;
                }
                location = 0 - (location + 1);
                int[] next = new int[this.filteredIndexes.length + 1];
                Object[] filt = new Object[next.length];
                if (location == 0) {
                    next[0] = childIndex;
                    filt[0] = filtered;
                    System.arraycopy(this.filteredIndexes, 0, next, 1, this.filteredIndexes.length);
                    System.arraycopy(this.filteredElements, 0, filt, 1, this.filteredElements.length);
                } else if (location == this.filteredIndexes.length) {
                    next[this.filteredIndexes.length] = childIndex;
                    filt[this.filteredElements.length] = filtered;
                    System.arraycopy(this.filteredIndexes, 0, next, 0, this.filteredIndexes.length);
                    System.arraycopy(this.filteredElements, 0, filt, 0, this.filteredElements.length);
                } else {
                    System.arraycopy(this.filteredIndexes, 0, next, 0, location);
                    System.arraycopy(this.filteredElements, 0, filt, 0, location);
                    next[location] = childIndex;
                    filt[location] = filtered;
                    System.arraycopy(this.filteredIndexes, location, next, location + 1, this.filteredIndexes.length - location);
                    System.arraycopy(this.filteredElements, location, filt, location + 1, this.filteredElements.length - location);
                }
                this.filteredIndexes = next;
                this.filteredElements = filt;
                return true;
            }
            if (this.children == null) {
                this.children = new HashMap();
            }
            if ((node = (Node)this.children.get(element = path.getSegment(pathIndex))) == null) {
                node = new Node();
                this.children.put(element, node);
            }
            return node.addFilter(path, childIndex, pathIndex + 1, filtered);
        }

        boolean clear(TreePath path, int pathIndex) {
            if (pathIndex == path.getSegmentCount()) {
                return true;
            }
            if (this.children == null) {
                return false;
            }
            Object child = path.getSegment(pathIndex);
            Node node = (Node)this.children.get(child);
            if (node != null && node.clear(path, pathIndex + 1)) {
                this.children.remove(child);
            }
            return this.children.isEmpty() && (this.filteredIndexes == null || this.filteredIndexes.length == 0);
        }

        boolean clear(TreePath path, int childIndex, int pathIndex) {
            if (pathIndex == path.getSegmentCount()) {
                if (this.filteredIndexes != null) {
                    int location = Arrays.binarySearch(this.filteredIndexes, childIndex);
                    if (location >= 0) {
                        if (location == 0 && this.filteredIndexes.length == 1) {
                            this.filteredIndexes = null;
                            this.filteredElements = null;
                            return true;
                        }
                        int[] next = new int[this.filteredIndexes.length - 1];
                        Object[] filt = new Object[next.length];
                        if (location == 0) {
                            System.arraycopy(this.filteredIndexes, 1, next, 0, next.length);
                            System.arraycopy(this.filteredElements, 1, filt, 0, filt.length);
                        } else if (location == this.filteredIndexes.length - 1) {
                            System.arraycopy(this.filteredIndexes, 0, next, 0, location);
                            System.arraycopy(this.filteredElements, 0, filt, 0, location);
                        } else {
                            System.arraycopy(this.filteredIndexes, 0, next, 0, location);
                            System.arraycopy(this.filteredElements, 0, filt, 0, location);
                            System.arraycopy(this.filteredIndexes, location + 1, next, location, next.length - location);
                            System.arraycopy(this.filteredElements, location + 1, filt, location, filt.length - location);
                        }
                        this.filteredIndexes = next;
                        this.filteredElements = filt;
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (this.children == null) {
                return false;
            }
            Object element = path.getSegment(pathIndex);
            Node node = (Node)this.children.get(element);
            if (node == null) {
                return false;
            }
            boolean remove = node.clear(path, childIndex, pathIndex + 1);
            if (remove) {
                this.children.remove(element);
                return this.filteredIndexes == null && this.children.isEmpty();
            }
            return false;
        }

        Node find(TreePath path, int pathIndex) {
            if (pathIndex == path.getSegmentCount()) {
                return this;
            }
            if (this.children == null) {
                return null;
            }
            Object child = path.getSegment(pathIndex);
            Node node = (Node)this.children.get(child);
            if (node != null) {
                return node.find(path, pathIndex + 1);
            }
            return null;
        }

        int viewToModel(int childIndex) {
            if (this.filteredIndexes == null) {
                return childIndex;
            }
            int count = -1;
            int missingNumbers = 0;
            int offset = 0;
            while (missingNumbers < childIndex + 1) {
                ++count;
                if (offset < this.filteredIndexes.length) {
                    if (this.filteredIndexes[offset] == count) {
                        ++offset;
                        continue;
                    }
                    ++missingNumbers;
                    continue;
                }
                ++missingNumbers;
            }
            return count;
        }

        int modelToView(int childIndex) {
            if (this.filteredIndexes == null) {
                return childIndex;
            }
            int offset = 0;
            int i = 0;
            while (i < this.filteredIndexes.length) {
                if (childIndex == this.filteredIndexes[i]) {
                    return -1;
                }
                if (childIndex <= this.filteredIndexes[i]) break;
                ++offset;
                ++i;
            }
            return childIndex - offset;
        }

        int modelToViewCount(int childCount) {
            if (this.filteredIndexes == null) {
                return childCount;
            }
            return childCount - this.filteredIndexes.length;
        }

        boolean isFiltered(int index) {
            if (this.filteredIndexes != null) {
                int location = Arrays.binarySearch(this.filteredIndexes, index);
                return location >= 0;
            }
            return false;
        }

        int indexOfFilteredElement(Object element) {
            if (this.filteredElements != null) {
                int i = 0;
                while (i < this.filteredElements.length) {
                    if (element.equals(this.filteredElements[i])) {
                        return this.filteredIndexes[i];
                    }
                    ++i;
                }
            }
            return -1;
        }

        void setModelChildCount(int childCount) {
            if (this.filteredIndexes != null) {
                int i = 0;
                while (i < this.filteredIndexes.length) {
                    if (this.filteredIndexes[i] >= childCount) {
                        if (i == 0) {
                            this.filteredIndexes = null;
                            this.filteredElements = null;
                            return;
                        }
                        int[] temp = new int[i + 1];
                        System.arraycopy(this.filteredIndexes, 0, temp, 0, temp.length);
                        this.filteredIndexes = temp;
                        Object[] temp2 = new Object[i + 1];
                        System.arraycopy(this.filteredElements, 0, temp2, 0, temp2.length);
                        this.filteredElements = temp2;
                    }
                    ++i;
                }
            }
        }

        void removeElementFromFilters(int index) {
            if (this.filteredIndexes != null) {
                int location = Arrays.binarySearch(this.filteredIndexes, index);
                if (location >= 0) {
                    if (this.filteredIndexes.length == 1) {
                        this.filteredIndexes = null;
                        this.filteredElements = null;
                    } else {
                        int[] next = new int[this.filteredIndexes.length - 1];
                        Object[] filt = new Object[next.length];
                        if (location == 0) {
                            System.arraycopy(this.filteredIndexes, 1, next, 0, next.length);
                            System.arraycopy(this.filteredElements, 1, filt, 0, filt.length);
                        } else if (location == this.filteredIndexes.length - 1) {
                            System.arraycopy(this.filteredIndexes, 0, next, 0, next.length);
                            System.arraycopy(this.filteredElements, 0, filt, 0, filt.length);
                        } else {
                            System.arraycopy(this.filteredIndexes, 0, next, 0, location);
                            System.arraycopy(this.filteredElements, 0, filt, 0, location);
                            System.arraycopy(this.filteredIndexes, location + 1, next, location, next.length - location);
                            System.arraycopy(this.filteredElements, location + 1, filt, location, filt.length - location);
                        }
                        this.filteredIndexes = next;
                        this.filteredElements = filt;
                    }
                } else {
                    location = 0 - (location + 1);
                }
                if (this.filteredIndexes != null) {
                    int i = location;
                    while (i < this.filteredIndexes.length) {
                        int n = i++;
                        this.filteredIndexes[n] = this.filteredIndexes[n] - 1;
                    }
                }
            }
        }
    }
}

