/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.scoping;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.scoping.ExtensionMethodsFeaturesProvider;
import org.eclipse.xtend.core.scoping.StaticallyImportedFeaturesProvider;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.annotations.scoping.XbaseWithAnnotationsScopeProvider;
import org.eclipse.xtext.xbase.scoping.XbaseScopeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IFeaturesForTypeProvider;
import org.eclipse.xtext.xbase.scoping.featurecalls.IJvmFeatureDescriptionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendScopeProvider
extends XbaseWithAnnotationsScopeProvider {
    private static final int IMPORTED_STATIC_FEATURE_PRIORITY = 50;
    private static final int DEFAULT_EXTENSION_PRIORITY = 45;
    private static final int IMPLICIT_ARGUMENT_PRIORITY = 400;
    private static final int THIS_EXTENSION_PRIORITY_OFFSET = 200;
    private static final int DYNAMIC_EXTENSION_PRIORITY_OFFSET = 210;
    private static final int STATIC_EXTENSION_PRIORITY_OFFSET = 220;
    @Inject
    private IXtendJvmAssociations xtendjvmAssociations;
    @Inject
    private Provider<StaticallyImportedFeaturesProvider> staticallyImportedFeaturesProvider;
    @Inject
    private Provider<ExtensionMethodsFeaturesProvider> extensionMethodsFeaturesProvider;
    @Inject
    private TypeReferences typeReferences;

    protected void addStaticFeatureDescriptionProviders(Resource resource, JvmDeclaredType contextType, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        super.addStaticFeatureDescriptionProviders(resource, contextType, acceptor);
        StaticallyImportedFeaturesProvider staticProvider = (StaticallyImportedFeaturesProvider)((Object)this.staticallyImportedFeaturesProvider.get());
        staticProvider.setResourceContext(resource);
        staticProvider.setExtensionProvider(false);
        this.addFeatureDescriptionProviders(contextType, (IFeaturesForTypeProvider)staticProvider, null, null, 50, true, acceptor);
    }

    protected void addFeatureDescriptionProvidersForAssignment(Resource resource, JvmDeclaredType contextType, XExpression implicitReceiver, XExpression implicitArgument, int priority, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        super.addFeatureDescriptionProvidersForAssignment(resource, contextType, implicitReceiver, implicitArgument, priority, acceptor);
        if (implicitReceiver == null || implicitArgument != null) {
            StaticallyImportedFeaturesProvider staticProvider = (StaticallyImportedFeaturesProvider)((Object)this.staticallyImportedFeaturesProvider.get());
            staticProvider.setResourceContext(resource);
            staticProvider.setExtensionProvider(true);
            if (implicitArgument != null) {
                XbaseScopeProvider.SimpleAcceptor casted = (XbaseScopeProvider.SimpleAcceptor)acceptor;
                JvmTypeReference implicitArgumentType = this.getTypeProvider().getType(implicitArgument, true);
                IAcceptor myAcceptor = casted.getParent().curry(implicitArgumentType, casted.getExpression());
                this.addFeatureDescriptionProvidersForAssignment(contextType, (IFeaturesForTypeProvider)staticProvider, implicitArgument, null, priority + 220, true, myAcceptor);
            } else {
                this.addFeatureDescriptionProvidersForAssignment(contextType, (IFeaturesForTypeProvider)staticProvider, implicitReceiver, implicitArgument, priority + 220, true, acceptor);
            }
        }
        if (contextType instanceof JvmGenericType) {
            JvmGenericType inferredJvmType = (JvmGenericType)contextType;
            XtendClass xtendClass = this.xtendjvmAssociations.getXtendClass(inferredJvmType);
            boolean isThis = false;
            if (implicitReceiver instanceof XFeatureCall) {
                boolean bl = isThis = ((XFeatureCall)implicitReceiver).getFeature() == inferredJvmType;
            }
            if (implicitReceiver == null || isThis) {
                XFeatureCall callToThis = XbaseFactory.eINSTANCE.createXFeatureCall();
                callToThis.setFeature((JvmIdentifiableElement)inferredJvmType);
                Iterable<XtendField> extensionFields = this.getExtensionDependencies(xtendClass);
                int extensionPriority = priority + 210;
                if (isThis && implicitArgument == null) {
                    extensionPriority = 45;
                }
                for (XtendField extensionField : extensionFields) {
                    JvmIdentifiableElement dependencyImplicitReceiver = this.findImplicitReceiverFor(extensionField);
                    XMemberFeatureCall callToDependency = XbaseFactory.eINSTANCE.createXMemberFeatureCall();
                    callToDependency.setMemberCallTarget((XExpression)EcoreUtil2.clone((EObject)callToThis));
                    callToDependency.setFeature(dependencyImplicitReceiver);
                    if (dependencyImplicitReceiver == null) continue;
                    ExtensionMethodsFeaturesProvider extensionFeatureProvider = (ExtensionMethodsFeaturesProvider)((Object)this.extensionMethodsFeaturesProvider.get());
                    extensionFeatureProvider.setContext(extensionField.getType());
                    extensionFeatureProvider.setExpectNoParameters(isThis);
                    this.addFeatureDescriptionProvidersForAssignment(contextType, (IFeaturesForTypeProvider)extensionFeatureProvider, (XExpression)callToDependency, implicitArgument, extensionPriority, false, acceptor);
                }
                JvmParameterizedTypeReference typeRef = this.typeReferences.createTypeRef((JvmType)inferredJvmType, new JvmTypeReference[0]);
                ExtensionMethodsFeaturesProvider featureProvider = (ExtensionMethodsFeaturesProvider)((Object)this.extensionMethodsFeaturesProvider.get());
                featureProvider.setContext((JvmTypeReference)typeRef);
                featureProvider.setExpectNoParameters(isThis);
                this.addFeatureDescriptionProvidersForAssignment(contextType, (IFeaturesForTypeProvider)featureProvider, (XExpression)callToThis, implicitArgument, priority + 200, false, acceptor);
            }
        }
    }

    protected void addFeatureDescriptionProviders(Resource resource, JvmDeclaredType contextType, XExpression implicitReceiver, XExpression implicitArgument, int priority, IAcceptor<IJvmFeatureDescriptionProvider> acceptor) {
        super.addFeatureDescriptionProviders(resource, contextType, implicitReceiver, implicitArgument, priority, acceptor);
        if (implicitReceiver == null || implicitArgument != null) {
            StaticallyImportedFeaturesProvider staticProvider = (StaticallyImportedFeaturesProvider)((Object)this.staticallyImportedFeaturesProvider.get());
            staticProvider.setResourceContext(resource);
            staticProvider.setExtensionProvider(true);
            if (implicitArgument != null) {
                XbaseScopeProvider.SimpleAcceptor casted = (XbaseScopeProvider.SimpleAcceptor)acceptor;
                JvmTypeReference implicitArgumentType = this.getTypeProvider().getType(implicitArgument, true);
                IAcceptor myAcceptor = casted.getParent().curry(implicitArgumentType, casted.getExpression());
                this.addFeatureDescriptionProviders(contextType, (IFeaturesForTypeProvider)staticProvider, implicitArgument, null, priority + 220, true, myAcceptor);
            } else {
                this.addFeatureDescriptionProviders(contextType, (IFeaturesForTypeProvider)staticProvider, implicitReceiver, implicitArgument, priority + 220, true, acceptor);
            }
        }
        if (contextType instanceof JvmGenericType) {
            JvmGenericType inferredJvmType = (JvmGenericType)contextType;
            XtendClass xtendClass = this.xtendjvmAssociations.getXtendClass(inferredJvmType);
            boolean isThis = false;
            if (implicitReceiver instanceof XFeatureCall) {
                boolean bl = isThis = ((XFeatureCall)implicitReceiver).getFeature() == inferredJvmType;
            }
            if (implicitReceiver == null || isThis) {
                XFeatureCall callToThis = XbaseFactory.eINSTANCE.createXFeatureCall();
                callToThis.setFeature((JvmIdentifiableElement)inferredJvmType);
                Iterable<XtendField> extensionFields = this.getExtensionDependencies(xtendClass);
                int extensionPriority = priority + 210;
                if (isThis && implicitArgument == null) {
                    extensionPriority = 45;
                }
                boolean isStatic = this.isStaticContext(((XbaseScopeProvider.SimpleAcceptor)acceptor).getExpression());
                for (XtendField extensionField : extensionFields) {
                    JvmIdentifiableElement dependencyImplicitReceiver = this.findImplicitReceiverFor(extensionField);
                    XMemberFeatureCall callToDependency = XbaseFactory.eINSTANCE.createXMemberFeatureCall();
                    callToDependency.setMemberCallTarget((XExpression)EcoreUtil2.clone((EObject)callToThis));
                    callToDependency.setFeature(dependencyImplicitReceiver);
                    if (dependencyImplicitReceiver == null) continue;
                    ExtensionMethodsFeaturesProvider extensionFeatureProvider = (ExtensionMethodsFeaturesProvider)((Object)this.extensionMethodsFeaturesProvider.get());
                    extensionFeatureProvider.setContext(extensionField.getType());
                    extensionFeatureProvider.setExpectNoParameters(isThis);
                    this.addFeatureDescriptionProviders(contextType, (IFeaturesForTypeProvider)extensionFeatureProvider, (XExpression)callToDependency, implicitArgument, extensionPriority, isStatic, acceptor);
                }
                JvmParameterizedTypeReference typeRef = this.typeReferences.createTypeRef((JvmType)inferredJvmType, new JvmTypeReference[0]);
                ExtensionMethodsFeaturesProvider featureProvider = (ExtensionMethodsFeaturesProvider)((Object)this.extensionMethodsFeaturesProvider.get());
                featureProvider.setContext((JvmTypeReference)typeRef);
                featureProvider.setExpectNoParameters(isThis);
                this.addFeatureDescriptionProviders(contextType, (IFeaturesForTypeProvider)featureProvider, (XExpression)callToThis, implicitArgument, priority + 200, isStatic, acceptor);
            }
        }
    }

    protected boolean isStaticContext(EObject expression) {
        XtendMember feature = (XtendMember)EcoreUtil2.getContainerOfType((EObject)expression, XtendMember.class);
        if (feature instanceof XtendFunction) {
            return ((XtendFunction)feature).isStatic();
        }
        if (feature instanceof XtendField) {
            return ((XtendField)feature).isStatic();
        }
        return false;
    }

    protected JvmIdentifiableElement findImplicitReceiverFor(XtendField XtendField2) {
        Set elements = this.xtendjvmAssociations.getJvmElements(XtendField2);
        if (!elements.isEmpty()) {
            JvmIdentifiableElement field = (JvmIdentifiableElement)elements.iterator().next();
            return field;
        }
        return null;
    }

    protected Iterable<XtendField> getExtensionDependencies(XtendClass context) {
        return Iterables.filter((Iterable)EcoreUtil2.typeSelect(context.getMembers(), XtendField.class), (Predicate)new Predicate<XtendField>(){

            public boolean apply(XtendField input) {
                return input.isExtension();
            }
        });
    }

    protected JvmDeclaredType getContextType(EObject call) {
        if (call == null) {
            return null;
        }
        XtendClass containerClass = (XtendClass)EcoreUtil2.getContainerOfType((EObject)call, XtendClass.class);
        if (containerClass != null && containerClass.getName() != null) {
            return this.xtendjvmAssociations.getInferredType(containerClass);
        }
        return super.getContextType(call);
    }

    protected void addFeatureCallScopes(EObject featureCall, IScope localVariableScope, XbaseScopeProvider.IJvmFeatureScopeAcceptor featureScopeDescriptions) {
        EObject implicitReceiver;
        IEObjectDescription implicitThis = localVariableScope.getSingleElement(THIS);
        if (implicitThis != null && (implicitReceiver = implicitThis.getEObjectOrProxy()) instanceof JvmIdentifiableElement) {
            JvmTypeReference receiverType = this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)implicitReceiver);
            if ((receiverType = this.unkownToObject(receiverType, featureCall)) != null) {
                JvmTypeReference argumentType;
                EObject implicitArgument;
                XFeatureCall receiver = XbaseFactory.eINSTANCE.createXFeatureCall();
                receiver.setFeature((JvmIdentifiableElement)implicitReceiver);
                IEObjectDescription implicitIt = localVariableScope.getSingleElement(IT);
                if (implicitIt != null && (implicitArgument = implicitIt.getEObjectOrProxy()) instanceof JvmIdentifiableElement && (argumentType = this.getTypeProvider().getTypeForIdentifiable((JvmIdentifiableElement)implicitArgument)) != null) {
                    XFeatureCall argument = XbaseFactory.eINSTANCE.createXFeatureCall();
                    argument.setFeature((JvmIdentifiableElement)implicitArgument);
                    this.addFeatureScopes(receiverType, featureCall, this.getContextType(featureCall), (XExpression)receiver, (XExpression)argument, 400, featureScopeDescriptions);
                }
            }
        }
        super.addFeatureCallScopes(featureCall, localVariableScope, featureScopeDescriptions);
    }
}

