/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.populationmodels.standard.wizards;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.populationmodels.adapters.PopulationModelPropertyEditor;
import org.eclipse.stem.ui.populationmodels.adapters.PopulationModelPropertyEditorAdapter;
import org.eclipse.stem.ui.populationmodels.adapters.PopulationModelPropertyEditorAdapterFactory;
import org.eclipse.stem.ui.populationmodels.standard.wizards.PopulationModelWizardMessages;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PopulationModelPropertyComposite
extends Composite {
    private final Map<PopulationModel, PopulationModelPropertyEditor> modelMap = new HashMap<PopulationModel, PopulationModelPropertyEditor>();
    private StackLayout stackLayout = new StackLayout();

    public PopulationModelPropertyComposite(Composite parent, int style, PopulationModel[] populationModels, ModifyListener projectValidator, IProject project) {
        super(parent, style);
        this.setLayout((Layout)this.stackLayout);
        Label label = new Label((Composite)this, 0);
        label.setText(PopulationModelWizardMessages.getString("DMPC1"));
        PopulationModelPropertyEditor firstOne = null;
        if (populationModels != null) {
            int i = 0;
            while (i < populationModels.length) {
                PopulationModelPropertyEditorAdapter dmpea = (PopulationModelPropertyEditorAdapter)PopulationModelPropertyEditorAdapterFactory.INSTANCE.adapt((Notifier)populationModels[i], PopulationModelPropertyEditorAdapter.class);
                PopulationModelPropertyEditor dmpe = dmpea.createPopulationModelPropertyEditor(this, 0, projectValidator, project);
                this.modelMap.put(populationModels[i], dmpe);
                if (firstOne == null) {
                    firstOne = dmpe;
                }
                ++i;
            }
        }
        this.stackLayout.topControl = firstOne;
    }

    void displayDiseaseModel(PopulationModel diseaseModel) {
        PopulationModelPropertyEditor dmpe = this.modelMap.get(diseaseModel);
        if (dmpe != null) {
            this.stackLayout.topControl = dmpe;
            this.layout();
        } else {
            Activator.logError((String)(String.valueOf(PopulationModelWizardMessages.getString("DMPC2")) + diseaseModel.getClass().getName() + "\""), null);
        }
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public boolean validate() {
        return ((PopulationModelPropertyEditor)this.stackLayout.topControl).validate();
    }

    public String getErrorMessage() {
        return ((PopulationModelPropertyEditor)this.stackLayout.topControl).getErrorMessage();
    }

    public void populatePopulationModel(PopulationModel populationModel) {
        ((PopulationModelPropertyEditor)this.stackLayout.topControl).populate(populationModel);
    }
}

