/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.viewsupport;

import org.eclipse.jdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.custom.StyleRange;

public class ColoringLabelProvider
extends DecoratingStyledCellLabelProvider
implements ILabelProvider {
    public static final StyledString.Styler HIGHLIGHT_STYLE = StyledString.createColorRegistryStyler(null, (String)"org.eclipse.jdt.ui.ColoredLabels.match_highlight");
    public static final StyledString.Styler HIGHLIGHT_WRITE_STYLE = StyledString.createColorRegistryStyler(null, (String)"org.eclipse.jdt.ui.ColoredLabels.writeaccess_highlight");
    public static final StyledString.Styler INHERITED_STYLER = StyledString.createColorRegistryStyler((String)"org.eclipse.jdt.ui.ColoredLabels.inherited", null);

    public ColoringLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider) {
        this(labelProvider, null, null);
    }

    public ColoringLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider, ILabelDecorator decorator, IDecorationContext decorationContext) {
        super(labelProvider, decorator, decorationContext);
    }

    public void initialize(ColumnViewer viewer, ViewerColumn column) {
        ColoredViewersManager.install(this);
        this.setOwnerDrawEnabled(ColoredViewersManager.showColoredLabels());
        super.initialize(viewer, column);
    }

    public void dispose() {
        super.dispose();
        ColoredViewersManager.uninstall(this);
    }

    public void update() {
        ColumnViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        boolean needsUpdate = false;
        boolean showColoredLabels = ColoredViewersManager.showColoredLabels();
        if (showColoredLabels != this.isOwnerDrawEnabled()) {
            this.setOwnerDrawEnabled(showColoredLabels);
            needsUpdate = true;
        } else if (showColoredLabels) {
            needsUpdate = true;
        }
        if (needsUpdate) {
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    protected StyleRange prepareStyleRange(StyleRange styleRange, boolean applyColors) {
        if (!applyColors && styleRange.background != null) {
            styleRange = super.prepareStyleRange(styleRange, applyColors);
            styleRange.borderStyle = 4;
            return styleRange;
        }
        return super.prepareStyleRange(styleRange, applyColors);
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }
}

