/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.ContentAssistProcessor;
import org.eclipse.jdt.internal.ui.text.java.JavaParameterListValidator;
import org.eclipse.jdt.internal.ui.text.java.ProposalSorterRegistry;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompletionProcessor
extends ContentAssistProcessor {
    private static final String VISIBILITY = "org.eclipse.jdt.core.codeComplete.visibilityCheck";
    private static final String ENABLED = "enabled";
    private static final String DISABLED = "disabled";
    private IContextInformationValidator fValidator;
    protected final IEditorPart fEditor;

    public JavaCompletionProcessor(IEditorPart editor, ContentAssistant assistant, String partition) {
        super(assistant, partition);
        this.fEditor = editor;
    }

    public void restrictProposalsToVisibility(boolean restrict) {
        Hashtable options = JavaCore.getOptions();
        Object value = options.get(VISIBILITY);
        if (value instanceof String) {
            String newValue;
            String string = newValue = restrict ? ENABLED : DISABLED;
            if (!newValue.equals(value)) {
                options.put(VISIBILITY, newValue);
                JavaCore.setOptions((Hashtable)options);
            }
        }
    }

    public void restrictProposalsToMatchingCases(boolean restrict) {
    }

    @Override
    public IContextInformationValidator getContextInformationValidator() {
        if (this.fValidator == null) {
            this.fValidator = new JavaParameterListValidator();
        }
        return this.fValidator;
    }

    @Override
    protected boolean checkDefaultEnablement(CompletionProposalCategory category) {
        return super.checkDefaultEnablement(category) && category.matches(this.getJavaProject());
    }

    @Override
    protected boolean checkSeparateEnablement(CompletionProposalCategory category) {
        return super.checkSeparateEnablement(category) && category.matches(this.getJavaProject());
    }

    private IJavaProject getJavaProject() {
        return EditorUtility.getJavaProject(this.fEditor.getEditorInput());
    }

    @Override
    protected List<ICompletionProposal> sortProposals(List<ICompletionProposal> proposals, IProgressMonitor monitor, ContentAssistInvocationContext context) {
        ProposalSorterRegistry.getDefault().getCurrentSorter().sortProposals(context, proposals);
        return proposals;
    }

    @Override
    protected ContentAssistInvocationContext createContext(ITextViewer viewer, int offset) {
        return new JavaContentAssistInvocationContext(viewer, offset, this.fEditor);
    }
}

