/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.AnonymousTypeProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.FillArgumentNamesCompletionProposalCollector;
import org.eclipse.jdt.internal.ui.text.java.ImportCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MemberProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.SmartSemicolonAutoEditStrategy;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocBrowserInformationControlInput;
import org.eclipse.jdt.internal.ui.text.java.hover.JavadocHover;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension5;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.osgi.framework.Bundle;

public abstract class AbstractJavaCompletionProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension5,
ICompletionProposalExtension6 {
    private StyledString fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private ProposalInfo fProposalInfo;
    private char[] fTriggerCharacters;
    private String fSortString;
    private int fRelevance;
    private boolean fIsInJavadoc;
    private StyleRange fRememberedStyleRange;
    private boolean fToggleEating;
    private ITextViewer fTextViewer;
    private IInformationControlCreator fCreator;
    private static String fgCSSStyles;
    protected final JavaContentAssistInvocationContext fInvocationContext;
    private boolean fIsValidated = true;
    private ITextPresentationListener fTextPresentationListener;

    protected AbstractJavaCompletionProposal() {
        this.fInvocationContext = null;
    }

    protected AbstractJavaCompletionProposal(JavaContentAssistInvocationContext context) {
        this.fInvocationContext = context;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharacters = triggerCharacters;
    }

    public void setProposalInfo(ProposalInfo proposalInfo) {
        this.fProposalInfo = proposalInfo;
    }

    protected ProposalInfo getProposalInfo() {
        return this.fProposalInfo;
    }

    public void setCursorPosition(int cursorPosition) {
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = cursorPosition;
    }

    protected int getCursorPosition() {
        return this.fCursorPosition;
    }

    public final void apply(IDocument document) {
        this.apply(document, '\u0000', this.getReplacementOffset() + this.getReplacementLength());
    }

    public void apply(IDocument document, char trigger, int offset) {
        if (this.isSupportingRequiredProposals()) {
            CompletionProposal coreProposal = ((MemberProposalInfo)this.getProposalInfo()).fProposal;
            CompletionProposal[] requiredProposals = coreProposal.getRequiredProposals();
            int i = 0;
            while (requiredProposals != null && i < requiredProposals.length) {
                AbstractJavaCompletionProposal proposal;
                int oldLen = document.getLength();
                if (requiredProposals[i].getKind() == 9) {
                    proposal = this.createRequiredTypeCompletionProposal(requiredProposals[i], this.fInvocationContext);
                    proposal.apply(document);
                    this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
                } else if (requiredProposals[i].getKind() == 23) {
                    proposal = new ImportCompletionProposal(requiredProposals[i], this.fInvocationContext, coreProposal.getKind());
                    proposal.setReplacementOffset(this.getReplacementOffset());
                    proposal.apply(document);
                    this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
                } else if (requiredProposals[i].getKind() == 22) {
                    proposal = new ImportCompletionProposal(requiredProposals[i], this.fInvocationContext, coreProposal.getKind());
                    proposal.setReplacementOffset(this.getReplacementOffset());
                    proposal.apply(document);
                    this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
                } else if (requiredProposals[i].getKind() == 21) {
                    proposal = new ImportCompletionProposal(requiredProposals[i], this.fInvocationContext, coreProposal.getKind());
                    proposal.setReplacementOffset(this.getReplacementOffset());
                    proposal.apply(document);
                    this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
                } else {
                    Assert.isTrue((boolean)false);
                }
                ++i;
            }
        }
        try {
            String replacement;
            boolean isSmartTrigger = this.isSmartTrigger(trigger);
            if (isSmartTrigger || trigger == '\u0000') {
                replacement = this.getReplacementString();
            } else {
                StringBuffer buffer = new StringBuffer(this.getReplacementString());
                if (this.getCursorPosition() > 0 && this.getCursorPosition() <= buffer.length() && buffer.charAt(this.getCursorPosition() - 1) != trigger) {
                    buffer.insert(this.getCursorPosition(), trigger);
                    this.setCursorPosition(this.getCursorPosition() + 1);
                }
                replacement = buffer.toString();
                this.setReplacementString(replacement);
            }
            int referenceOffset = this.getReplacementOffset() + this.getReplacementLength();
            ReferenceTracker referenceTracker = new ReferenceTracker();
            referenceTracker.preReplace(document, referenceOffset);
            this.replace(document, this.getReplacementOffset(), this.getReplacementLength(), replacement);
            referenceOffset = referenceTracker.postReplace(document);
            this.setReplacementOffset(referenceOffset - (replacement == null ? 0 : replacement.length()));
            if (isSmartTrigger) {
                this.handleSmartTrigger(document, trigger, referenceOffset);
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    protected LazyJavaCompletionProposal createRequiredTypeCompletionProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext invocationContext) {
        if (PreferenceConstants.getPreferenceStore().getBoolean("content_assist_fill_method_arguments")) {
            return (LazyJavaCompletionProposal)new FillArgumentNamesCompletionProposalCollector(invocationContext).createJavaCompletionProposal(completionProposal);
        }
        return new LazyJavaTypeCompletionProposal(completionProposal, invocationContext);
    }

    private boolean isSmartTrigger(char trigger) {
        return trigger == ';' && JavaPlugin.getDefault().getCombinedPreferenceStore().getBoolean("smart_semicolon") || trigger == '{' && JavaPlugin.getDefault().getCombinedPreferenceStore().getBoolean("smart_opening_brace");
    }

    private void handleSmartTrigger(IDocument document, char trigger, int referenceOffset) throws BadLocationException {
        DocumentCommand cmd = new DocumentCommand(){};
        cmd.offset = referenceOffset;
        cmd.length = 0;
        cmd.text = Character.toString(trigger);
        cmd.doit = true;
        cmd.shiftsCaret = true;
        cmd.caretOffset = this.getReplacementOffset() + this.getCursorPosition();
        SmartSemicolonAutoEditStrategy strategy = new SmartSemicolonAutoEditStrategy("___java_partitioning");
        strategy.customizeDocumentCommand(document, cmd);
        this.replace(document, cmd.offset, cmd.length, cmd.text);
        this.setCursorPosition(cmd.caretOffset - this.getReplacementOffset() + cmd.text.length());
    }

    protected final void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (!document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        if (this.fTextViewer == null) {
            this.fTextViewer = viewer;
        }
        if (!this.isInJavadoc() && !this.validate(document, offset, null)) {
            this.setCursorPosition(offset);
            if (trigger != '\u0000') {
                try {
                    document.replace(offset, 0, String.valueOf(trigger));
                    this.setCursorPosition(this.getCursorPosition() + 1);
                    if (trigger == '(' && this.autocloseBrackets()) {
                        document.replace(this.getReplacementOffset() + this.getCursorPosition(), 0, ")");
                        this.setUpLinkedMode(document, ')');
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            return;
        }
        Point selection = viewer.getSelectedRange();
        this.fToggleEating = (stateMask & 0x40000) != 0;
        int newLength = selection.x + selection.y - this.getReplacementOffset();
        if (AbstractJavaCompletionProposal.insertCompletion() ^ this.fToggleEating && newLength >= 0) {
            this.setReplacementLength(newLength);
        }
        this.apply(document, trigger, offset);
        this.fToggleEating = false;
    }

    protected boolean isInsertModeToggled() {
        return this.fToggleEating;
    }

    protected boolean isInJavadoc() {
        return this.fIsInJavadoc;
    }

    protected void setInJavadoc(boolean isInJavadoc) {
        this.fIsInJavadoc = isInJavadoc;
    }

    public Point getSelection(IDocument document) {
        if (!this.fIsValidated) {
            return null;
        }
        return new Point(this.getReplacementOffset() + this.getCursorPosition(), 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformation = contextInformation;
    }

    public String getDisplayString() {
        if (this.fDisplayString != null) {
            return this.fDisplayString.getString();
        }
        return "";
    }

    public String getAdditionalProposalInfo() {
        Object info = this.getAdditionalProposalInfo((IProgressMonitor)new NullProgressMonitor());
        return info == null ? null : info.toString();
    }

    public Object getAdditionalProposalInfo(IProgressMonitor monitor) {
        String info;
        if (this.getProposalInfo() != null && (info = this.getProposalInfo().getInfo(monitor)) != null && info.length() > 0) {
            StringBuffer buffer = new StringBuffer();
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (String)this.getCSSStyles());
            buffer.append(info);
            IJavaElement element = null;
            try {
                String base;
                element = this.getProposalInfo().getJavaElement();
                if (element instanceof IMember && (base = JavaDocLocations.getBaseURL((IMember)element)) != null) {
                    int endHeadIdx = buffer.indexOf("</head>");
                    buffer.insert(endHeadIdx, "\n<base href='" + base + "'>\n");
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            info = buffer.toString();
            return new JavadocBrowserInformationControlInput(null, element, info, 0);
        }
        return null;
    }

    protected String getCSSStyles() {
        String css;
        block17: {
            Bundle bundle;
            URL url;
            if (fgCSSStyles == null && (url = (bundle = Platform.getBundle((String)JavaPlugin.getPluginId())).getEntry("/JavadocHoverStyleSheet.css")) != null) {
                BufferedReader reader = null;
                try {
                    try {
                        url = FileLocator.toFileURL((URL)url);
                        reader = new BufferedReader(new InputStreamReader(url.openStream()));
                        StringBuffer buffer = new StringBuffer(200);
                        String line = reader.readLine();
                        while (line != null) {
                            buffer.append(line);
                            buffer.append('\n');
                            line = reader.readLine();
                        }
                        fgCSSStyles = buffer.toString();
                    }
                    catch (IOException ex) {
                        JavaPlugin.log(ex);
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block17;
                        }
                        catch (IOException iOException) {}
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if ((css = fgCSSStyles) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    public int getContextInformationPosition() {
        if (this.getContextInformation() == null) {
            return this.getReplacementOffset() - 1;
        }
        return this.getReplacementOffset() + this.getCursorPosition();
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public void setReplacementOffset(int replacementOffset) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = replacementOffset;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = replacementLength;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public void setReplacementString(String replacementString) {
        Assert.isNotNull((Object)replacementString);
        this.fReplacementString = replacementString;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        if (!this.isCamelCaseMatching()) {
            return this.getReplacementString();
        }
        String prefix = this.getPrefix(document, completionOffset);
        return this.getCamelCaseCompound(prefix, this.getReplacementString());
    }

    public Image getImage() {
        return this.fImage;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (!this.isOffsetValid(offset)) {
            this.fIsValidated = false;
            return false;
        }
        this.fIsValidated = this.isValidPrefix(this.getPrefix(document, offset));
        if (this.fIsValidated && event != null) {
            int delta = (event.fText == null ? 0 : event.fText.length()) - event.fLength;
            int newLength = Math.max(this.getReplacementLength() + delta, 0);
            this.setReplacementLength(newLength);
        }
        return this.fIsValidated;
    }

    protected boolean isOffsetValid(int offset) {
        return this.getReplacementOffset() <= offset;
    }

    protected boolean isValidPrefix(String prefix) {
        return this.isPrefix(prefix, TextProcessor.deprocess((String)this.getDisplayString()));
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    protected String getPrefix(IDocument document, int offset) {
        try {
            int length = offset - this.getReplacementOffset();
            if (length > 0) {
                return document.get(this.getReplacementOffset(), length);
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    protected boolean isPrefix(String prefix, String string) {
        if (prefix == null || string == null || prefix.length() > string.length()) {
            return false;
        }
        String start = string.substring(0, prefix.length());
        return start.equalsIgnoreCase(prefix) || this.isCamelCaseMatching() && CharOperation.camelCaseMatch((char[])prefix.toCharArray(), (char[])string.toCharArray());
    }

    protected final String getCamelCaseCompound(String prefix, String string) {
        if (prefix.length() > string.length()) {
            return string;
        }
        String start = string.substring(0, prefix.length());
        if (start.equalsIgnoreCase(prefix)) {
            return string;
        }
        char[] patternChars = prefix.toCharArray();
        char[] stringChars = string.toCharArray();
        int i = 1;
        while (i <= stringChars.length) {
            if (CharOperation.camelCaseMatch((char[])patternChars, (int)0, (int)patternChars.length, (char[])stringChars, (int)0, (int)i)) {
                return String.valueOf(prefix) + string.substring(i);
            }
            ++i;
        }
        return string;
    }

    protected boolean isCamelCaseMatching() {
        String value = JavaCore.getOption((String)"org.eclipse.jdt.core.codeComplete.camelCaseMatch");
        return "enabled".equals(value);
    }

    protected static boolean insertCompletion() {
        IPreferenceStore preference = JavaPlugin.getDefault().getPreferenceStore();
        return preference.getBoolean("content_assist_insert_completion");
    }

    private static Color getForegroundColor() {
        IPreferenceStore preference = JavaPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preference, (String)"content_assist_completion_replacement_foreground");
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private static Color getBackgroundColor() {
        IPreferenceStore preference = JavaPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preference, (String)"content_assist_completion_replacement_background");
        JavaTextTools textTools = JavaPlugin.getDefault().getJavaTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private void repairPresentation(ITextViewer viewer) {
        if (this.fRememberedStyleRange != null) {
            if (viewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 viewer2 = (ITextViewerExtension2)viewer;
                viewer2.invalidateTextPresentation(this.fRememberedStyleRange.start, this.fRememberedStyleRange.length);
            } else {
                viewer.invalidateTextPresentation();
            }
        }
    }

    private void updateStyle(ITextViewer viewer) {
        StyledText text = viewer.getTextWidget();
        int widgetOffset = this.getWidgetOffset(viewer, this.fRememberedStyleRange.start);
        StyleRange range = new StyleRange((TextStyle)this.fRememberedStyleRange);
        range.start = widgetOffset;
        range.length = this.fRememberedStyleRange.length;
        StyleRange currentRange = text.getStyleRangeAtOffset(widgetOffset);
        if (currentRange != null) {
            range.strikeout = currentRange.strikeout;
            range.underline = currentRange.underline;
            range.fontStyle = currentRange.fontStyle;
        }
        try {
            text.setStyleRange(range);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fRememberedStyleRange = null;
        }
    }

    private int getWidgetOffset(ITextViewer viewer, int documentOffset) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            return extension.modelOffset2WidgetOffset(documentOffset);
        }
        IRegion visible = viewer.getVisibleRegion();
        int widgetOffset = documentOffset - visible.getOffset();
        if (widgetOffset > visible.getLength()) {
            return -1;
        }
        return widgetOffset;
    }

    private StyleRange createStyleRange(ITextViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return null;
        }
        int widgetCaret = text.getCaretOffset();
        int modelCaret = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            modelCaret = extension.widgetOffset2ModelOffset(widgetCaret);
        } else {
            IRegion visibleRegion = viewer.getVisibleRegion();
            modelCaret = widgetCaret + visibleRegion.getOffset();
        }
        if (modelCaret >= this.getReplacementOffset() + this.getReplacementLength()) {
            return null;
        }
        int length = this.getReplacementOffset() + this.getReplacementLength() - modelCaret;
        Color foreground = AbstractJavaCompletionProposal.getForegroundColor();
        Color background = AbstractJavaCompletionProposal.getBackgroundColor();
        return new StyleRange(modelCaret, length, foreground, background);
    }

    public void selected(final ITextViewer viewer, boolean smartToggle) {
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = null;
        if (!AbstractJavaCompletionProposal.insertCompletion() ^ smartToggle) {
            StyleRange range = this.createStyleRange(viewer);
            if (range == null) {
                return;
            }
            this.fRememberedStyleRange = range;
            if (viewer instanceof ITextViewerExtension4) {
                if (this.fTextPresentationListener == null) {
                    this.fTextPresentationListener = new ITextPresentationListener(){

                        public void applyTextPresentation(TextPresentation textPresentation) {
                            AbstractJavaCompletionProposal.this.fRememberedStyleRange = AbstractJavaCompletionProposal.this.createStyleRange(viewer);
                            if (AbstractJavaCompletionProposal.this.fRememberedStyleRange != null) {
                                textPresentation.mergeStyleRange(AbstractJavaCompletionProposal.this.fRememberedStyleRange);
                            }
                        }
                    };
                    ((ITextViewerExtension4)viewer).addTextPresentationListener(this.fTextPresentationListener);
                }
                this.repairPresentation(viewer);
            } else {
                this.updateStyle(viewer);
            }
        }
    }

    public void unselected(ITextViewer viewer) {
        if (this.fTextPresentationListener != null) {
            ((ITextViewerExtension4)viewer).removeTextPresentationListener(this.fTextPresentationListener);
            this.fTextPresentationListener = null;
        }
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = null;
    }

    public IInformationControlCreator getInformationControlCreator() {
        Shell shell = JavaPlugin.getActiveWorkbenchShell();
        if (shell == null || !BrowserInformationControl.isAvailable((Composite)shell)) {
            return null;
        }
        if (this.fCreator == null) {
            JavadocHover.PresenterControlCreator presenterControlCreator = new JavadocHover.PresenterControlCreator(this.getSite());
            this.fCreator = new JavadocHover.HoverControlCreator((IInformationControlCreator)presenterControlCreator, true);
        }
        return this.fCreator;
    }

    private IWorkbenchSite getSite() {
        IWorkbenchPart part;
        IWorkbenchPage page = JavaPlugin.getActivePage();
        if (page != null && (part = page.getActivePart()) != null) {
            return part.getSite();
        }
        return null;
    }

    public String getSortString() {
        return this.fSortString;
    }

    protected void setSortString(String string) {
        this.fSortString = string;
    }

    protected ITextViewer getTextViewer() {
        return this.fTextViewer;
    }

    protected boolean isToggleEating() {
        return this.fToggleEating;
    }

    protected void setUpLinkedMode(IDocument document, char closingCharacter) {
        if (this.getTextViewer() != null && this.autocloseBrackets()) {
            int offset = this.getReplacementOffset() + this.getCursorPosition();
            int exit = this.getReplacementOffset() + this.getReplacementString().length();
            try {
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addGroup(group);
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setSimpleMode(true);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, document));
                ui.setExitPosition(this.getTextViewer(), exit, 0, Integer.MAX_VALUE);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.enter();
            }
            catch (BadLocationException x) {
                JavaPlugin.log(x);
            }
        }
    }

    protected boolean autocloseBrackets() {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("closeBrackets");
    }

    protected void setDisplayString(String string) {
        this.fDisplayString = new StyledString(string);
    }

    public StyledString getStyledDisplayString() {
        return this.fDisplayString;
    }

    public void setStyledDisplayString(StyledString text) {
        this.fDisplayString = text;
    }

    public String toString() {
        return this.getDisplayString();
    }

    public IJavaElement getJavaElement() {
        if (this.getProposalInfo() != null) {
            try {
                return this.getProposalInfo().getJavaElement();
            }
            catch (JavaModelException x) {
                JavaPlugin.log(x);
            }
        }
        return null;
    }

    protected boolean isSupportingRequiredProposals() {
        if (this.fInvocationContext == null) {
            return false;
        }
        ProposalInfo proposalInfo = this.getProposalInfo();
        if (!(proposalInfo instanceof MemberProposalInfo) && !(proposalInfo instanceof AnonymousTypeProposalInfo)) {
            return false;
        }
        CompletionProposal proposal = ((MemberProposalInfo)proposalInfo).fProposal;
        return proposal != null && (proposal.getKind() == 6 || proposal.getKind() == 2 || proposal.getKind() == 9 || proposal.getKind() == 26 || proposal.getKind() == 27);
    }

    protected static class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        private final IDocument fDocument;

        public ExitPolicy(char exitCharacter, IDocument document) {
            this.fExitCharacter = exitCharacter;
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (environment.anyPositionContains(offset)) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                return new LinkedModeUI.ExitFlags(2, true);
            }
            switch (event.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
                case '\r': {
                    if (offset > 0) {
                        try {
                            if (this.fDocument.getChar(offset - 1) == '{') {
                                return new LinkedModeUI.ExitFlags(1, true);
                            }
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    return null;
                }
            }
            return null;
        }
    }

    static final class ReferenceTracker {
        private static final String CATEGORY = "reference_position";
        private final IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("reference_position");
        private final Position fPosition = new Position(0);

        ReferenceTracker() {
        }

        public void preReplace(IDocument document, int offset) throws BadLocationException {
            this.fPosition.setOffset(offset);
            try {
                document.addPositionCategory(CATEGORY);
                document.addPositionUpdater(this.fPositionUpdater);
                document.addPosition(CATEGORY, this.fPosition);
            }
            catch (BadPositionCategoryException e) {
                JavaPlugin.log(e);
            }
        }

        public int postReplace(IDocument document) {
            try {
                document.removePosition(CATEGORY, this.fPosition);
                document.removePositionUpdater(this.fPositionUpdater);
                document.removePositionCategory(CATEGORY);
            }
            catch (BadPositionCategoryException e) {
                JavaPlugin.log(e);
            }
            return this.fPosition.getOffset();
        }
    }
}

