/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.common.impl;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.common.IdentifiableFilter;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;

public class IdentifiableFilterImpl
extends EObjectImpl
implements IdentifiableFilter {
    private String[] patterns;

    protected IdentifiableFilterImpl() {
    }

    protected EClass eStaticClass() {
        return CommonPackage.Literals.IDENTIFIABLE_FILTER;
    }

    public IdentifiableFilterImpl(String filter) {
        if (filter == null) {
            return;
        }
        if (filter.contains(":")) {
            return;
        }
        if (filter.trim().equals("")) {
            return;
        }
        StringTokenizer st = new StringTokenizer(filter.toString(), ";");
        this.patterns = new String[st.countTokens()];
        int i = 0;
        while (i < this.patterns.length) {
            String pat;
            this.patterns[i] = pat = st.nextToken();
            ++i;
        }
    }

    public EMap<URI, Node> filterNodes(EMap<URI, Node> map) {
        if (this.patterns == null) {
            return map;
        }
        ArrayList<URI> remove = new ArrayList<URI>();
        for (URI uri : map.keySet()) {
            String lastSegment = uri.lastSegment();
            boolean keep = false;
            int i = 0;
            while (i < this.patterns.length) {
                String pat = this.patterns[i];
                boolean wildcard = false;
                if (pat.endsWith("*")) {
                    pat = pat.substring(0, pat.length() - 1);
                    wildcard = true;
                }
                if (wildcard && lastSegment.contains(pat) || !wildcard && lastSegment.equals(pat)) {
                    keep = true;
                    break;
                }
                ++i;
            }
            if (keep) continue;
            remove.add(uri);
        }
        for (URI u : remove) {
            map.remove((Object)u);
        }
        return map;
    }

    public EMap<URI, Edge> filterEdges(EMap<URI, Edge> map) {
        if (this.patterns == null) {
            return map;
        }
        ArrayList<URI> remove = new ArrayList<URI>();
        for (URI uri : map.keySet()) {
            Edge edge = (Edge)map.get((Object)uri);
            boolean foundSource = false;
            boolean foundDest = false;
            int i = 0;
            while (i < this.patterns.length) {
                String pat = this.patterns[i];
                boolean wildcard = false;
                if (pat.endsWith("*")) {
                    pat = pat.substring(0, pat.length() - 1);
                    wildcard = true;
                }
                if (wildcard && edge.getNodeAURI().lastSegment().contains(pat) || !wildcard && edge.getNodeAURI().lastSegment().equals(pat)) {
                    foundSource = true;
                }
                if (wildcard && edge.getNodeBURI().lastSegment().contains(pat) || !wildcard && edge.getNodeBURI().lastSegment().equals(pat)) {
                    foundDest = true;
                }
                ++i;
            }
            if (foundSource && foundDest) continue;
            remove.add(uri);
        }
        for (URI u : remove) {
            map.remove((Object)u);
        }
        return map;
    }

    public EMap<URI, NodeLabel> filterNodeLabels(EMap<URI, NodeLabel> map) {
        if (this.patterns == null) {
            return map;
        }
        ArrayList<URI> remove = new ArrayList<URI>();
        for (URI uri : map.keySet()) {
            String lastSegment = uri.lastSegment();
            boolean keep = false;
            int i = 0;
            while (i < this.patterns.length) {
                String pat = this.patterns[i];
                boolean wildcard = false;
                if (pat.endsWith("*")) {
                    pat = pat.substring(0, pat.length() - 1);
                    wildcard = true;
                }
                if (wildcard && lastSegment.contains(pat) || !wildcard && lastSegment.equals(pat)) {
                    keep = true;
                    break;
                }
                ++i;
            }
            if (keep) continue;
            remove.add(uri);
        }
        for (URI u : remove) {
            map.remove((Object)u);
        }
        return map;
    }

    public EMap<URI, Label> filterLabels(EMap<URI, Label> map) {
        if (this.patterns == null) {
            return map;
        }
        ArrayList<URI> remove = new ArrayList<URI>();
        block0: for (URI uri : map.keySet()) {
            String lastSegment = uri.lastSegment();
            boolean keep = false;
            int i = 0;
            while (i < this.patterns.length) {
                String pat = this.patterns[i];
                boolean wildcard = false;
                if (pat.endsWith("*")) {
                    pat = pat.substring(0, pat.length() - 1);
                    wildcard = true;
                }
                if (wildcard && lastSegment.contains(pat) || !wildcard && lastSegment.equals(pat)) {
                    keep = true;
                    continue block0;
                }
                if (!keep) {
                    remove.add(uri);
                }
                ++i;
            }
        }
        for (URI u : remove) {
            map.remove((Object)u);
        }
        return map;
    }

    public void restrict(IdentifiableFilterImpl other) {
    }
}

