/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensOptions;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColoringInformation;
import org.eclipse.lsp4j.ColoringParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.ExecuteCommandOptions;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpOptions;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethodProvider;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageClientExtensions;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ide.server.BuildManager;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.server.ICapabilitiesContributor;
import org.eclipse.xtext.ide.server.ILanguageServerAccess;
import org.eclipse.xtext.ide.server.ILanguageServerExtension;
import org.eclipse.xtext.ide.server.UriExtensions;
import org.eclipse.xtext.ide.server.WorkspaceManager;
import org.eclipse.xtext.ide.server.codeActions.ICodeActionService;
import org.eclipse.xtext.ide.server.codelens.ICodeLensResolver;
import org.eclipse.xtext.ide.server.codelens.ICodeLensService;
import org.eclipse.xtext.ide.server.coloring.IColoringService;
import org.eclipse.xtext.ide.server.commands.ExecutableCommandRegistry;
import org.eclipse.xtext.ide.server.concurrent.RequestManager;
import org.eclipse.xtext.ide.server.contentassist.ContentAssistService;
import org.eclipse.xtext.ide.server.findReferences.WorkspaceResourceAccess;
import org.eclipse.xtext.ide.server.formatting.FormattingService;
import org.eclipse.xtext.ide.server.hover.IHoverService;
import org.eclipse.xtext.ide.server.occurrences.IDocumentHighlightService;
import org.eclipse.xtext.ide.server.rename.IRenameService;
import org.eclipse.xtext.ide.server.signatureHelp.ISignatureHelpService;
import org.eclipse.xtext.ide.server.symbol.DocumentSymbolService;
import org.eclipse.xtext.ide.server.symbol.WorkspaceSymbolService;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.internal.Log;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@Log
public class LanguageServerImpl
implements LanguageServer,
WorkspaceService,
TextDocumentService,
LanguageClientAware,
Endpoint,
JsonRpcMethodProvider,
ILanguageServerAccess.IBuildListener {
    @Inject
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private RequestManager requestManager;
    @Inject
    private WorkspaceSymbolService workspaceSymbolService;
    @Inject
    @Extension
    private UriExtensions _uriExtensions;
    @Inject
    @Extension
    private IResourceServiceProvider.Registry languagesRegistry;
    @Inject
    private ExecutableCommandRegistry commandRegistry;
    private WorkspaceManager workspaceManager;
    private InitializeParams params;
    private boolean hasShutdownBeenCalled = false;
    private WorkspaceResourceAccess resourceAccess;
    private LanguageClient client;
    private Map<String, JsonRpcMethod> supportedMethods = null;
    private Multimap<String, Endpoint> extensionProviders = LinkedListMultimap.create();
    private ILanguageServerAccess access = new ILanguageServerAccess(){

        @Override
        public <T> CompletableFuture<T> doRead(String uri, Function<ILanguageServerAccess.Context, T> function) {
            Functions.Function1 _function = cancelIndicator -> {
                Functions.Function2 _function_1 = (document, resource) -> {
                    boolean _isDocumentOpen = LanguageServerImpl.this.workspaceManager.isDocumentOpen(resource.getURI());
                    ILanguageServerAccess.Context ctx = new ILanguageServerAccess.Context((Resource)resource, (Document)document, _isDocumentOpen, (CancelIndicator)cancelIndicator);
                    return function.apply(ctx);
                };
                return LanguageServerImpl.this.workspaceManager.doRead(LanguageServerImpl.this._uriExtensions.toUri(uri), _function_1);
            };
            return LanguageServerImpl.this.requestManager.runRead(_function);
        }

        @Override
        public void addBuildListener(ILanguageServerAccess.IBuildListener listener) {
            LanguageServerImpl.this.workspaceManager.addBuildListener(listener);
        }

        @Override
        public LanguageClient getLanguageClient() {
            return LanguageServerImpl.this.client;
        }
    };
    private static final Logger LOG = Logger.getLogger(LanguageServerImpl.class);

    @Inject
    public void setWorkspaceManager(WorkspaceManager manager) {
        WorkspaceResourceAccess _workspaceResourceAccess;
        this.workspaceManager = manager;
        this.resourceAccess = _workspaceResourceAccess = new WorkspaceResourceAccess(this.workspaceManager);
    }

    private Iterable<? extends IResourceServiceProvider> getAllLanguages() {
        Functions.Function1 _function = ext -> {
            URI synthUri = URI.createURI((String)("synth:///file." + ext));
            return this.languagesRegistry.getResourceServiceProvider(synthUri);
        };
        return IterableExtensions.toSet((Iterable)ListExtensions.map((List)IterableExtensions.sort((Iterable)IterableExtensions.toList(this.languagesRegistry.getExtensionToFactoryMap().keySet())), (Functions.Function1)_function));
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        if (this.params != null) {
            throw new IllegalStateException("This language server has already been initialized.");
        }
        URI baseDir = this.getBaseDir(params);
        boolean _isEmpty = this.languagesRegistry.getExtensionToFactoryMap().isEmpty();
        if (_isEmpty) {
            throw new IllegalStateException("No Xtext languages have been registered. Please make sure you have added the languages's setup class in '/META-INF/services/org.eclipse.xtext.ISetup'");
        }
        this.params = params;
        InitializeResult result = new InitializeResult();
        ServerCapabilities _serverCapabilities = new ServerCapabilities();
        Procedures.Procedure1 _function = it -> {
            boolean _tripleNotEquals;
            it.setHoverProvider(Boolean.valueOf(true));
            it.setDefinitionProvider(Boolean.valueOf(true));
            it.setReferencesProvider(Boolean.valueOf(true));
            it.setDocumentSymbolProvider(Boolean.valueOf(true));
            it.setWorkspaceSymbolProvider(Boolean.valueOf(true));
            Functions.Function1 _function_1 = it_1 -> {
                ICodeLensService _get = (ICodeLensService)it_1.get(ICodeLensService.class);
                return _get != null;
            };
            boolean _exists = IterableExtensions.exists(this.getAllLanguages(), (Functions.Function1)_function_1);
            if (_exists) {
                CodeLensOptions _codeLensOptions = new CodeLensOptions();
                Procedures.Procedure1 _function_2 = it_1 -> {
                    Functions.Function1 _function_3 = it_2 -> {
                        ICodeLensResolver _get = (ICodeLensResolver)it_2.get(ICodeLensResolver.class);
                        return _get != null;
                    };
                    it_1.setResolveProvider(IterableExtensions.exists(this.getAllLanguages(), (Functions.Function1)_function_3));
                };
                CodeLensOptions _doubleArrow = (CodeLensOptions)ObjectExtensions.operator_doubleArrow((Object)_codeLensOptions, (Procedures.Procedure1)_function_2);
                it.setCodeLensProvider(_doubleArrow);
            }
            Functions.Function1 _function_3 = it_1 -> {
                ICodeActionService _get = (ICodeActionService)it_1.get(ICodeActionService.class);
                return _get != null;
            };
            it.setCodeActionProvider(Boolean.valueOf(IterableExtensions.exists(this.getAllLanguages(), (Functions.Function1)_function_3)));
            SignatureHelpOptions _signatureHelpOptions = new SignatureHelpOptions(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"(", ","})));
            it.setSignatureHelpProvider(_signatureHelpOptions);
            it.setTextDocumentSync(TextDocumentSyncKind.Incremental);
            CompletionOptions _completionOptions = new CompletionOptions();
            Procedures.Procedure1 _function_4 = it_1 -> {
                it_1.setResolveProvider(Boolean.valueOf(false));
                it_1.setTriggerCharacters(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"."})));
            };
            CompletionOptions _doubleArrow_1 = (CompletionOptions)ObjectExtensions.operator_doubleArrow((Object)_completionOptions, (Procedures.Procedure1)_function_4);
            it.setCompletionProvider(_doubleArrow_1);
            it.setDocumentFormattingProvider(Boolean.valueOf(true));
            it.setDocumentRangeFormattingProvider(Boolean.valueOf(true));
            it.setDocumentHighlightProvider(Boolean.valueOf(true));
            Functions.Function1 _function_5 = it_1 -> {
                IRenameService _get = (IRenameService)it_1.get(IRenameService.class);
                return _get != null;
            };
            it.setRenameProvider(Boolean.valueOf(IterableExtensions.exists(this.getAllLanguages(), (Functions.Function1)_function_5)));
            ClientCapabilities _capabilities = params.getCapabilities();
            WorkspaceClientCapabilities _workspace = null;
            if (_capabilities != null) {
                _workspace = _capabilities.getWorkspace();
            }
            ExecuteCommandCapabilities _executeCommand = null;
            if (_workspace != null) {
                _executeCommand = _workspace.getExecuteCommand();
            }
            boolean bl = _tripleNotEquals = _executeCommand != null;
            if (_tripleNotEquals) {
                this.commandRegistry.initialize(this.getAllLanguages(), params.getCapabilities(), this.client);
                ExecuteCommandOptions _executeCommandOptions = new ExecuteCommandOptions();
                Procedures.Procedure1 _function_6 = it_1 -> it_1.setCommands(this.commandRegistry.getCommands());
                ExecuteCommandOptions _doubleArrow_2 = (ExecuteCommandOptions)ObjectExtensions.operator_doubleArrow((Object)_executeCommandOptions, (Procedures.Procedure1)_function_6);
                it.setExecuteCommandProvider(_doubleArrow_2);
            }
        };
        ServerCapabilities capabilities = (ServerCapabilities)ObjectExtensions.operator_doubleArrow((Object)_serverCapabilities, (Procedures.Procedure1)_function);
        Iterable<? extends IResourceServiceProvider> _allLanguages = this.getAllLanguages();
        for (IResourceServiceProvider iResourceServiceProvider : _allLanguages) {
            ICapabilitiesContributor _get = (ICapabilitiesContributor)iResourceServiceProvider.get(ICapabilitiesContributor.class);
            if (_get == null) continue;
            _get.contribute(capabilities, params);
        }
        result.setCapabilities(capabilities);
        this.access.addBuildListener(this);
        Functions.Function0 _function_1 = () -> {
            Procedures.Procedure2 _function_2 = ($0, $1) -> this.publishDiagnostics((URI)$0, (Iterable<? extends Issue>)$1);
            this.workspaceManager.initialize(baseDir, (Procedures.Procedure2<? super URI, ? super Iterable<Issue>>)_function_2, CancelIndicator.NullImpl);
            return null;
        };
        Functions.Function2 function2 = ($0, $1) -> null;
        Function<Object, InitializeResult> _function_3 = it -> result;
        return this.requestManager.runWrite(_function_1, function2).thenApply(_function_3);
    }

    @Deprecated
    private URI deprecatedToBaseDir(InitializeParams params) {
        boolean _tripleNotEquals;
        String _rootPath = params.getRootPath();
        boolean bl = _tripleNotEquals = _rootPath != null;
        if (_tripleNotEquals) {
            return this._uriExtensions.toUri(this._uriExtensions.toUriString(URI.createFileURI((String)params.getRootPath())));
        }
        return null;
    }

    protected URI getBaseDir(InitializeParams params) {
        boolean _tripleNotEquals;
        String _rootUri = params.getRootUri();
        boolean bl = _tripleNotEquals = _rootUri != null;
        if (_tripleNotEquals) {
            return this._uriExtensions.toUri(params.getRootUri());
        }
        return this.deprecatedToBaseDir(params);
    }

    public void connect(LanguageClient client) {
        this.client = client;
    }

    public void exit() {
        if (this.hasShutdownBeenCalled) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public CompletableFuture<Object> shutdown() {
        this.hasShutdownBeenCalled = true;
        Object _object = new Object();
        return CompletableFuture.completedFuture(_object);
    }

    public TextDocumentService getTextDocumentService() {
        return this;
    }

    public WorkspaceService getWorkspaceService() {
        return this;
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        Functions.Function0 _function = () -> this.workspaceManager.didOpen(this._uriExtensions.toUri(params.getTextDocument().getUri()), params.getTextDocument().getVersion(), params.getTextDocument().getText());
        Functions.Function2 _function_1 = (cancelIndicator, buildable) -> buildable.build((CancelIndicator)cancelIndicator);
        this.requestManager.runWrite(_function, _function_1);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        Functions.Function0 _function = () -> {
            Functions.Function1 _function_1 = event -> {
                Range _range = event.getRange();
                String _text = event.getText();
                return new TextEdit(_range, _text);
            };
            return this.workspaceManager.didChange(this._uriExtensions.toUri(params.getTextDocument().getUri()), params.getTextDocument().getVersion(), ListExtensions.map((List)params.getContentChanges(), (Functions.Function1)_function_1));
        };
        Functions.Function2 _function_1 = (cancelIndicator, buildable) -> buildable.build((CancelIndicator)cancelIndicator);
        this.requestManager.runWrite(_function, _function_1);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        Functions.Function0 _function = () -> this.workspaceManager.didClose(this._uriExtensions.toUri(params.getTextDocument().getUri()));
        Functions.Function2 _function_1 = (cancelIndicator, buildable) -> buildable.build((CancelIndicator)cancelIndicator);
        this.requestManager.runWrite(_function, _function_1);
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        Functions.Function0 _function = () -> {
            BuildManager.Buildable _xblockexpression = null;
            ArrayList dirtyFiles = CollectionLiterals.newArrayList();
            ArrayList deletedFiles = CollectionLiterals.newArrayList();
            List _changes = params.getChanges();
            for (FileEvent fileEvent : _changes) {
                boolean _tripleEquals;
                FileChangeType _type = fileEvent.getType();
                boolean bl = _tripleEquals = _type == FileChangeType.Deleted;
                if (_tripleEquals) {
                    URI _uri = this._uriExtensions.toUri(fileEvent.getUri());
                    deletedFiles.add(_uri);
                    continue;
                }
                URI _uri_1 = this._uriExtensions.toUri(fileEvent.getUri());
                dirtyFiles.add(_uri_1);
            }
            _xblockexpression = this.workspaceManager.didChangeFiles(dirtyFiles, deletedFiles);
            return _xblockexpression;
        };
        Functions.Function2 _function_1 = (cancelIndicator, buildable) -> buildable.build((CancelIndicator)cancelIndicator);
        this.requestManager.runWrite(_function, _function_1);
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        Functions.Function0 _function = () -> {
            this.workspaceManager.refreshWorkspaceConfig(CancelIndicator.NullImpl);
            return null;
        };
        Functions.Function2 _function_1 = ($0, $1) -> null;
        this.requestManager.runWrite(_function, _function_1);
    }

    private void publishDiagnostics(URI uri, Iterable<? extends Issue> issues) {
        PublishDiagnosticsParams _publishDiagnosticsParams = new PublishDiagnosticsParams();
        Procedures.Procedure1 _function = it -> {
            it.setUri(this._uriExtensions.toUriString(uri));
            Functions.Function1 _function_1 = it_1 -> {
                Severity _severity = it_1.getSeverity();
                return _severity != Severity.IGNORE;
            };
            Functions.Function1 _function_2 = it_1 -> this.toDiagnostic((Issue)it_1);
            it.setDiagnostics(IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)issues, (Functions.Function1)_function_1), (Functions.Function1)_function_2)));
        };
        PublishDiagnosticsParams diagnostics = (PublishDiagnosticsParams)ObjectExtensions.operator_doubleArrow((Object)_publishDiagnosticsParams, (Procedures.Procedure1)_function);
        this.client.publishDiagnostics(diagnostics);
    }

    private Diagnostic toDiagnostic(Issue issue) {
        Diagnostic _diagnostic = new Diagnostic();
        Procedures.Procedure1 _function = it -> {
            it.setCode(issue.getCode());
            DiagnosticSeverity _switchResult = null;
            Severity _severity = issue.getSeverity();
            if (_severity != null) {
                switch (_severity) {
                    case ERROR: {
                        _switchResult = DiagnosticSeverity.Error;
                        break;
                    }
                    case WARNING: {
                        _switchResult = DiagnosticSeverity.Warning;
                        break;
                    }
                    case INFO: {
                        _switchResult = DiagnosticSeverity.Information;
                        break;
                    }
                    default: {
                        _switchResult = DiagnosticSeverity.Hint;
                        break;
                    }
                }
            } else {
                _switchResult = DiagnosticSeverity.Hint;
            }
            it.setSeverity(_switchResult);
            it.setMessage(issue.getMessage());
            Integer _elvis = null;
            Integer _lineNumber = issue.getLineNumber();
            _elvis = _lineNumber != null ? _lineNumber : Integer.valueOf(1);
            int lineNumber = _elvis - 1;
            Integer _elvis_1 = null;
            Integer _column = issue.getColumn();
            _elvis_1 = _column != null ? _column : Integer.valueOf(1);
            int column = _elvis_1 - 1;
            Integer _elvis_2 = null;
            Integer _length = issue.getLength();
            _elvis_2 = _length != null ? _length : Integer.valueOf(0);
            Integer length = _elvis_2;
            Position _position = new Position(lineNumber, column);
            Position _position_1 = new Position(lineNumber, column + length);
            Range _range = new Range(_position, _position_1);
            it.setRange(_range);
        };
        return (Diagnostic)ObjectExtensions.operator_doubleArrow((Object)_diagnostic, (Procedures.Procedure1)_function);
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        Functions.Function1 _function = cancelIndicator -> this.completion((CancelIndicator)cancelIndicator, params);
        return this.requestManager.runRead(_function);
    }

    protected Either<List<CompletionItem>, CompletionList> completion(CancelIndicator originalCancelIndicator, CompletionParams params) {
        ContentAssistService contentAssistService;
        BufferedCancelIndicator cancelIndicator = new BufferedCancelIndicator(originalCancelIndicator);
        URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
        IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
        ContentAssistService _get = null;
        if (resourceServiceProvider != null) {
            _get = (ContentAssistService)resourceServiceProvider.get(ContentAssistService.class);
        }
        if ((contentAssistService = _get) == null) {
            CompletionList _completionList = new CompletionList();
            return Either.forRight((Object)_completionList);
        }
        Functions.Function2 _function = (document, resource) -> contentAssistService.createCompletionList((Document)document, (XtextResource)resource, (TextDocumentPositionParams)params, cancelIndicator);
        CompletionList completionList = (CompletionList)this.workspaceManager.doRead(uri, _function);
        return Either.forRight((Object)completionList);
    }

    public CompletableFuture<List<? extends Location>> definition(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> this.definition((CancelIndicator)cancelIndicator, params);
        return this.requestManager.runRead(_function);
    }

    protected List<? extends Location> definition(CancelIndicator cancelIndicator, TextDocumentPositionParams params) {
        DocumentSymbolService documentSymbolService;
        URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
        IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
        DocumentSymbolService _get = null;
        if (resourceServiceProvider != null) {
            _get = (DocumentSymbolService)resourceServiceProvider.get(DocumentSymbolService.class);
        }
        if ((documentSymbolService = _get) == null) {
            return CollectionLiterals.emptyList();
        }
        Functions.Function2 _function = (document, resource) -> documentSymbolService.getDefinitions((Document)document, (XtextResource)resource, params, this.resourceAccess, cancelIndicator);
        return (List)this.workspaceManager.doRead(uri, _function);
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            DocumentSymbolService documentSymbolService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            DocumentSymbolService _get = null;
            if (resourceServiceProvider != null) {
                _get = (DocumentSymbolService)resourceServiceProvider.get(DocumentSymbolService.class);
            }
            if ((documentSymbolService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> documentSymbolService.getReferences((Document)document, (XtextResource)resource, params, this.resourceAccess, this.workspaceManager.getIndex(), (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends SymbolInformation>> documentSymbol(DocumentSymbolParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            DocumentSymbolService documentSymbolService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            DocumentSymbolService _get = null;
            if (resourceServiceProvider != null) {
                _get = (DocumentSymbolService)resourceServiceProvider.get(DocumentSymbolService.class);
            }
            if ((documentSymbolService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> documentSymbolService.getSymbols((Document)document, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            IResourceDescriptions indexData = this.workspaceManager.getIndex();
            return this.workspaceSymbolService.getSymbols(params.getQuery(), this.resourceAccess, indexData, (CancelIndicator)cancelIndicator);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            IHoverService hoverService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            IHoverService _get = null;
            if (resourceServiceProvider != null) {
                _get = (IHoverService)resourceServiceProvider.get(IHoverService.class);
            }
            if ((hoverService = _get) == null) {
                return IHoverService.EMPTY_HOVER;
            }
            Functions.Function2 _function_1 = (document, resource) -> hoverService.hover((Document)document, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (Hover)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            ISignatureHelpService helper;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            ISignatureHelpService _get = null;
            if (serviceProvider != null) {
                _get = (ISignatureHelpService)serviceProvider.get(ISignatureHelpService.class);
            }
            if ((helper = _get) == null) {
                return ISignatureHelpService.EMPTY;
            }
            Functions.Function2 _function_1 = (doc, resource) -> helper.getSignatureHelp((Document)doc, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (SignatureHelp)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            IDocumentHighlightService service;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            IDocumentHighlightService _get = null;
            if (serviceProvider != null) {
                _get = (IDocumentHighlightService)serviceProvider.get(IDocumentHighlightService.class);
            }
            if ((service = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (doc, resource) -> service.getDocumentHighlights((Document)doc, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends Command>> codeAction(CodeActionParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            ICodeActionService service;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            ICodeActionService _get = null;
            if (serviceProvider != null) {
                _get = (ICodeActionService)serviceProvider.get(ICodeActionService.class);
            }
            if ((service = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (doc, resource) -> service.getCodeActions((Document)doc, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    private void installURI(List<? extends CodeLens> codeLenses, String uri) {
        for (CodeLens codeLens : codeLenses) {
            boolean _tripleNotEquals;
            Object _data = codeLens.getData();
            boolean bl = _tripleNotEquals = _data != null;
            if (_tripleNotEquals) {
                codeLens.setData((Object)CollectionLiterals.newArrayList((Object[])new Object[]{uri, codeLens.getData()}));
                continue;
            }
            codeLens.setData((Object)uri);
        }
    }

    private URI uninstallURI(CodeLens lens) {
        URI result = null;
        Object _data = lens.getData();
        if (_data instanceof String) {
            result = URI.createURI((String)lens.getData().toString());
            lens.setData(null);
        } else {
            Object _data_1 = lens.getData();
            if (_data_1 instanceof List) {
                Object _data_2 = lens.getData();
                List l = (List)_data_2;
                result = URI.createURI((String)IterableExtensions.head((Iterable)l).toString());
                lens.setData(l.get(1));
            }
        }
        return result;
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            ICodeLensService codeLensService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            ICodeLensService _get = null;
            if (resourceServiceProvider != null) {
                _get = (ICodeLensService)resourceServiceProvider.get(ICodeLensService.class);
            }
            if ((codeLensService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> {
                List<? extends CodeLens> result = codeLensService.computeCodeLenses((Document)document, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
                this.installURI(result, uri.toString());
                return result;
            };
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        URI uri = this.uninstallURI(unresolved);
        if (uri == null) {
            return CompletableFuture.completedFuture(unresolved);
        }
        Functions.Function1 _function = cancelIndicator -> {
            ICodeLensResolver resolver;
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            ICodeLensResolver _get = null;
            if (resourceServiceProvider != null) {
                _get = (ICodeLensResolver)resourceServiceProvider.get(ICodeLensResolver.class);
            }
            if ((resolver = _get) == null) {
                return unresolved;
            }
            Functions.Function2 _function_1 = (document, resource) -> {
                CodeLens result = resolver.resolveCodeLens((Document)document, (XtextResource)resource, unresolved, (CancelIndicator)cancelIndicator);
                return result;
            };
            return (CodeLens)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            FormattingService formatterService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            FormattingService _get = null;
            if (resourceServiceProvider != null) {
                _get = (FormattingService)resourceServiceProvider.get(FormattingService.class);
            }
            if ((formatterService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> formatterService.format((Document)document, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            FormattingService formatterService;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            FormattingService _get = null;
            if (resourceServiceProvider != null) {
                _get = (FormattingService)resourceServiceProvider.get(FormattingService.class);
            }
            if ((formatterService = _get) == null) {
                return CollectionLiterals.emptyList();
            }
            Functions.Function2 _function_1 = (document, resource) -> formatterService.format((Document)document, (XtextResource)resource, params, (CancelIndicator)cancelIndicator);
            return (List)this.workspaceManager.doRead(uri, _function_1);
        };
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        Functions.Function1 _function = cancelIndicator -> this.commandRegistry.executeCommand(params, this.access, (CancelIndicator)cancelIndicator);
        return this.requestManager.runRead(_function);
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        throw new UnsupportedOperationException("TODO: auto-generated method stub");
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        Functions.Function1 _function = cancelIndicator -> {
            IRenameService renameService;
            WorkspaceEdit _xblockexpression = null;
            URI uri = this._uriExtensions.toUri(params.getTextDocument().getUri());
            IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
            IRenameService _get = null;
            if (resourceServiceProvider != null) {
                _get = (IRenameService)resourceServiceProvider.get(IRenameService.class);
            }
            if ((renameService = _get) == null) {
                return new WorkspaceEdit();
            }
            _xblockexpression = renameService.rename(this.workspaceManager, params, (CancelIndicator)cancelIndicator);
            return _xblockexpression;
        };
        return this.requestManager.runRead(_function);
    }

    public void notify(String method, Object parameter) {
        Collection _get = this.extensionProviders.get((Object)method);
        for (Endpoint endpoint : _get) {
            try {
                endpoint.notify(method, parameter);
            }
            catch (Throwable _t) {
                if (_t instanceof UnsupportedOperationException) {
                    UnsupportedOperationException e = (UnsupportedOperationException)_t;
                    if (e == ILanguageServerExtension.NOT_HANDLED_EXCEPTION) continue;
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
    }

    public CompletableFuture<?> request(String method, Object parameter) {
        boolean _not;
        boolean _containsKey = this.extensionProviders.containsKey((Object)method);
        boolean bl = _not = !_containsKey;
        if (_not) {
            throw new UnsupportedOperationException("The json request '" + method + "' is unknown.");
        }
        Collection _get = this.extensionProviders.get((Object)method);
        for (Endpoint endpoint : _get) {
            try {
                return endpoint.request(method, parameter);
            }
            catch (Throwable _t) {
                if (_t instanceof UnsupportedOperationException) {
                    UnsupportedOperationException e = (UnsupportedOperationException)_t;
                    if (e == ILanguageServerExtension.NOT_HANDLED_EXCEPTION) continue;
                    throw e;
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, JsonRpcMethod> supportedMethods() {
        if (this.supportedMethods != null) {
            return this.supportedMethods;
        }
        Multimap<String, Endpoint> multimap = this.extensionProviders;
        synchronized (multimap) {
            LinkedHashMap supportedMethods = CollectionLiterals.newLinkedHashMap();
            supportedMethods.putAll(ServiceEndpoints.getSupportedMethods(this.getClass()));
            LinkedHashMap extensions = CollectionLiterals.newLinkedHashMap();
            Iterable _filter = Iterables.filter((Iterable)IterableExtensions.toSet(this.languagesRegistry.getExtensionToFactoryMap().values()), IResourceServiceProvider.class);
            for (IResourceServiceProvider resourceServiceProvider : _filter) {
                ILanguageServerExtension ext = (ILanguageServerExtension)resourceServiceProvider.get(ILanguageServerExtension.class);
                if (ext == null) continue;
                ext.initialize(this.access);
                Map _xifexpression = null;
                _xifexpression = ext instanceof JsonRpcMethodProvider ? ((JsonRpcMethodProvider)ext).supportedMethods() : ServiceEndpoints.getSupportedMethods(ext.getClass());
                Map supportedExtensions = _xifexpression;
                Set _entrySet = supportedExtensions.entrySet();
                for (Map.Entry entry : _entrySet) {
                    boolean _containsKey = supportedMethods.containsKey(entry.getKey());
                    if (_containsKey) {
                        String _key = (String)entry.getKey();
                        String _plus = "The json rpc method '" + _key;
                        String _plus_1 = _plus + "' can not be an extension as it is already defined in the LSP standard.";
                        LOG.error((Object)_plus_1);
                        continue;
                    }
                    JsonRpcMethod existing = (JsonRpcMethod)extensions.put(entry.getKey(), entry.getValue());
                    if (existing != null && !Objects.equal((Object)existing, entry.getValue())) {
                        String _key_1 = (String)entry.getKey();
                        String _plus_2 = "An incompatible LSP extension '" + _key_1;
                        String _plus_3 = _plus_2 + "' has already been registered. Using 1 ignoring 2. \n1 : ";
                        String _plus_4 = _plus_3 + existing;
                        String _plus_5 = _plus_4 + " \n2 : ";
                        JsonRpcMethod _value = (JsonRpcMethod)entry.getValue();
                        String _plus_6 = _plus_5 + _value;
                        LOG.error((Object)_plus_6);
                        extensions.put(entry.getKey(), existing);
                        continue;
                    }
                    Endpoint endpoint = ServiceEndpoints.toEndpoint((Object)ext);
                    this.extensionProviders.put(entry.getKey(), (Object)endpoint);
                    supportedMethods.put(entry.getKey(), entry.getValue());
                }
            }
            this.supportedMethods = supportedMethods;
            return supportedMethods;
        }
    }

    @Override
    public void afterBuild(List<IResourceDescription.Delta> deltas) {
        if (this.client instanceof LanguageClientExtensions) {
            Functions.Function1 _function = it -> {
                IResourceDescription _new = it.getNew();
                return _new != null;
            };
            Functions.Function1 _function_1 = it -> it.getUri().toString();
            Consumer<String> _function_2 = it -> {
                Function<ILanguageServerAccess.Context, Void> _function_3 = ctx -> {
                    boolean _isDocumentOpen = ctx.isDocumentOpen();
                    if (_isDocumentOpen) {
                        Resource _resource = ctx.getResource();
                        if (_resource instanceof XtextResource) {
                            IColoringService coloringService;
                            Resource _resource_1 = ctx.getResource();
                            XtextResource resource = (XtextResource)_resource_1;
                            IResourceServiceProvider serviceProvider = this.languagesRegistry.getResourceServiceProvider(resource.getURI());
                            IColoringService _get = null;
                            if (serviceProvider != null) {
                                _get = (IColoringService)serviceProvider.get(IColoringService.class);
                            }
                            if ((coloringService = _get) != null) {
                                boolean _not;
                                Document doc = ctx.getDocument();
                                List<? extends ColoringInformation> coloringInfos = coloringService.getColoring(resource, doc);
                                boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(coloringInfos);
                                boolean bl = _not = !_isNullOrEmpty;
                                if (_not) {
                                    String uri = resource.getURI().toString();
                                    ColoringParams _coloringParams = new ColoringParams(uri, coloringInfos);
                                    ((LanguageClientExtensions)this.client).updateColoring(_coloringParams);
                                }
                            }
                        }
                        return null;
                    }
                    return null;
                };
                this.access.doRead((String)it, _function_3);
            };
            IterableExtensions.map((Iterable)IterableExtensions.filter(deltas, (Functions.Function1)_function), (Functions.Function1)_function_1).forEach(_function_2);
        }
    }

    @Pure
    public RequestManager getRequestManager() {
        return this.requestManager;
    }

    @FinalFieldsConstructor
    public static class BufferedCancelIndicator
    implements CancelIndicator {
        private final CancelIndicator delegate;
        private Long canceledSince;

        public boolean isCanceled() {
            if (this.canceledSince == null && this.delegate.isCanceled()) {
                this.canceledSince = System.currentTimeMillis();
                return false;
            }
            return this.canceledSince != null && System.currentTimeMillis() > this.canceledSince + 1000L;
        }

        public BufferedCancelIndicator(CancelIndicator delegate) {
            this.delegate = delegate;
        }
    }
}

