/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.TypeParameterDeclaration;
import com.sun.mirror.type.ReferenceType;
import com.sun.mirror.type.TypeVariable;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import com.sun.mirror.util.TypeVisitor;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.apt.core.internal.declaration.DeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.declaration.TypeDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.apt.core.internal.util.SourcePositionImpl;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class TypeParameterDeclarationImpl
extends DeclarationImpl
implements TypeParameterDeclaration,
TypeVariable,
EclipseMirrorType {
    public TypeParameterDeclarationImpl(ITypeBinding binding, BaseProcessorEnv env) {
        super((IBinding)binding, env);
        assert (binding.isTypeVariable());
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visitTypeParameterDeclaration(this);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return null;
    }

    @Override
    public Collection<AnnotationMirror> getAnnotationMirrors() {
        return Collections.emptyList();
    }

    @Override
    public Collection<ReferenceType> getBounds() {
        ITypeBinding[] bounds = this.getDeclarationBinding().getTypeBounds();
        if (bounds == null || bounds.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>(4);
        ITypeBinding[] iTypeBindingArray = bounds;
        int n = bounds.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding bound = iTypeBindingArray[n2];
            TypeDeclarationImpl type = Factory.createReferenceType(bound, this._env);
            if (type != null) {
                result.add(type);
            }
            ++n2;
        }
        return result;
    }

    @Override
    public String getDocComment() {
        return null;
    }

    @Override
    public Collection<Modifier> getModifiers() {
        return Collections.emptyList();
    }

    @Override
    public Declaration getOwner() {
        return Factory.createDeclaration(this.getOwnerBinding(), this._env);
    }

    private IBinding getOwnerBinding() {
        ITypeBinding binding = this.getDeclarationBinding();
        ITypeBinding owner = binding.getDeclaringClass();
        if (owner == null) {
            owner = binding.getDeclaringMethod();
        }
        return owner;
    }

    @Override
    public SourcePosition getPosition() {
        if (this.isFromSource()) {
            ASTNode node = this.getAstNode();
            if (node == null) {
                return null;
            }
            CompilationUnit unit = this.getCompilationUnit();
            int offset = node.getStartPosition();
            return new SourcePositionImpl(offset, node.getLength(), unit.getLineNumber(offset), unit.getColumnNumber(offset), this);
        }
        return null;
    }

    @Override
    public String getSimpleName() {
        ITypeBinding typeVar = this.getDeclarationBinding();
        return typeVar.getName();
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visitTypeVariable(this);
    }

    @Override
    public TypeParameterDeclaration getDeclaration() {
        return this;
    }

    @Override
    public String toString() {
        return this.getSimpleName();
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.TYPE_PARAMETER_VARIABLE;
    }

    public ITypeBinding getDeclarationBinding() {
        return (ITypeBinding)this._binding;
    }

    @Override
    public ITypeBinding getTypeBinding() {
        return (ITypeBinding)this._binding;
    }

    @Override
    public boolean isFromSource() {
        return this.getDeclarationBinding().isFromSource();
    }

    @Override
    public boolean isAssignmentCompatible(EclipseMirrorType left) {
        return this.isSubTypeCompatible(left);
    }

    @Override
    public boolean isSubTypeCompatible(EclipseMirrorType type) {
        if (type.kind() == EclipseMirrorObject.MirrorKind.TYPE_PARAMETER_VARIABLE) {
            TypeParameterDeclarationImpl other = (TypeParameterDeclarationImpl)type;
            return this.getOwnerBinding() == other.getOwnerBinding() && this.getSimpleName().equals(other.getSimpleName());
        }
        for (ReferenceType bound : this.getBounds()) {
            if (!((EclipseMirrorType)((Object)bound)).isSubTypeCompatible(type)) continue;
            return true;
        }
        return false;
    }
}

