/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.domain.factory.EditingDomainFactoryListenerRegistry;
import org.eclipse.sphinx.emf.domain.factory.ITransactionalEditingDomainFactoryListener;
import org.eclipse.sphinx.emf.explorer.internal.Activator;
import org.eclipse.sphinx.emf.messages.EMFMessages;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.emf.workspace.domain.WorkspaceEditingDomainManager;
import org.eclipse.sphinx.emf.workspace.internal.saving.ModelSavingPerformanceStats;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveablesProvider;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.messages.PlatformMessages;
import org.eclipse.sphinx.platform.stats.IEventTypeEnumerator;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.SaveablesProvider;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ExtendedCommonNavigator
extends CommonNavigator
implements ITabbedPropertySheetPageContributor,
IViewerProvider,
ITransactionalEditingDomainFactoryListener {
    private static final String TAG_SELECTED = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".selection";
    private static final String TAG_EXPANDED = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".expanded";
    private static final String TAG_ELEMENT = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".element";
    private static final String TAG_PATH = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".path";
    private static final String TAG_URI = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".uri";
    private IOperationHistoryListener affectedObjectsListener;
    private IResourceChangeListener resourceMarkerChangeListener;
    protected Set<IPropertySheetPage> propertySheetPages = new HashSet<IPropertySheetPage>();
    protected IUndoContext undoContext;
    protected SaveablesProvider modelSaveablesProvider;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof PropertySheet) {
                ((PropertySheet)part).getCurrentPage().dispose();
                ExtendedCommonNavigator.this.propertySheetPages.remove(((PropertySheet)part).getCurrentPage());
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (this.modelSaveablesProvider == null) {
            this.modelSaveablesProvider = this.createModelSaveablesProvider();
            ISaveablesLifecycleListener modelSaveablesLifecycleListener = this.createModelSaveablesLifecycleListener();
            this.modelSaveablesProvider.init(modelSaveablesLifecycleListener);
        }
        site.getPage().addPartListener(this.partListener);
        this.affectedObjectsListener = this.createAffectedObjectsListener();
        Assert.isNotNull((Object)this.affectedObjectsListener);
        EditingDomainFactoryListenerRegistry.INSTANCE.addListener(MetaModelDescriptorRegistry.ANY_MM, null, (ITransactionalEditingDomainFactoryListener)this, null);
        for (TransactionalEditingDomain editingDomain : WorkspaceEditingDomainManager.INSTANCE.getEditingDomainMapping().getEditingDomains()) {
            WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).addOperationHistoryListener(this.affectedObjectsListener);
        }
        if (this.resourceMarkerChangeListener == null) {
            this.resourceMarkerChangeListener = this.createResourceMarkerChangeListener();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceMarkerChangeListener, 1);
        }
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        return new CommonViewer(this.getViewSite().getId(), aParent, 770){

            public void refresh() {
                super.refresh();
                ExtendedCommonNavigator.this.restoreState(ExtendedCommonNavigator.this.memento);
            }

            public void refresh(Object element, boolean updateLabels) {
                super.refresh(element, updateLabels);
                ExtendedCommonNavigator.this.restoreState(ExtendedCommonNavigator.this.memento);
            }
        };
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getNavigatorActionService().fillActionBars(this.getViewSite().getActionBars());
        this.restoreState(this.memento);
    }

    public boolean isDirty() {
        Saveable[] saveables;
        Saveable[] saveableArray = saveables = this.getActiveSaveables();
        int n = saveables.length;
        int n2 = 0;
        while (n2 < n) {
            Saveable element = saveableArray[n2];
            if (element.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Saveable[] getSaveables() {
        HashSet<Saveable> saveables = new HashSet<Saveable>(Arrays.asList(super.getSaveables()));
        if (this.modelSaveablesProvider != null) {
            saveables.addAll(Arrays.asList(this.modelSaveablesProvider.getSaveables()));
        }
        return saveables.toArray(new Saveable[saveables.size()]);
    }

    public Saveable[] getActiveSaveables() {
        String contextGetActiveSaveables = String.valueOf(ModelSavingPerformanceStats.ModelContext.CONTEXT_GET_ACTIVE_SAVEABLES.getName()) + ((Object)((Object)this)).getClass().getSimpleName();
        ModelSavingPerformanceStats.ModelEvent modelEvent = ModelSavingPerformanceStats.ModelEvent.EVENT_GET_SAVEABLE;
        ModelSavingPerformanceStats.INSTANCE.openContext(contextGetActiveSaveables);
        ModelSavingPerformanceStats.INSTANCE.startNewEvent((IEventTypeEnumerator)modelEvent, (Object)((Object)((Object)this)).getClass().getSimpleName());
        HashSet<Saveable> saveables = new HashSet<Saveable>(Arrays.asList(super.getActiveSaveables()));
        if (this.modelSaveablesProvider != null) {
            CommonViewer viewer = this.getCommonViewer();
            if (viewer != null) {
                if (viewer.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    for (Object selected : selection.toList()) {
                        if (selected instanceof IContainer) {
                            IContainer container = (IContainer)selected;
                            Collection modelDescriptors = ModelDescriptorRegistry.INSTANCE.getModels(container);
                            for (IModelDescriptor modelDescriptor : modelDescriptors) {
                                Saveable saveable = this.modelSaveablesProvider.getSaveable((Object)modelDescriptor);
                                if (saveable == null) continue;
                                saveables.add(saveable);
                            }
                            continue;
                        }
                        Saveable saveable = this.modelSaveablesProvider.getSaveable(selected);
                        if (saveable == null) continue;
                        saveables.add(saveable);
                    }
                }
            } else {
                saveables.addAll(Arrays.asList(this.modelSaveablesProvider.getSaveables()));
            }
        }
        ModelSavingPerformanceStats.INSTANCE.endEvent((IEventTypeEnumerator)modelEvent, (Object)((Object)((Object)this)).getClass().getSimpleName());
        ModelSavingPerformanceStats.INSTANCE.closeAndLogContext(contextGetActiveSaveables);
        return saveables.toArray(new Saveable[saveables.size()]);
    }

    public String getContributorId() {
        return this.getViewSite().getId();
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class == adapter) {
            return this.getPropertySheetPage();
        }
        if (adapter == IUndoContext.class) {
            return this.getUndoContext();
        }
        return super.getAdapter(adapter);
    }

    public Viewer getViewer() {
        return this.getCommonViewer();
    }

    public void dispose() {
        if (this.modelSaveablesProvider != null) {
            this.modelSaveablesProvider.dispose();
        }
        this.modelSaveablesProvider = null;
        this.getSite().getPage().removePartListener(this.partListener);
        for (IPropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        this.propertySheetPages.clear();
        if (this.affectedObjectsListener != null) {
            for (TransactionalEditingDomain editingDomain : WorkspaceEditingDomainManager.INSTANCE.getEditingDomainMapping().getEditingDomains()) {
                WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).removeOperationHistoryListener(this.affectedObjectsListener);
            }
            EditingDomainFactoryListenerRegistry.INSTANCE.removeListener((ITransactionalEditingDomainFactoryListener)this);
        }
        this.affectedObjectsListener = null;
        if (this.resourceMarkerChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceMarkerChangeListener);
        }
        this.resourceMarkerChangeListener = null;
        super.dispose();
    }

    public void restoreState(IMemento memento) {
        Display display;
        final CommonViewer viewer = this.getCommonViewer();
        if (viewer == null || memento == null) {
            return;
        }
        XMLMemento deferredMemento = XMLMemento.createWriteRoot((String)memento.getType());
        final ArrayList<Object> expandedElements = new ArrayList<Object>();
        XMLMemento deferredExpandedMemento = (XMLMemento)deferredMemento.createChild(TAG_EXPANDED);
        IMemento expandedMemento = memento.getChild(TAG_EXPANDED);
        if (expandedMemento != null) {
            IMemento[] iMementoArray = expandedMemento.getChildren(TAG_ELEMENT);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento elementMemento = iMementoArray[n2];
                String path = elementMemento.getString(TAG_PATH);
                if (path != null) {
                    IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
                    if (resource instanceof IFile) {
                        IFile file = (IFile)resource;
                        if (EcorePlatformUtil.isFileLoaded((IFile)file)) {
                            expandedElements.add(resource);
                        } else {
                            IModelDescriptor modelDescriptor = ModelDescriptorRegistry.INSTANCE.getModel((IFile)resource);
                            if (modelDescriptor != null) {
                                ModelLoadManager.INSTANCE.loadModel(modelDescriptor, true, null);
                            }
                            deferredExpandedMemento.copyChild(elementMemento);
                        }
                    } else if (resource != null) {
                        expandedElements.add(resource);
                    }
                } else {
                    URI uri;
                    String uriString = elementMemento.getString(TAG_URI);
                    if (uriString != null && EcoreResourceUtil.exists((URI)(uri = URI.createURI((String)uriString, (boolean)true)))) {
                        EObject eObject = EcorePlatformUtil.getEObject((URI)uri);
                        if (eObject != null) {
                            expandedElements.add(eObject);
                        } else {
                            deferredExpandedMemento.copyChild(elementMemento);
                        }
                    }
                }
                ++n2;
            }
        }
        final ArrayList<EObject> selectedElements = new ArrayList<EObject>();
        XMLMemento deferredSelectedMemento = (XMLMemento)deferredMemento.createChild(TAG_SELECTED);
        IMemento selectedMemento = memento.getChild(TAG_SELECTED);
        if (selectedMemento != null) {
            IMemento[] iMementoArray = selectedMemento.getChildren(TAG_ELEMENT);
            int n = iMementoArray.length;
            int n3 = 0;
            while (n3 < n) {
                IMemento elementMemento = iMementoArray[n3];
                String uriString = elementMemento.getString(TAG_URI);
                if (uriString != null) {
                    URI uri = URI.createURI((String)uriString, (boolean)true);
                    EObject eObject = EcorePlatformUtil.getEObject((URI)uri);
                    if (eObject != null) {
                        selectedElements.add(eObject);
                    } else {
                        deferredSelectedMemento.copyChild(elementMemento);
                    }
                }
                ++n3;
            }
        }
        if (!(expandedElements.isEmpty() && selectedElements.isEmpty() || viewer.getControl() == null || viewer.getControl().isDisposed() || (display = viewer.getControl().getDisplay()) == null)) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed()) {
                        for (Object element : expandedElements) {
                            viewer.setExpandedState(element, true);
                        }
                        if (!selectedElements.isEmpty()) {
                            viewer.setSelection((ISelection)new StructuredSelection(selectedElements));
                        }
                    }
                }
            });
        }
        this.memento = deferredExpandedMemento.getChildren().length > 0 || deferredSelectedMemento.getChildren().length > 0 ? deferredMemento : null;
    }

    public void saveState(IMemento memento) {
        CommonViewer viewer = this.getCommonViewer();
        if (viewer != null && memento != null) {
            Object[] selectedElements;
            int n;
            Object[] expandedElements = viewer.getVisibleExpandedElements();
            if (expandedElements.length > 0) {
                IMemento expandedMemento = memento.createChild(TAG_EXPANDED);
                Object[] objectArray = expandedElements;
                n = expandedElements.length;
                int n2 = 0;
                while (n2 < n) {
                    URI uri;
                    IMemento elementMemento;
                    Object expandedElement = objectArray[n2];
                    if (expandedElement instanceof IResource) {
                        IPath path = ((IResource)expandedElement).getFullPath();
                        elementMemento = expandedMemento.createChild(TAG_ELEMENT);
                        elementMemento.putString(TAG_PATH, path.toString());
                    }
                    if (expandedElement instanceof EObject && (uri = this.getURI((EObject)expandedElement)) != null) {
                        elementMemento = expandedMemento.createChild(TAG_ELEMENT);
                        elementMemento.putString(TAG_URI, uri.toString());
                    }
                    ++n2;
                }
            }
            if ((selectedElements = ((IStructuredSelection)viewer.getSelection()).toArray()).length > 0) {
                IMemento selectedMemento = memento.createChild(TAG_SELECTED);
                Object[] objectArray = selectedElements;
                int n3 = selectedElements.length;
                n = 0;
                while (n < n3) {
                    URI uri;
                    Object selectedElement = objectArray[n];
                    if (selectedElement instanceof EObject && (uri = this.getURI((EObject)selectedElement)) != null) {
                        IMemento elementMemento = selectedMemento.createChild(TAG_ELEMENT);
                        elementMemento.putString(TAG_URI, uri.toString());
                    }
                    ++n;
                }
            }
        }
        super.saveState(memento);
    }

    public boolean show(ShowInContext context) {
        Object input = context.getInput();
        if (input != null) {
            List<IMarker> markers = this.retrieveRealMarkerSelection(input);
            ArrayList<EObject> objects = new ArrayList<EObject>();
            for (IMarker marker : markers) {
                EObject object = null;
                String uriAttribute = marker.getAttribute("uri", null);
                if (uriAttribute != null) {
                    object = EcorePlatformUtil.getEObject((URI)URI.createURI((String)uriAttribute, (boolean)true));
                }
                if (object == null) continue;
                objects.add(object);
            }
            if (objects.size() > 0) {
                try {
                    StructuredSelection selection = new StructuredSelection(objects);
                    this.selectReveal((ISelection)selection);
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
                return true;
            }
        }
        try {
            return super.show(context);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    protected List<IMarker> retrieveRealMarkerSelection(Object input) {
        if (input.getClass().toString().indexOf("MarkerAdapter") >= 0) {
            try {
                Field declaredField = input.getClass().getDeclaredField("view");
                if (declaredField != null) {
                    boolean oldAccessible = declaredField.isAccessible();
                    declaredField.setAccessible(true);
                    Object object = declaredField.get(input);
                    declaredField.setAccessible(oldAccessible);
                    Method getViewer = this.getMethod(object.getClass(), "getViewer");
                    if (getViewer == null) {
                        return Collections.emptyList();
                    }
                    oldAccessible = getViewer.isAccessible();
                    getViewer.setAccessible(true);
                    Object viewer = getViewer.invoke(object, new Object[0]);
                    getViewer.setAccessible(oldAccessible);
                    if (viewer instanceof StructuredViewer) {
                        ISelection selection = ((StructuredViewer)viewer).getSelection();
                        ArrayList<IMarker> markers = new ArrayList<IMarker>();
                        if (selection instanceof IStructuredSelection) {
                            for (Object next : (IStructuredSelection)selection) {
                                if (next instanceof IMarker) {
                                    markers.add((IMarker)next);
                                    continue;
                                }
                                if (next.getClass().toString().indexOf("Marker") < 0) continue;
                                Method getMarker = this.getMethod(next.getClass(), "getMarker");
                                if (getMarker == null) break;
                                oldAccessible = getMarker.isAccessible();
                                getMarker.setAccessible(true);
                                Object marker = getMarker.invoke(next, new Object[0]);
                                getMarker.setAccessible(oldAccessible);
                                markers.add((IMarker)marker);
                            }
                        }
                        return markers;
                    }
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return Collections.emptyList();
    }

    protected Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException {
        if (clazz == null) {
            throw new NoSuchMethodException(methodName);
        }
        Method declaredMethod = null;
        try {
            declaredMethod = clazz.getDeclaredMethod(methodName, new Class[0]);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return this.getMethod(clazz.getSuperclass(), methodName);
        }
        return declaredMethod;
    }

    protected Collection<TransactionalEditingDomain> getEditingDomainsFromSelection() {
        ISelection selection;
        HashSet<TransactionalEditingDomain> editingDomains = new HashSet<TransactionalEditingDomain>();
        CommonViewer viewer = this.getCommonViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection) {
            for (Object selected : ((IStructuredSelection)selection).toList()) {
                if (selected instanceof EObject && ((EObject)selected).eIsProxy()) {
                    PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException(NLS.bind((String)EMFMessages.warning_selectionContainsUnresolvedModelElement, selected)));
                    continue;
                }
                if (selected instanceof IProject || selected instanceof IFolder) {
                    editingDomains.addAll(WorkspaceEditingDomainUtil.getEditingDomains((IContainer)((IContainer)selected)));
                    continue;
                }
                TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain(selected);
                if (editingDomain == null) continue;
                editingDomains.add(editingDomain);
            }
        }
        return editingDomains;
    }

    protected URI getURI(final EObject eObject) {
        TransactionalEditingDomain editingDomain;
        if (eObject != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)eObject)) != null) {
            try {
                return (URI)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<URI>(){

                    public void run() {
                        this.setResult(EcoreUtil.getURI((EObject)eObject));
                    }
                });
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        return null;
    }

    public IPropertySheetPage getPropertySheetPage() {
        TabbedPropertySheetPage propertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        this.propertySheetPages.add((IPropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    protected IUndoContext getUndoContext() {
        if (this.undoContext == null) {
            this.undoContext = new ObjectUndoContext((Object)this, String.valueOf(this.getContributorId()) + ".context");
        }
        return this.undoContext;
    }

    protected boolean isActivePart() {
        IWorkbenchPartSite site = this.getSite();
        return site != null ? this == site.getWorkbenchWindow().getPartService().getActivePart() : false;
    }

    protected boolean isMyActivePropertySheetPage() {
        IWorkbenchPart activePart;
        IWorkbenchPartSite site = this.getSite();
        if (site != null && (activePart = site.getWorkbenchWindow().getPartService().getActivePart()) instanceof PropertySheet) {
            return this.propertySheetPages.contains(((PropertySheet)activePart).getCurrentPage());
        }
        return false;
    }

    protected SaveablesProvider createModelSaveablesProvider() {
        return new BasicModelSaveablesProvider();
    }

    protected IResourceChangeListener createResourceMarkerChangeListener() {
        return new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                Assert.isNotNull((Object)event);
                IMarkerDelta[] markerDelta = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
                if (markerDelta != null && markerDelta.length > 0) {
                    UIJob job = new UIJob(PlatformMessages.job_updatingLabelDecoration){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            ExtendedCommonNavigator.this.updateLabelDecoration();
                            return Status.OK_STATUS;
                        }

                        public boolean belongsTo(Object family) {
                            return IExtendedPlatformConstants.FAMILY_LABEL_DECORATION.equals(family);
                        }
                    };
                    if (Job.getJobManager().find(IExtendedPlatformConstants.FAMILY_LABEL_DECORATION).length == 0) {
                        job.setPriority(40);
                        job.setSystem(true);
                        job.schedule();
                    }
                }
            }
        };
    }

    protected IOperationHistoryListener createAffectedObjectsListener() {
        return new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                if (event.getEventType() == 1) {
                    this.handleOperationAboutToExecute(event.getOperation());
                } else if (event.getEventType() == 4 || event.getEventType() == 10 || event.getEventType() == 9) {
                    this.handleOperationFinished(event.getOperation());
                }
            }

            private void handleOperationAboutToExecute(final IUndoableOperation operation) {
                IWorkbenchPartSite site;
                if (operation.canUndo() && (site = ExtendedCommonNavigator.this.getSite()) != null) {
                    site.getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (ExtendedCommonNavigator.this.isActivePart() || ExtendedCommonNavigator.this.isMyActivePropertySheetPage()) {
                                for (TransactionalEditingDomain editingDomain : ExtendedCommonNavigator.this.getEditingDomainsFromSelection()) {
                                    IUndoContext undoContext;
                                    CommandStack commandStack = editingDomain.getCommandStack();
                                    if (!(commandStack instanceof IWorkspaceCommandStack) || (undoContext = ((IWorkspaceCommandStack)commandStack).getDefaultUndoContext()) == null) continue;
                                    operation.removeContext(undoContext);
                                }
                                operation.addContext(ExtendedCommonNavigator.this.getUndoContext());
                            }
                        }
                    });
                }
            }

            private void handleOperationFinished(final IUndoableOperation operation) {
                IWorkbenchPartSite site = ExtendedCommonNavigator.this.getSite();
                if (site != null) {
                    site.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Collection affectedObjects;
                            Command command;
                            if (operation instanceof EMFCommandOperation && (command = ((EMFCommandOperation)operation).getCommand()) != null && (affectedObjects = command.getAffectedObjects()).size() > 0) {
                                try {
                                    StructuredSelection selection = new StructuredSelection(affectedObjects.toArray());
                                    ExtendedCommonNavigator.this.selectReveal((ISelection)selection);
                                }
                                catch (RuntimeException runtimeException) {}
                            }
                        }
                    });
                }
            }
        };
    }

    protected ISaveablesLifecycleListener createModelSaveablesLifecycleListener() {
        return new BasicModelSaveablesProvider.SiteNotifyingSaveablesLifecycleListener((IWorkbenchPart)this){

            public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
                super.handleLifecycleEvent(event);
                if (event.getEventType() == 4) {
                    ExtendedCommonNavigator.this.firePropertyChange(257);
                }
            }
        };
    }

    protected void updateLabelDecoration() {
        PlatformUI.getWorkbench().getDecoratorManager().update("org.eclipse.sphinx.emf.validation.ui.decorator");
    }

    public void postCreateEditingDomain(TransactionalEditingDomain editingDomain) {
        WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).addOperationHistoryListener(this.affectedObjectsListener);
    }

    public void preDisposeEditingDomain(TransactionalEditingDomain editingDomain) {
        if (this.affectedObjectsListener != null) {
            WorkspaceTransactionUtil.getOperationHistory((TransactionalEditingDomain)editingDomain).removeOperationHistoryListener(this.affectedObjectsListener);
        }
    }
}

