/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.outlet;

import java.io.File;
import org.eclipse.core.internal.resources.projectvariables.ProjectLocationVariableResolver;
import org.eclipse.core.internal.resources.projectvariables.WorkspaceLocationVariableResolver;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sphinx.xtendxpand.internal.EObjectAdapaterFactory;
import org.eclipse.xpand2.output.Outlet;

public class ExtendedOutlet
extends Outlet {
    public static final String VARIABLE_ARGUMENT_SEPARATOR = ":";
    public static final String VARIABLE_WORKSPACE_LOC = WorkspaceLocationVariableResolver.NAME.toLowerCase();
    public static final String VARIABLE_PROJECT_LOC = ProjectLocationVariableResolver.NAME.toLowerCase();
    private String pathExpression = null;
    private boolean protectedRegion = false;

    public ExtendedOutlet() {
    }

    public ExtendedOutlet(IContainer container) {
        this.setPath(container);
    }

    public ExtendedOutlet(String pathExpression) {
        this.setPathExpression(pathExpression, null);
    }

    public ExtendedOutlet(String pathExpression, boolean protectedRegion) {
        this.setPathExpression(pathExpression, null);
        this.setProtectedRegion(protectedRegion);
    }

    public ExtendedOutlet(String pathExpression, IProject project) {
        this.setPathExpression(pathExpression, project);
    }

    public ExtendedOutlet(String pathExpression, IProject project, boolean protectedRegion) {
        this.setPathExpression(pathExpression, project);
        this.setProtectedRegion(protectedRegion);
    }

    public ExtendedOutlet(String name, IContainer container) {
        this(container);
        this.setName(name);
    }

    public ExtendedOutlet(String name, String pathExpression) {
        this(pathExpression);
        this.setName(name);
    }

    public ExtendedOutlet(String name, String pathExpression, boolean protectedRegion) {
        this(pathExpression, protectedRegion);
        this.setName(name);
    }

    public ExtendedOutlet(String name, String pathExpression, IProject project) {
        this(pathExpression, project);
        this.setName(name);
    }

    public ExtendedOutlet(String name, String pathExpression, IProject project, boolean protectedRegion) {
        this(pathExpression, project, protectedRegion);
        this.setName(name);
    }

    public void setProtectedRegion(boolean protectedRegion) {
        this.protectedRegion = protectedRegion;
    }

    public boolean isProtectedRegion() {
        return this.protectedRegion;
    }

    public String getPathExpression() {
        if (this.pathExpression != null) {
            return this.pathExpression;
        }
        return this.getPath();
    }

    public void setPathExpression(String pathExpression, IProject project) {
        Assert.isNotNull((Object)pathExpression);
        String path = this.resolvePathExpression(pathExpression, project);
        this.setPath(path);
        this.pathExpression = !pathExpression.equals(path) ? pathExpression : null;
    }

    protected String resolvePathExpression(String pathExpression, IProject project) {
        block11: {
            Assert.isNotNull((Object)pathExpression);
            try {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                if (pathExpression.contains(VARIABLE_PROJECT_LOC) && project != null) {
                    pathExpression = pathExpression.replaceFirst(VARIABLE_PROJECT_LOC, String.valueOf(VARIABLE_PROJECT_LOC) + VARIABLE_ARGUMENT_SEPARATOR + project.getName());
                }
                Platform.getAdapterManager().registerAdapters((IAdapterFactory)EObjectAdapaterFactory.INSTANCE, EObject.class);
                String resolvedPath = manager.performStringSubstitution(pathExpression);
                Path path = new Path(resolvedPath);
                if (path.isAbsolute()) {
                    String string = path.toFile().getAbsolutePath();
                    return string;
                }
                IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
                if (resource != null) {
                    IPath location = resource.getLocation();
                    if (location != null) {
                        String string = location.toFile().getAbsolutePath();
                        return string;
                    }
                    break block11;
                }
                String string = path.toFile().getAbsolutePath();
                return string;
            }
            catch (CoreException coreException) {
            }
            finally {
                Platform.getAdapterManager().unregisterAdapters((IAdapterFactory)EObjectAdapaterFactory.INSTANCE, EObject.class);
            }
        }
        return null;
    }

    public void setPath(IContainer container) {
        if (container.getProject().exists()) {
            IPath location = container.getLocation();
            if (location != null) {
                this.setPath(location.toFile().getAbsolutePath());
            }
        } else {
            this.setPath(container.getFullPath().makeRelative().toFile().getAbsolutePath());
        }
        this.pathExpression = container.getFullPath().makeRelative().toString();
    }

    public IContainer getContainer() {
        String path = this.getPath();
        if (path != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(path));
        }
        return null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.valueOf(this.getName() != null ? this.getName() : "<default>") + "@");
        if (this.getPath() != null) {
            result.append(this.getPath());
        } else if (this.getPathExpression() != null) {
            result.append(this.getPathExpression());
        } else {
            result.append(new File("").getAbsolutePath());
        }
        if (this.isAppend() || !this.isOverwrite()) {
            result.append("(").append("overwrite=").append(this.isOverwrite()).append(",append=").append(this.isAppend()).append(",fileEncoding=").append(this.getFileEncoding()).append(")");
        }
        return result.toString();
    }
}

