/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer.refresh;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.sphinx.emf.explorer.IModelCommonContentProvider;
import org.eclipse.sphinx.emf.explorer.refresh.AbstractRefreshStrategy;

public class WorkspaceResourceRefreshStrategy
extends AbstractRefreshStrategy<IResource>
implements Runnable {
    private static final int MAX_INDIVIDUAL_WORKSPACE_RESOURCE_REFRESHES = 20;

    public WorkspaceResourceRefreshStrategy(IModelCommonContentProvider contentProvider, boolean preserveTreeViewerState) {
        super(contentProvider, preserveTreeViewerState);
    }

    @Override
    protected boolean shouldPerformSelectiveRefresh() {
        return this.getTreeElementsToRefresh().size() < 20;
    }

    @Override
    protected void performSelectiveRefresh(StructuredViewer viewer) {
        for (IResource workspaceResource : this.getTreeElementsToRefresh()) {
            if (workspaceResource == null || !workspaceResource.isAccessible() || !this.contentProvider.isTriggerPoint(workspaceResource)) continue;
            viewer.refresh((Object)workspaceResource, true);
        }
    }
}

