/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lirc.internal;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.smarthome.binding.lirc.LIRCBindingConstants;
import org.eclipse.smarthome.binding.lirc.handler.LIRCBridgeHandler;
import org.eclipse.smarthome.binding.lirc.handler.LIRCRemoteHandler;
import org.eclipse.smarthome.binding.lirc.internal.discovery.LIRCRemoteDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;

@Component(service={ThingHandlerFactory.class}, configurationPid="binding.lirc")
public class LIRCHandlerFactory
extends BaseThingHandlerFactory {
    private final Map<ThingUID, ServiceRegistration<?>> discoveryServiceRegs = new HashMap();

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return LIRCBindingConstants.SUPPORTED_THING_TYPES.contains(thingTypeUID);
    }

    protected ThingHandler createHandler(Thing thing) {
        ThingTypeUID thingTypeUID = thing.getThingTypeUID();
        if (LIRCBindingConstants.SUPPORTED_BRIDGE_TYPES.contains(thingTypeUID)) {
            LIRCBridgeHandler handler = new LIRCBridgeHandler((Bridge)thing);
            this.registerDeviceDiscoveryService(handler);
            return handler;
        }
        if (thingTypeUID.equals((Object)LIRCBindingConstants.THING_TYPE_REMOTE)) {
            return new LIRCRemoteHandler(thing);
        }
        return null;
    }

    protected synchronized void removeHandler(ThingHandler thingHandler) {
        ServiceRegistration<?> serviceReg;
        if (this.discoveryServiceRegs != null && (serviceReg = this.discoveryServiceRegs.remove(thingHandler.getThing().getUID())) != null) {
            serviceReg.unregister();
        }
    }

    private synchronized void registerDeviceDiscoveryService(LIRCBridgeHandler handler) {
        LIRCRemoteDiscoveryService discoveryService = new LIRCRemoteDiscoveryService(handler);
        this.discoveryServiceRegs.put(handler.getThing().getUID(), this.bundleContext.registerService(DiscoveryService.class.getName(), (Object)discoveryService, new Hashtable()));
    }
}

