/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.tools.memorymap;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tml.linuxtools.LinuxToolsPlugin;
import org.eclipse.tml.linuxtools.network.IConstants;
import org.eclipse.tml.linuxtools.tools.IListener;
import org.eclipse.tml.linuxtools.tools.INotifier;
import org.eclipse.tml.linuxtools.tools.ITool;
import org.eclipse.tml.linuxtools.tools.memorymap.MemoryMapTool;
import org.eclipse.tml.linuxtools.tools.memorymap.MemoryMapVViewLabelProvider;
import org.eclipse.tml.linuxtools.tools.memorymap.MemoryMapViewContentProvider;
import org.eclipse.tml.linuxtools.tools.memorymap.Messages;
import org.eclipse.tml.linuxtools.ui.DialogLogin;
import org.eclipse.tml.linuxtools.ui.IToolViewPart;
import org.eclipse.tml.linuxtools.ui.ViewActionConnect;
import org.eclipse.tml.linuxtools.ui.ViewActionDisconnect;
import org.eclipse.tml.linuxtools.ui.ViewActionRefresh;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class MemoryMapView
extends ViewPart
implements IToolViewPart,
IListener {
    private final String COL_LABEL_ADDRESS_START = Messages.MemoryMapView_Col_Label_Address_Start;
    private final String COL_LABEL_ADDRESS_END = Messages.MemoryMapView_Col_Label_Address_End;
    private final String COL_LABEL_REGION = Messages.MemoryMapView_Col_label_Region;
    private final int MAX_COLUMNS = 4;
    private ITool tool = null;
    private TableViewer viewer;
    private Action refreshAction;
    private Action disconnectAction;
    private Action connectAction;
    private IPartListener partActivationListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            ITool tool;
            if (MemoryMapView.this.getSite().getPart() == part && (tool = MemoryMapView.this.getTool()) != null) {
                tool.disconnect();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 66304);
        this.viewer.setContentProvider((IContentProvider)new MemoryMapViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MemoryMapVViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new AddressSorter());
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        new TableColumn(table, 16384).setText(this.COL_LABEL_ADDRESS_START);
        new TableColumn(table, 16384).setText(this.COL_LABEL_ADDRESS_END);
        new TableColumn(table, 16384).setText(this.COL_LABEL_REGION);
        this.refresh();
        this.resize();
        this.makeActions();
        this.addToToolBar();
        this.getViewSite().getWorkbenchWindow().getPartService().addPartListener(this.partActivationListener);
        this.setConnectEnabled(true);
        this.refreshAction.setEnabled(false);
    }

    private void addToToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarMmanager = actionBars.getToolBarManager();
        toolBarMmanager.add((IAction)this.refreshAction);
        toolBarMmanager.add((IAction)this.disconnectAction);
        toolBarMmanager.add((IAction)this.connectAction);
    }

    private void makeActions() {
        this.refreshAction = new Action(){

            public void run() {
                ViewActionRefresh delegate = new ViewActionRefresh();
                delegate.init((IViewPart)MemoryMapView.this);
                delegate.run((IAction)this);
                this.setEnabled(false);
            }
        };
        this.refreshAction.setToolTipText(Messages.MemoryMapView_Action_Refresh);
        this.refreshAction.setImageDescriptor(LinuxToolsPlugin.getDefault().getImageDescriptor("refresh.gif"));
        this.disconnectAction = new Action(){

            public void run() {
                ViewActionDisconnect delegate = new ViewActionDisconnect();
                delegate.init((IViewPart)MemoryMapView.this);
                delegate.run((IAction)this);
            }
        };
        this.disconnectAction.setToolTipText(Messages.MemoryMapView_Action_Disconnect);
        this.disconnectAction.setImageDescriptor(LinuxToolsPlugin.getDefault().getImageDescriptor("disconnect.gif"));
        this.connectAction = new Action(){

            public void run() {
                ViewActionConnect delegate = new ViewActionConnect();
                delegate.init((IViewPart)MemoryMapView.this);
                delegate.run((IAction)this);
            }
        };
        this.connectAction.setToolTipText(Messages.MemoryMapView_Action_Connect);
        this.connectAction.setImageDescriptor(LinuxToolsPlugin.getDefault().getImageDescriptor("connect.gif"));
    }

    private void setConnectEnabled(boolean bool) {
        this.connectAction.setEnabled(bool);
        this.disconnectAction.setEnabled(!bool);
    }

    public ITool getTool() {
        if (this.tool == null) {
            this.tool = new MemoryMapTool();
            this.tool.addListener((IListener)this);
        }
        return this.tool;
    }

    public void notify(INotifier notifier, IConstants.EventCode event, Object result) {
        if (notifier == this.tool) {
            final Object finalResult = result;
            final IConstants.EventCode finalEvent = event;
            final MemoryMapView finalView = this;
            final ITool finalTool = this.tool;
            this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    switch (finalEvent) {
                        case EVT_TOOL_REFRESH_VIEW: {
                            MemoryMapView.this.viewer.setInput(finalResult);
                            MemoryMapView.this.refreshAction.setEnabled(true);
                            MemoryMapView.this.refresh();
                            MemoryMapView.this.resize();
                            break;
                        }
                        case EVT_TOOL_CONNECT_FINISHED: 
                        case EVT_TOOL_LOGIN_FINISHED: {
                            switch ((IConstants.OperationCode)finalResult) {
                                case SUCCESS: {
                                    MemoryMapView.this.setConnectEnabled(false);
                                    MemoryMapView.this.refreshAction.setEnabled(true);
                                    break;
                                }
                                case LOGIN_REQUIRED: {
                                    DialogLogin dialog = new DialogLogin(finalView.getViewSite().getShell(), finalTool, false);
                                    dialog.open();
                                    break;
                                }
                                case LOGIN_FAILED: {
                                    DialogLogin dialog = new DialogLogin(finalView.getViewSite().getShell(), finalTool, true);
                                    dialog.open();
                                }
                            }
                            break;
                        }
                        case EVT_TOOL_DISCONNECT_FINISHED: {
                            MemoryMapView.this.setConnectEnabled(true);
                            MemoryMapView.this.refreshAction.setEnabled(false);
                        }
                    }
                }
            });
        }
    }

    public void refresh() {
        this.viewer.refresh();
    }

    public void resize() {
        Table table = this.viewer.getTable();
        int i = 0;
        int n = table.getColumnCount();
        while (i < n) {
            table.getColumn(i).pack();
            ++i;
        }
    }

    public void setData(Object data) {
        this.viewer.setInput(data);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private class AddressSorter
    extends ViewerSorter {
        private AddressSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int result = 0;
            try {
                int a = new Integer(((String[])e1)[3]);
                int b = new Integer(((String[])e2)[3]);
                if (a > b) {
                    result = 1;
                } else if (a < b) {
                    result = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            return result;
        }
    }
}

