/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.linuxtools.tools.cpuload;

import java.io.IOException;
import java.util.List;
import org.eclipse.tml.linuxtools.network.IConnectionProvider;
import org.eclipse.tml.linuxtools.network.IConstants;
import org.eclipse.tml.linuxtools.tools.AbstractNotifier;
import org.eclipse.tml.linuxtools.tools.IListener;
import org.eclipse.tml.linuxtools.tools.INotifier;
import org.eclipse.tml.linuxtools.tools.ITool;
import org.eclipse.tml.linuxtools.tools.cpuload.CpuLoadProcessor;
import org.eclipse.tml.linuxtools.utilities.Extensions;
import org.eclipse.tml.linuxtools.utilities.ProtocolDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CpuLoadTool
extends AbstractNotifier
implements IListener,
ITool {
    private IConnectionProvider connectionProvider = null;
    private CpuLoadProcessor processor = null;
    private int delay = 1000;
    private ToolStateEnum toolState = ToolStateEnum.STOPPED;
    private String[] requiredCapabilities = new String[]{"GET_FILE"};

    public void connect(String host, int port, ProtocolDescriptor protocol) {
        Class connectionProviderClass = protocol.getConnectionProviderClass();
        try {
            Object aux = connectionProviderClass.newInstance();
            this.connectionProvider = (IConnectionProvider)aux;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassCastException classCastException) {}
        this.connectionProvider.addListener((IListener)this);
        try {
            this.connectionProvider.connect(host, port);
        }
        catch (IOException iOException) {}
        this.processor = new CpuLoadProcessor(this.connectionProvider);
        this.processor.addListener(this);
        this.toolState = ToolStateEnum.STOPPED;
    }

    public void disconnect() {
        if (this.connectionProvider != null) {
            try {
                this.connectionProvider.disconnect();
            }
            catch (IOException iOException) {}
            this.connectionProvider = null;
            this.toolState = ToolStateEnum.STOPPED;
        }
    }

    public void login(String user, String password) {
        try {
            this.connectionProvider.login(user, password);
        }
        catch (IOException iOException) {}
    }

    public List<ProtocolDescriptor> getProtocolsDescriptors() {
        List pdList = Extensions.findProcotols((String[])this.requiredCapabilities);
        return pdList;
    }

    public void notify(INotifier notifier, IConstants.EventCode event, Object result) {
        block22: {
            try {
                if (notifier == this.connectionProvider) {
                    switch (event) {
                        case EVT_PROVIDER_CONNECT_FINISHED: {
                            if (IConstants.OperationCode.SUCCESS == result) {
                                this.start();
                            }
                            this.notifyListeners(IConstants.EventCode.EVT_TOOL_CONNECT_FINISHED, result);
                            break;
                        }
                        case EVT_PROVIDER_CONNECT_ERROR: {
                            break;
                        }
                        case EVT_PROVIDER_LOGIN_FINISHED: {
                            if (IConstants.OperationCode.SUCCESS == result) {
                                this.start();
                            }
                            this.notifyListeners(IConstants.EventCode.EVT_TOOL_LOGIN_FINISHED, result);
                            break;
                        }
                        case EVT_PROVIDER_SENDCOMMAND_FINISHED: {
                            break;
                        }
                        case EVT_PROVIDER_SENDCOMMAND_ERROR: {
                            break;
                        }
                        case EVT_PROVIDER_SENDDATA_FINISHED: {
                            break;
                        }
                        case EVT_PROVIDER_SENDDATA_ERROR: {
                            break;
                        }
                        case EVT_PROVIDER_DISCONNECT_FINISHED: {
                            this.notifyListeners(IConstants.EventCode.EVT_TOOL_DISCONNECT_FINISHED, result);
                        }
                    }
                }
                if (notifier != this.processor) break block22;
                switch (event) {
                    case EVT_PROCESSOR_GATHERDATA_FINISHED: {
                        if (ToolStateEnum.RUNNING == this.toolState) {
                            try {
                                this.notifyListeners(IConstants.EventCode.EVT_TOOL_REFRESH_VIEW, result);
                                Thread.sleep(this.delay);
                                this.processor.gatherData();
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                        if (ToolStateEnum.STOP_SCHEDULED == this.toolState) {
                            this.toolState = ToolStateEnum.STOPPED;
                        }
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (IOException iOException) {}
        }
    }

    public int getRefreshDelay() {
        return this.delay;
    }

    public void setRefreshDelay(int delay) {
        this.delay = delay;
    }

    public void start() {
        try {
            if (this.processor != null) {
                if (ToolStateEnum.STOPPED == this.toolState) {
                    this.toolState = ToolStateEnum.RUNNING;
                    this.processor.gatherData();
                } else if (ToolStateEnum.STOP_SCHEDULED == this.toolState) {
                    this.toolState = ToolStateEnum.RUNNING;
                }
            }
        }
        catch (IOException iOException) {}
    }

    public void stop() {
        this.toolState = ToolStateEnum.STOP_SCHEDULED;
    }

    public void refresh() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ToolStateEnum {
        RUNNING,
        STOPPED,
        STOP_SCHEDULED;

    }
}

