/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tml.protocol.lib.IMessageFieldsStore;
import org.eclipse.tml.protocol.lib.ProtocolMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFieldsStore
implements IMessageFieldsStore {
    private static final String INTERNAL_SEPARATOR = "$$";
    protected Map<String, Object> messageFieldsValues = new HashMap<String, Object>();
    protected Map<String, Integer> messageFieldsSizes = new HashMap<String, Integer>();
    private String iteratableBlockId;
    private int index;

    public MessageFieldsStore() {
        this.iteratableBlockId = null;
        this.index = -1;
    }

    public MessageFieldsStore(ProtocolMessage message, String iteratableBlockId, int index) {
        if (message != null) {
            this.iteratableBlockId = iteratableBlockId;
            this.index = index;
            for (String fieldName : message.getAllFieldNames()) {
                this.messageFieldsValues.put(fieldName, message.getFieldValue(fieldName));
            }
        } else {
            this.iteratableBlockId = null;
            this.index = -1;
        }
    }

    @Override
    public Collection<String> getAllFieldNames() {
        return this.messageFieldsValues.keySet();
    }

    @Override
    public Object getFieldValue(String fieldName) {
        Object value = null;
        if (this.iteratableBlockId != null && this.index >= 0) {
            value = this.messageFieldsValues.get(this.generateKey(fieldName, this.iteratableBlockId, this.index));
        }
        if (value == null || this.iteratableBlockId == null || this.index < 0) {
            value = this.messageFieldsValues.get(fieldName);
        }
        return value;
    }

    @Override
    public Object getFieldValue(String fieldName, String iterableBlockId, int index) {
        Object value = null;
        value = iterableBlockId != null && index >= 0 ? this.messageFieldsValues.get(this.generateKey(fieldName, iterableBlockId, index)) : this.messageFieldsValues.get(fieldName);
        return value;
    }

    protected String generateKey(String fieldName, String iterableBlockId, int index) {
        return String.valueOf(iterableBlockId) + INTERNAL_SEPARATOR + fieldName + INTERNAL_SEPARATOR + index;
    }

    protected String getIteratableBlockId() {
        return this.iteratableBlockId;
    }

    protected int getIndex() {
        return this.index;
    }

    @Override
    public Integer getFieldSize(String fieldName) {
        Integer size = null;
        if (this.iteratableBlockId != null && this.index >= 0) {
            size = this.messageFieldsSizes.get(this.generateKey(fieldName, this.iteratableBlockId, this.index));
        }
        if (size == null || this.iteratableBlockId == null || this.index < 0) {
            size = this.messageFieldsSizes.get(fieldName);
        }
        return size;
    }

    @Override
    public Integer getFieldSize(String fieldName, String iterableBlockId, int index) {
        Integer size = null;
        size = iterableBlockId != null && index >= 0 ? this.messageFieldsSizes.get(this.generateKey(fieldName, iterableBlockId, index)) : this.messageFieldsSizes.get(fieldName);
        return size;
    }
}

