/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.application.ApplicationContextImpl;
import org.eclipse.rap.rwt.internal.lifecycle.CurrentPhase;
import org.eclipse.rap.rwt.internal.lifecycle.PhaseId;
import org.eclipse.rap.rwt.internal.lifecycle.RemoteAdapter;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetDataUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.scripting.ClientListenerUtil;
import org.eclipse.rap.rwt.internal.theme.ThemeAdapter;
import org.eclipse.rap.rwt.internal.theme.ThemeManager;
import org.eclipse.rap.rwt.scripting.ClientListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.events.EventList;
import org.eclipse.swt.internal.events.EventUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.internal.widgets.IdGenerator;
import org.eclipse.swt.internal.widgets.ParentHolderRemoteAdapter;
import org.eclipse.swt.internal.widgets.WidgetGraphicsAdapter;
import org.eclipse.swt.internal.widgets.WidgetRemoteAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget
implements Adaptable,
SerializableCompatibility {
    private static final Listener[] EMPTY_LISTENERS = new Listener[0];
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int DISPOSED = 1;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int LAYOUT_NEEDED = 32;
    static final int LAYOUT_CHANGED = 64;
    static final int LAYOUT_CHILD = 128;
    static final int THEME_BACKGROUND = 256;
    static final int PARENT_BACKGROUND = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int SKIN_NEEDED = 0x200000;
    int style;
    private int state;
    Display display;
    private Object data;
    private EventTable eventTable;
    private RemoteAdapter remoteAdapter;
    private IWidgetGraphicsAdapter widgetGraphicsAdapter;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        if (parent == null) {
            SWT.error(4);
        }
        this.style = style;
        this.display = parent.display;
        this.reskinWidget();
        this.remoteAdapter = new ParentHolderRemoteAdapter(parent);
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == RemoteAdapter.class) {
            return (T)this.ensureRemoteAdapter();
        }
        if (adapter == ThemeAdapter.class) {
            ThemeManager themeManager = this.getApplicationContext().getThemeManager();
            return (T)themeManager.getThemeAdapterManager().getThemeAdapter(this);
        }
        if (adapter == IWidgetGraphicsAdapter.class) {
            if (this.widgetGraphicsAdapter == null) {
                this.widgetGraphicsAdapter = new WidgetGraphicsAdapter();
            }
            return (T)this.widgetGraphicsAdapter;
        }
        return null;
    }

    public Object getData() {
        this.checkWidget();
        return this.hasState(4) ? ((Object[])this.data)[0] : this.data;
    }

    public void setData(Object data) {
        this.checkWidget();
        if (this.hasState(4)) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        Object result = null;
        if (this.hasState(4)) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (result == null && i < table.length) {
                if (key.equals(table[i])) {
                    result = table[i + 1];
                }
                i += 2;
            }
        }
        return result;
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if ("org.eclipse.rap.rwt.customVariant".equals(key)) {
            if (value != null) {
                Widget.checkCustomVariant(value);
            }
            WidgetLCAUtil.preserveCustomVariant(this);
        }
        if (WidgetDataUtil.getDataKeys().contains(key)) {
            WidgetLCAUtil.preserveData(this);
        }
        int index = 1;
        Object[] table = null;
        if (this.hasState(4)) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if (this.hasState(4)) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.addState(4);
            }
            table[index] = key;
            table[index + 1] = value;
        } else if (this.hasState(4) && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.removeState(4);
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
        if (key.equals("org.eclipse.swt.skin.class") || key.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    public Display getDisplay() {
        if (this.hasState(1)) {
            this.error(24);
        }
        return this.display;
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.preserveListeners();
        if (this.eventTable != null) {
            this.eventTable.unhook(12, listener);
        }
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.ensureEventTable();
        this.preserveListeners();
        this.eventTable.hook(eventType, listener);
        if (listener instanceof ClientListener) {
            ClientListenerUtil.clientListenerAdded(this, eventType, (ClientListener)listener);
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.preserveListeners();
        if (this.eventTable != null) {
            this.eventTable.unhook(eventType, listener);
        }
        if (listener instanceof ClientListener) {
            ClientListenerUtil.clientListenerRemoved(this, eventType, (ClientListener)listener);
        }
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        Event newEvent = event == null ? new Event() : event;
        newEvent.widget = this;
        newEvent.type = eventType;
        newEvent.display = this.display;
        if (newEvent.time == 0) {
            newEvent.time = EventUtil.getLastEventTime();
        }
        this.sendEvent(newEvent);
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.eventTable == null ? false : this.eventTable.hooks(eventType);
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        return this.eventTable == null ? EMPTY_LISTENERS : this.eventTable.getListeners(eventType);
    }

    protected void removeListener(int eventType, SWTEventListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.preserveListeners();
        if (this.eventTable != null) {
            this.eventTable.unhook(eventType, listener);
        }
    }

    private void sendEvent(Event event) {
        if (Widget.isEventProcessingPhase()) {
            event.display.filterEvent(event);
            if (this.eventTable != null) {
                this.eventTable.sendEvent(event);
            }
        } else {
            EventList.getInstance().add(event);
        }
    }

    private static boolean isEventProcessingPhase() {
        PhaseId currentPhase = CurrentPhase.get();
        return PhaseId.PREPARE_UI_ROOT.equals(currentPhase) || PhaseId.PROCESS_ACTION.equals(currentPhase);
    }

    private void ensureEventTable() {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
    }

    public void reskin(int flags) {
        this.checkWidget();
        this.reskinWidget();
        if ((flags & 1) != 0) {
            this.reskinChildren(flags);
        }
    }

    void reskinChildren(int flags) {
    }

    void reskinWidget() {
        if (!this.hasState(0x200000)) {
            this.addState(0x200000);
            this.display.addSkinnableWidget(this);
        }
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return this.getName() + " {" + string + "}";
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index != -1) {
            string = string.substring(index + 1, string.length());
        }
        return string;
    }

    String getNameText() {
        return "";
    }

    public void dispose() {
        if (!this.isDisposed()) {
            if (!this.isValidThread()) {
                this.error(22);
            }
            if (!this.hasState(4096)) {
                this.addState(4096);
                this.notifyListeners(12, new Event());
            }
            if (!this.hasState(1)) {
                this.releaseChildren();
            }
            if (!this.hasState(2048)) {
                this.addState(2048);
                this.releaseParent();
                this.releaseWidget();
                this.getAdapter(RemoteAdapter.class).markDisposed(this);
            }
        }
    }

    public boolean isDisposed() {
        return this.hasState(1);
    }

    boolean isInDispose() {
        return this.hasState(4096);
    }

    void releaseChildren() {
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.eventTable = null;
        this.addState(1);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    protected void checkWidget() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (this.hasState(1)) {
            this.error(24);
        }
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int result = style;
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((result & mask) == 0) {
            result |= int0;
        }
        if ((result & int0) != 0) {
            result = result & ~mask | int0;
        }
        if ((result & int1) != 0) {
            result = result & ~mask | int1;
        }
        if ((result & int2) != 0) {
            result = result & ~mask | int2;
        }
        if ((result & int3) != 0) {
            result = result & ~mask | int3;
        }
        if ((result & int4) != 0) {
            result = result & ~mask | int4;
        }
        if ((result & int5) != 0) {
            result = result & ~mask | int5;
        }
        return result;
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean hasState(int flag) {
        return (this.state & flag) != 0;
    }

    void addState(int flag) {
        this.state |= flag;
    }

    void removeState(int flag) {
        this.state &= ~flag;
    }

    private void preserveListeners() {
        WidgetRemoteAdapter adapter = (WidgetRemoteAdapter)this.ensureRemoteAdapter();
        if (!adapter.hasPreservedListeners()) {
            WidgetLCAUtil.preserveListeners(this, this.eventTable != null ? this.eventTable.getEventList() : 0L);
        }
    }

    private RemoteAdapter ensureRemoteAdapter() {
        if (this.remoteAdapter == null) {
            this.remoteAdapter = this.createRemoteAdapter(null);
        } else if (this.remoteAdapter instanceof ParentHolderRemoteAdapter) {
            this.remoteAdapter = this.createRemoteAdapter(this.remoteAdapter.getParent());
        }
        return this.remoteAdapter;
    }

    private RemoteAdapter createRemoteAdapter(Widget parent) {
        String id = IdGenerator.getInstance(RWT.getUISession(this.display)).createId(this);
        return this.createRemoteAdapter(parent, id);
    }

    RemoteAdapter createRemoteAdapter(Widget parent, String id) {
        WidgetRemoteAdapter remoteAdapter = new WidgetRemoteAdapter(id);
        remoteAdapter.setParent(parent);
        return remoteAdapter;
    }

    private ApplicationContextImpl getApplicationContext() {
        IDisplayAdapter displayAdapter = this.display.getAdapter(IDisplayAdapter.class);
        return (ApplicationContextImpl)displayAdapter.getUISession().getApplicationContext();
    }

    private static void checkCustomVariant(Object value) {
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Custom variant is not a string");
        }
        if (!Widget.validateVariantString((String)value)) {
            throw new IllegalArgumentException("Invalid custom variant: " + String.valueOf(value));
        }
    }

    private static boolean validateVariantString(String variant) {
        int start = 0;
        int length = variant.length();
        if (variant.startsWith("-")) {
            ++start;
        }
        if (length == 0) {
            return false;
        }
        if (!Widget.isValidStart(variant.charAt(start))) {
            return false;
        }
        int i = start + 1;
        while (i < length) {
            if (!Widget.isValidPart(variant.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isValidStart(char ch) {
        return ch == '_' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '\u0080' && ch <= '\u00ff';
    }

    private static boolean isValidPart(char ch) {
        return Widget.isValidStart(ch) || ch >= '0' && ch <= '9' || ch == '-';
    }
}

