/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.Activator;
import org.eclipse.equinox.http.servlet.internal.HttpServiceRuntimeImpl;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestWrapperImpl;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 4117456123807468871L;
    private HttpServiceRuntimeImpl httpServiceRuntimeImpl;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Activator.addProxyServlet(this);
    }

    public void destroy() {
        Activator.unregisterHttpService(this);
        super.destroy();
    }

    public void setHttpServiceRuntimeImpl(HttpServiceRuntimeImpl httpServiceRuntimeImpl) {
        this.httpServiceRuntimeImpl = httpServiceRuntimeImpl;
    }

    public void sessionIdChanged(String oldSessionId) {
        this.httpServiceRuntimeImpl.fireSessionIdChanged(oldSessionId);
    }

    private String getNotDecodedAlias(HttpServletRequest request) {
        String[] requestUriSegments;
        String pathInfo = HttpServletRequestWrapperImpl.getDispatchPathInfo(request);
        if (pathInfo == null) {
            return null;
        }
        String requestUri = HttpServletRequestWrapperImpl.getDispatchRequestURI(request);
        String[] pathInfoSegments = pathInfo.split("/");
        if (pathInfoSegments.length == (requestUriSegments = requestUri.split("/")).length) {
            return requestUri;
        }
        StringBuilder aliasBuilder = new StringBuilder();
        int i = requestUriSegments.length - pathInfoSegments.length + 1;
        while (i < requestUriSegments.length) {
            aliasBuilder.append("/").append(requestUriSegments[i]);
            ++i;
        }
        return aliasBuilder.toString();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DispatchTargets dispatchTargets;
        this.checkRuntime();
        String alias = this.getNotDecodedAlias(request);
        if (alias == null) {
            alias = "/";
        }
        if ((dispatchTargets = this.httpServiceRuntimeImpl.getDispatchTargets(alias, null)) != null) {
            dispatchTargets.doDispatch(request, response, alias, request.getDispatcherType());
            return;
        }
        response.sendError(404, "ProxyServlet: " + alias);
    }

    private void checkRuntime() {
        if (this.httpServiceRuntimeImpl == null) {
            throw new IllegalStateException("Proxy servlet not properly initialized. httpServiceRuntimeImpl is null");
        }
    }
}

