/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.Hashtable;
import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.ui.forms.internal.widgets.IBulletParagraphAdapter;
import org.eclipse.ui.internal.forms.widgets.IHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.Locator;
import org.eclipse.ui.internal.forms.widgets.Paragraph;

public class BulletParagraph
extends Paragraph
implements Adaptable {
    public static final int CIRCLE = 1;
    public static final int TEXT = 2;
    public static final int IMAGE = 3;
    private int style = 1;
    private String text;
    private int CIRCLE_DIAM = 5;
    private int SPACING = 10;
    private int indent = -1;
    private int bindent = -1;
    private Rectangle bbounds;
    private IBulletParagraphAdapter bulletParagraphAdapter;

    public BulletParagraph(boolean addVerticalSpace) {
        super(addVerticalSpace);
    }

    @Override
    public int getIndent() {
        int ivalue = this.indent;
        if (ivalue != -1) {
            return ivalue;
        }
        switch (this.style) {
            case 1: {
                ivalue = this.CIRCLE_DIAM + this.SPACING;
                break;
            }
            default: {
                ivalue = 20;
            }
        }
        return this.getBulletIndent() + ivalue;
    }

    public int getBulletIndent() {
        if (this.bindent != -1) {
            return this.bindent;
        }
        return 0;
    }

    public int getBulletStyle() {
        return this.style;
    }

    public void setBulletStyle(int style) {
        this.style = style;
    }

    public void setBulletText(String text) {
        this.text = text;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public void setBulletIndent(int bindent) {
        this.bindent = bindent;
    }

    public String getBulletText() {
        return this.text;
    }

    @Override
    public void layout(GC gc, int width, Locator loc, int lineHeight, Hashtable resourceTable, IHyperlinkSegment selectedLink) {
        this.computeRowHeights(gc, width, loc, lineHeight, resourceTable);
        this.layoutBullet(gc, loc, lineHeight, resourceTable);
        super.layout(gc, width, loc, lineHeight, resourceTable, selectedLink);
    }

    private void layoutBullet(GC gc, Locator loc, int lineHeight, Hashtable resourceTable) {
        Image image;
        int x = loc.x - this.getIndent() + this.getBulletIndent();
        int rowHeight = ((int[])loc.heights.get(0))[0];
        if (this.style == 1) {
            int y = loc.y + rowHeight / 2 - this.CIRCLE_DIAM / 2;
            this.bbounds = new Rectangle(x, y, this.CIRCLE_DIAM, this.CIRCLE_DIAM);
        } else if (this.style == 2 && this.text != null) {
            Point textSize = gc.textExtent(this.text);
            this.bbounds = new Rectangle(x, loc.y, textSize.x, textSize.y);
        } else if (this.style == 3 && this.text != null && (image = (Image)resourceTable.get(this.text)) != null) {
            Rectangle ibounds = image.getBounds();
            int y = loc.y + rowHeight / 2 - ibounds.height / 2;
            this.bbounds = new Rectangle(x, y, ibounds.width, ibounds.height);
        }
    }

    public Object getAdapter(Class adapter) {
        IBulletParagraphAdapter result = null;
        if (adapter == IBulletParagraphAdapter.class) {
            if (this.bulletParagraphAdapter == null) {
                this.bulletParagraphAdapter = new IBulletParagraphAdapter(){

                    @Override
                    public Rectangle getBulletBounds() {
                        return BulletParagraph.this.bbounds;
                    }
                };
            }
            result = this.bulletParagraphAdapter;
        }
        return result;
    }
}

