/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.api.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.api.ChannelInformation;
import org.eclipse.packagedrone.repo.api.ChannelListResult;
import org.eclipse.packagedrone.repo.api.Channels;
import org.eclipse.packagedrone.repo.api.CreateChannel;
import org.eclipse.packagedrone.repo.channel.AspectableChannel;
import org.eclipse.packagedrone.repo.channel.ChannelDetails;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.DescriptorAdapter;

public class ChannelsImpl
implements Channels {
    private ChannelService channelService;

    public void setChannelService(ChannelService channelService) {
        this.channelService = channelService;
    }

    public ChannelListResult list() {
        ChannelListResult result = new ChannelListResult();
        result.setChannels(this.channelService.list().stream().map(ChannelsImpl::toInfo).collect(Collectors.toList()));
        return result;
    }

    public ChannelInformation createChannel(CreateChannel createChannel) {
        Objects.requireNonNull(createChannel, "Missing channel information");
        ChannelDetails details = new ChannelDetails();
        details.setDescription(createChannel.getDescription());
        HashMap configuration = new HashMap();
        ChannelId id = this.channelService.create(null, details, configuration);
        if (id == null) {
            return null;
        }
        try {
            if (createChannel.getNames() != null && !createChannel.getNames().isEmpty()) {
                this.channelService.accessRun(ChannelService.By.id((String)id.getId()), DescriptorAdapter.class, channel -> channel.setNames((Collection)createChannel.getNames()));
            }
            if (createChannel.getAspects() != null && !createChannel.getAspects().isEmpty()) {
                this.channelService.accessRun(ChannelService.By.id((String)id.getId()), AspectableChannel.class, channel -> channel.addAspects(createChannel.isAspectsWithDependencies(), createChannel.getAspects()));
            }
        }
        catch (Exception e) {
            this.channelService.delete(ChannelService.By.id((String)id.getId()));
            throw e;
        }
        return ChannelsImpl.toInfo(this.channelService.getState(ChannelService.By.id((String)id.getId())).orElse(null));
    }

    private static ChannelInformation toInfo(org.eclipse.packagedrone.repo.channel.ChannelInformation channel) {
        if (channel == null) {
            return null;
        }
        ChannelInformation result = new ChannelInformation();
        result.setId(channel.getId());
        if (channel.getDescription() != null && !channel.getDescription().isEmpty()) {
            result.setDescription(channel.getDescription());
        }
        if (channel.getShortDescription() != null && !channel.getShortDescription().isEmpty()) {
            result.setShortDescription(channel.getShortDescription());
        }
        result.setNames(channel.getNames());
        result.setAspects(channel.getAspectStates().keySet());
        return result;
    }
}

