/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.web.channel;

import org.eclipse.packagedrone.job.JobHandle;
import org.eclipse.packagedrone.job.JobManager;
import org.eclipse.packagedrone.repo.importer.Importer;
import org.eclipse.packagedrone.repo.importer.job.ImporterJobConfiguration;
import org.eclipse.packagedrone.repo.importer.web.ImportDescriptor;
import org.eclipse.packagedrone.repo.importer.web.ImportRequest;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class ImportManager {
    private final ServiceTracker<Importer, Importer> tracker;
    private final JobManager jobManager;

    public ImportManager(BundleContext context, JobManager jobManager) {
        this.tracker = new ServiceTracker(context, Importer.class, null);
        this.tracker.open();
        this.jobManager = jobManager;
    }

    public Importer getImporter(String id) {
        for (Importer imp : this.tracker.getTracked().values()) {
            if (!id.equals(imp.getDescription().getId())) continue;
            return imp;
        }
        return null;
    }

    public void dispose() {
        this.tracker.close();
    }

    public JobHandle perform(ImportDescriptor descriptor, ImportRequest request) {
        String importerId = request.getImporterId();
        Importer imp = this.getImporter(importerId);
        if (imp == null) {
            throw new IllegalArgumentException(String.format("Importer '%s' could not be found'", importerId));
        }
        ImporterJobConfiguration cfg = new ImporterJobConfiguration(descriptor, request.getImporterId(), request.getConfiguration());
        return this.jobManager.startJob("package.drone.importer", (Object)cfg);
    }
}

