/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.packagedrone.repo.channel.search.CompositePredicate;
import org.eclipse.packagedrone.repo.channel.search.Predicate;

abstract class AbstractCompositePredicate
implements CompositePredicate {
    private final List<Predicate> predicates;

    AbstractCompositePredicate(Collection<Predicate> predicates) {
        Objects.requireNonNull(predicates);
        this.predicates = Collections.unmodifiableList(new ArrayList<Predicate>(predicates));
    }

    AbstractCompositePredicate(Predicate ... predicates) {
        Objects.requireNonNull(predicates);
        this.predicates = Collections.unmodifiableList(new ArrayList<Predicate>(Arrays.asList(predicates)));
    }

    @Override
    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.predicates == null ? 0 : this.predicates.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCompositePredicate other = (AbstractCompositePredicate)obj;
        return !(this.predicates == null ? other.predicates != null : !this.predicates.equals(other.predicates));
    }
}

