/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.setup.web;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.repo.manage.todo.BasicTask;
import org.eclipse.packagedrone.repo.manage.todo.Task;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.ViewResolver;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@RequestMapping(value={"/setup"})
public class SetupController {
    private StorageManager manager;

    public void setService(StorageManager manager) {
        this.manager = manager;
    }

    public void unsetService(StorageManager manager) {
        this.manager = null;
    }

    private List<Task> getTasks(HttpServletRequest request) {
        boolean mailPresent;
        LinkedList<Task> result = new LinkedList<Task>();
        int idx = 1;
        boolean loggedIn = request.getUserPrincipal() != null;
        BasicTask task = new BasicTask("Sign in as admin user", idx++, "Sign in with the default admin user. Unless you changed the setup the default name is <code>admin</code> and the password/token is printed out on the console of the server application. <br/><br/> Alternatively the token is written to the file <code>${user.home}/.drone-admin-token</code>.", new LinkTarget("/login"));
        if (loggedIn) {
            task.setState(Task.State.DONE);
        }
        result.add((Task)task);
        task = new BasicTask("Configure the storage location", idx++, "Head over to the <q>Storage configuration</q> section and selection the location where Package Drone should store data.", loggedIn ? new LinkTarget("/config") : null);
        if (this.manager != null) {
            task.setState(Task.State.DONE);
        }
        result.add((Task)task);
        task = new BasicTask("Configure the mail service", idx++, "You will need to configure a mail server which Package Drone can use to sent e-mails.", loggedIn ? new LinkTarget("/default.mail/config") : null);
        BundleContext ctx = FrameworkUtil.getBundle(SetupController.class).getBundleContext();
        boolean bl = mailPresent = ctx.getServiceReference("org.eclipse.packagedrone.mail.MailService") != null;
        if (mailPresent) {
            task.setState(Task.State.DONE);
        }
        result.add((Task)task);
        return result;
    }

    @RequestMapping
    public ModelAndView index(HttpServletRequest request) {
        HashMap<String, List<Task>> model = new HashMap<String, List<Task>>();
        model.put("tasks", this.getTasks(request));
        return new ModelAndView("setup/index", model);
    }
}

