/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.job.apm;

import java.util.Collections;
import java.util.Map;
import org.eclipse.packagedrone.job.ErrorInformation;
import org.eclipse.packagedrone.job.JobHandle;
import org.eclipse.packagedrone.job.JobRequest;
import org.eclipse.packagedrone.job.State;
import org.eclipse.packagedrone.job.apm.model.JobInstanceEntity;

public class JobHandleImpl
implements JobHandle {
    private final String id;
    private final State state;
    private final ErrorInformation errorInformation;
    private final JobRequest request;
    private final String label;
    private final String result;
    private final String currentWorkLabel;
    private final Double percentComplete;
    private final Map<String, String> properties;

    public JobHandleImpl(JobInstanceEntity ji) {
        this.id = ji.getId();
        this.state = ji.getState();
        this.errorInformation = ji.getErrorInformation();
        this.currentWorkLabel = ji.getCurrentWorkLabel();
        this.percentComplete = ji.getPercentComplete();
        this.request = new JobRequest();
        this.request.setFactoryId(ji.getFactoryId());
        this.request.setData(ji.getData());
        this.label = ji.getLabel();
        this.result = ji.getResult();
        this.properties = Collections.unmodifiableMap(ji.getProperties());
    }

    public String getResult() {
        return this.result;
    }

    public String getId() {
        return this.id;
    }

    public State getState() {
        return this.state;
    }

    public ErrorInformation getError() {
        return this.errorInformation;
    }

    public JobRequest getRequest() {
        return this.request;
    }

    public String getLabel() {
        return this.label;
    }

    public String getCurrentWorkLabel() {
        return this.currentWorkLabel;
    }

    public double getPercentComplete() {
        return this.percentComplete == null ? 0.0 : this.percentComplete;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isComplete() {
        return this.getState() == State.COMPLETE;
    }
}

