/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.deb.aspect.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.packagedrone.repo.adapter.deb.aspect.internal.ControlInformation;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;
import org.eclipse.packagedrone.utils.deb.Packages;

public class DebianExtractor
implements Extractor {
    private final GsonBuilder builder = new GsonBuilder();

    public void extractMetaData(Extractor.Context context, Map<String, String> metadata) throws Exception {
        TreeMap<String, String> controlFile;
        try {
            Map result = Packages.parseControlFile((File)context.getPath().toFile());
            controlFile = result != null ? new TreeMap<String, String>(result) : null;
        }
        catch (Exception exception) {
            return;
        }
        if (controlFile == null) {
            return;
        }
        metadata.put("package", (String)controlFile.get("Package"));
        metadata.put("version", (String)controlFile.get("Version"));
        metadata.put("maintainer", (String)controlFile.get("Maintainer"));
        metadata.put("description", (String)controlFile.get("Description"));
        metadata.put("shortDescription", this.makeShort((String)controlFile.get("Description")));
        metadata.put("architecture", (String)controlFile.get("Architecture"));
        metadata.put("section", (String)controlFile.get("Section"));
        metadata.put("artifactLabel", "Debian Package");
        Gson gson = this.builder.create();
        metadata.put("control.json", gson.toJson((Object)new ControlInformation(controlFile)));
    }

    private String makeShort(String string) {
        if (string == null) {
            return null;
        }
        String[] toks = string.split("\n", 2);
        if (toks.length > 0) {
            return toks[0];
        }
        return null;
    }
}

