/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.packagedrone.repo.channel.deploy.DeployGroup;
import org.eclipse.packagedrone.repo.channel.deploy.DeployKey;

public class DeployGroupTypeAdapter
implements JsonSerializer<DeployGroup>,
JsonDeserializer<DeployGroup> {
    public DeployGroup deserialize(JsonElement ele, Type type, JsonDeserializationContext ctx) throws JsonParseException {
        JsonObject obj = ele.getAsJsonObject();
        return new DeployGroup(obj.get("id").getAsString(), obj.get("name").getAsString(), null, group -> this.makeKeys((DeployGroup)group, obj, ctx));
    }

    private List<DeployKey> makeKeys(DeployGroup group, JsonObject obj, JsonDeserializationContext ctx) {
        JsonElement keysEle = obj.get("keys");
        if (keysEle == null) {
            return Collections.emptyList();
        }
        JsonObject keys = keysEle.getAsJsonObject();
        LinkedList<DeployKey> result = new LinkedList<DeployKey>();
        for (Map.Entry entry : keys.entrySet()) {
            JsonObject o2 = ((JsonElement)entry.getValue()).getAsJsonObject();
            result.add(new DeployKey(group, (String)entry.getKey(), o2.get("name").getAsString(), o2.get("key").getAsString(), DeployGroupTypeAdapter.getAsTimestamp(ctx, o2)));
        }
        return result;
    }

    private static Instant getAsTimestamp(JsonDeserializationContext ctx, JsonObject o2) {
        Object result = ctx.deserialize(o2.get("timestamp"), Date.class);
        if (result == null) {
            return null;
        }
        return ((Date)result).toInstant();
    }

    public JsonElement serialize(DeployGroup group, Type type, JsonSerializationContext ctx) {
        JsonObject obj = new JsonObject();
        obj.addProperty("id", group.getId());
        obj.addProperty("name", group.getName());
        JsonObject keys = new JsonObject();
        obj.add("keys", (JsonElement)keys);
        for (DeployKey key : group.getKeys()) {
            JsonObject ok = new JsonObject();
            ok.addProperty("name", key.getName());
            ok.addProperty("key", key.getKey());
            ok.add("timestamp", ctx.serialize((Object)Date.from(key.getCreationTimestamp()), Date.class));
            keys.add(key.getId(), (JsonElement)ok);
        }
        return obj;
    }
}

