/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.binding;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.packagedrone.utils.converter.ConvertBy;
import org.eclipse.packagedrone.utils.converter.ConverterManager;
import org.eclipse.packagedrone.web.controller.binding.BindTarget;
import org.eclipse.packagedrone.web.controller.binding.Binder;
import org.eclipse.packagedrone.web.controller.binding.Binding;
import org.eclipse.packagedrone.web.controller.binding.BindingManager;

public class MapBinder
implements Binder {
    private final Map<String, Object> objects;

    public MapBinder(Map<String, Object> objects) {
        this.objects = objects;
    }

    public MapBinder() {
        this.objects = new HashMap<String, Object>();
    }

    protected Map<String, Object> getObjects() {
        return this.objects;
    }

    @Override
    public Binding performBind(BindTarget target, ConverterManager converter, BindingManager bindingManager) {
        Class<?> type = target.getType();
        String q = target.getQualifier();
        if (q != null) {
            Object value = this.objects.get(q);
            if (value != null) {
                try {
                    Object cvtValue = converter.convertToBy(value, type, () -> target.getAnnotationsByType(ConvertBy.class));
                    return Binding.simpleBinding(cvtValue);
                }
                catch (Exception e) {
                    return Binding.errorBinding(e);
                }
            }
        } else {
            for (Map.Entry<String, Object> entry : this.objects.entrySet()) {
                Object o = entry.getValue();
                if (o == null || !type.isAssignableFrom(o.getClass())) continue;
                return Binding.simpleBinding(o);
            }
        }
        return null;
    }
}

