/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.generator.p2;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.aspect.common.osgi.OsgiExtractor;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelArtifactInformation;
import org.eclipse.packagedrone.repo.channel.search.Predicates;
import org.eclipse.packagedrone.repo.generator.ArtifactGenerator;
import org.eclipse.packagedrone.repo.generator.GenerationContext;
import org.eclipse.packagedrone.repo.generator.p2.GeneratorController;
import org.eclipse.packagedrone.repo.generator.p2.Helper;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.eclipse.packagedrone.web.LinkTarget;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FeatureGenerator
implements ArtifactGenerator {
    private static final String QUALIFIER_SUFFIX = ".qualifier";
    private static final DateFormat QUALIFIER_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    public static final String ID = "p2.feature";
    private final XmlHelper xml = new XmlHelper();

    static {
        QUALIFIER_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public LinkTarget getAddTarget() {
        return LinkTarget.createFromController(GeneratorController.class, (String)"createFeature");
    }

    public LinkTarget getEditTarget(ChannelArtifactInformation artifact) {
        HashMap<String, String> model = new HashMap<String, String>(2);
        model.put("channelId", artifact.getChannelId().getId());
        model.put("artifactId", artifact.getId());
        String url = LinkTarget.createFromController(GeneratorController.class, (String)"editFeature").render(model);
        return new LinkTarget(url);
    }

    public void generate(GenerationContext context) throws Exception {
        String id = MetaKeys.getString((Map)context.getArtifactInformation().getMetaData(), (String)ID, (String)"id");
        String version = MetaKeys.getString((Map)context.getArtifactInformation().getMetaData(), (String)ID, (String)"version");
        context.createVirtualArtifact(String.format("%s-%s.jar", id, version), out -> {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ZipOutputStream jar = new ZipOutputStream((OutputStream)out);){
                ZipEntry ze = new ZipEntry("feature.xml");
                jar.putNextEntry(ze);
                this.createFeatureXml(jar, context.getArtifactInformation().getMetaData(), context);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, null);
    }

    private void createFeatureXml(OutputStream out, Map<MetaKey, String> map, GenerationContext context) throws IOException {
        String id = MetaKeys.getString(map, (String)ID, (String)"id");
        String version = this.makeVersion(MetaKeys.getString(map, (String)ID, (String)"version"));
        String label = MetaKeys.getString(map, (String)ID, (String)"label");
        String description = MetaKeys.getString(map, (String)ID, (String)"description");
        String copyright = MetaKeys.getString(map, (String)ID, (String)"copyright");
        String license = MetaKeys.getString(map, (String)ID, (String)"license");
        String descriptionUrl = MetaKeys.getString(map, (String)ID, (String)"descriptionUrl");
        String copyrightUrl = MetaKeys.getString(map, (String)ID, (String)"copyrightUrl");
        String licenseUrl = MetaKeys.getString(map, (String)ID, (String)"licenseUrl");
        String provider = MetaKeys.getString(map, (String)ID, (String)"provider");
        String bsnPattern = MetaKeys.getString(map, (String)ID, (String)"artifactFilter");
        Document doc = this.xml.create();
        Element root = doc.createElement("feature");
        doc.appendChild(root);
        root.setAttribute("id", id);
        root.setAttribute("version", version);
        root.setAttribute("label", label);
        if (provider != null) {
            root.setAttribute("provider-name", provider);
        }
        this.createLegalEntry(root, "description", description, descriptionUrl);
        this.createLegalEntry(root, "copyright", copyright, copyrightUrl);
        this.createLegalEntry(root, "license", license, licenseUrl);
        if (bsnPattern == null || bsnPattern.isEmpty()) {
            for (ArtifactInformation a : context.getChannelArtifacts()) {
                this.processPlugin(root, a);
            }
        } else {
            for (ArtifactInformation a : context.getArtifactLocator().search(Predicates.like((MetaKey)OsgiExtractor.KEY_NAME, (String)bsnPattern))) {
                this.processPlugin(root, a);
            }
        }
        try {
            this.xml.write((Node)doc, out);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public void createLegalEntry(Element root, String type, String text, String url) {
        if (text == null && url == null) {
            return;
        }
        if (text != null && text.isEmpty() && url != null && url.isEmpty()) {
            return;
        }
        Element ele = XmlHelper.addElement((Element)root, (String)type);
        if (text != null) {
            ele.setTextContent(text);
        } else {
            ele.setTextContent("");
        }
        if (url != null && !url.isEmpty()) {
            ele.setAttribute("url", url);
        }
    }

    private String makeVersion(String version) {
        if (version == null) {
            return "0.0.0";
        }
        if (!version.endsWith(QUALIFIER_SUFFIX)) {
            return version;
        }
        version = version.substring(0, version.length() - QUALIFIER_SUFFIX.length());
        return String.valueOf(version) + "." + this.makeTimestamp(System.currentTimeMillis());
    }

    private String makeTimestamp(long time) {
        return QUALIFIER_DATE_FORMAT.format(new Date(time));
    }

    private void processPlugin(Element root, ArtifactInformation a) {
        if (!Helper.isBundle(a.getMetaData())) {
            return;
        }
        String id = (String)a.getMetaData().get(OsgiExtractor.KEY_NAME);
        String version = (String)a.getMetaData().get(OsgiExtractor.KEY_VERSION);
        if (id == null || version == null) {
            return;
        }
        boolean unpack = false;
        try {
            String biString = (String)a.getMetaData().get(OsgiExtractor.KEY_BUNDLE_INFORMATION);
            BundleInformation bi = BundleInformation.fromJson((String)biString);
            unpack = "dir".equals(bi.getEclipseBundleShape());
        }
        catch (Exception exception) {}
        Element p = root.getOwnerDocument().createElement("plugin");
        root.appendChild(p);
        p.setAttribute("id", id);
        p.setAttribute("version", version);
        p.setAttribute("unpack", Boolean.toString(unpack));
    }

    public boolean shouldRegenerate(Object event) {
        return Helper.shouldRegenerateFeature(event);
    }
}

