/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils;

import java.io.Closeable;
import java.util.LinkedList;
import java.util.function.BiFunction;
import java.util.function.Function;

public class Suppressed<T extends Exception>
implements AutoCloseable {
    private final Function<Throwable, T> rootCreator;
    private final LinkedList<Throwable> errors = new LinkedList();

    public Suppressed(Function<Throwable, T> rootCreator) {
        this.rootCreator = rootCreator;
    }

    public Suppressed(String message, BiFunction<String, Throwable, T> rootCreator) {
        this.rootCreator = e -> (Exception)rootCreator.apply(message, (Throwable)e);
    }

    public void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            this.errors.add(e);
        }
    }

    public void run(VoidOperation op) {
        try {
            op.run();
        }
        catch (Throwable e) {
            this.errors.add(e);
        }
    }

    private void complete() throws T {
        if (this.errors.isEmpty()) {
            return;
        }
        Throwable e = this.errors.pollFirst();
        Exception root = (Exception)this.rootCreator.apply(e);
        for (Throwable sup : this.errors) {
            root.addSuppressed(sup);
        }
        this.errors.clear();
        throw root;
    }

    @Override
    public void close() throws T {
        this.complete();
    }

    @FunctionalInterface
    public static interface VoidOperation {
        public void run() throws Throwable;
    }
}

