/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.utils;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelCacheHandler {
    private static final Logger logger = LoggerFactory.getLogger(ChannelCacheHandler.class);
    private final MetaKey key;

    public ChannelCacheHandler(MetaKey key) {
        this.key = key;
    }

    public void process(ReadableChannel channel, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!channel.streamCacheEntry(this.key, cacheEntry -> {
            response.setContentType(cacheEntry.getMimeType());
            response.setContentLengthLong(cacheEntry.getSize());
            response.setDateHeader("Last-Modified", cacheEntry.getTimestamp().toEpochMilli());
            long len = ByteStreams.copy((InputStream)cacheEntry.getStream(), (OutputStream)response.getOutputStream());
            logger.trace("Transfered {} bytes of data from cache entry: {}", (Object)len, (Object)this.key);
        })) {
            logger.warn("Unable to find channel cache entry: {}", (Object)this.key);
            response.setStatus(404);
            response.setContentType("text/plain");
            response.getWriter().format("Unable to find: %s", request.getRequestURI());
        }
    }
}

