/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.cleanup.web;

import com.google.common.html.HtmlEscapers;
import com.google.common.net.UrlEscapers;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.aspect.cleanup.CleanupConfiguration;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.web.breadcrumbs.Breadcrumbs;
import org.eclipse.packagedrone.repo.cleanup.Aggregator;
import org.eclipse.packagedrone.repo.cleanup.Field;
import org.eclipse.packagedrone.repo.cleanup.Sorter;
import org.eclipse.packagedrone.repo.cleanup.web.TestConfigurationController;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;
import org.eclipse.packagedrone.web.controller.form.FormData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
@RequestMapping(value={"/aspect/cleanup/{channelId}/config"})
@ViewResolver(value="/WEB-INF/views/config/%s.jsp")
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class ConfigController
implements InterfaceExtender {
    private static final Logger logger = LoggerFactory.getLogger(ConfigController.class);
    private ChannelService service;

    public void setService(ChannelService service) {
        this.service = service;
    }

    public List<MenuEntry> getViews(HttpServletRequest request, Object object) {
        ChannelInformation channel;
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        if (object instanceof ChannelInformation && (channel = (ChannelInformation)object).hasAspect("cleanup") && request.isUserInRole("MANAGER")) {
            HashMap<String, String> model = new HashMap<String, String>();
            model.put("channelId", channel.getId());
            result.add(new MenuEntry("Cleanup", 7000, LinkTarget.createFromController(ConfigController.class, (String)"edit").expand(model), null, null));
        }
        return result;
    }

    @RequestMapping(value={"/edit"})
    public ModelAndView edit(@PathVariable(value="channelId") String channelId, @RequestParameter(value="configuration", required=false) String configString) {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            CleanupConfiguration cfg;
            HashMap<String, Object> model = new HashMap<String, Object>(2);
            model.put("channel", channel.getInformation());
            try {
                cfg = configString != null && !configString.isEmpty() ? (CleanupConfiguration)new GsonBuilder().create().fromJson(configString, CleanupConfiguration.class) : (CleanupConfiguration)MetaKeys.bind((Object)this.makeDefaultConfiguration(), (Map)channel.getMetaData());
            }
            catch (Exception e) {
                logger.info("Failed to parse cleanup config", (Throwable)e);
                cfg = this.makeDefaultConfiguration();
            }
            model.put("command", cfg);
            this.fillModel(model, channelId);
            return new ModelAndView("edit", model);
        });
    }

    protected CleanupConfiguration makeDefaultConfiguration() {
        CleanupConfiguration cfg = new CleanupConfiguration();
        cfg.setNumberOfVersions(3);
        cfg.setOnlyRootArtifacts(true);
        Aggregator aggregator = new Aggregator();
        aggregator.getFields().add(new MetaKey("mvn", "groupId"));
        aggregator.getFields().add(new MetaKey("mvn", "artifactId"));
        aggregator.getFields().add(new MetaKey("mvn", "version"));
        aggregator.getFields().add(new MetaKey("mvn", "classifier"));
        aggregator.getFields().add(new MetaKey("mvn", "extension"));
        cfg.setAggregator(aggregator);
        Sorter sorter = new Sorter();
        sorter.getFields().add(new Field("mvn", "snapshotVersion"));
        cfg.setSorter(sorter);
        return cfg;
    }

    @RequestMapping(value={"/edit"}, method={RequestMethod.POST})
    public ModelAndView editPost(@PathVariable(value="channelId") String channelId, @Valid @FormData(value="command") CleanupConfiguration cfg, BindingResult result) {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ModifiableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>(2);
            model.put("command", cfg);
            model.put("channel", channel.getInformation());
            this.fillModel(model, channelId);
            try {
                if (!result.hasErrors()) {
                    channel.applyMetaData(MetaKeys.unbind((Object)cfg));
                }
            }
            catch (Exception e) {
                return CommonController.createError((String)"Update configuration", (String)"Failed to update cleanup configuration", (Throwable)e);
            }
            return new ModelAndView("edit", model);
        });
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.POST})
    public ModelAndView testPost(@PathVariable(value="channelId") String channelId, @Valid @FormData(value="command") CleanupConfiguration cfg, BindingResult result) {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            if (!result.hasErrors()) {
                return TestConfigurationController.performTestCustomized((ReadableChannel)channel, arg_0 -> ((CleanupConfiguration)cfg).applyTo(arg_0), out -> ConfigController.customize(out, cfg));
            }
            return CommonController.createError((String)"Error", (String)"Testing cleanup", (String)"The configuration has errors");
        });
    }

    private static void customize(JspWriter out, CleanupConfiguration cfg) throws IOException {
        String json = HtmlEscapers.htmlEscaper().escape(new GsonBuilder().create().toJson((Object)cfg));
        out.print("<div class=\"container-fluid\">");
        out.print("<div class=\"row\"><div class=\"col-md-12\">");
        out.print("<form action=\"edit\" method=\"get\">");
        out.print("<input type=\"hidden\" name=\"configuration\" value=\"" + json + "\"/>");
        out.print("<button class=\"btn btn-primary\" type=\"submit\">Edit</button>");
        out.println("</form></div></div></div>");
    }

    private void fillModel(Map<String, Object> model, String channelId) {
        LinkedList<Breadcrumbs.Entry> entries = new LinkedList<Breadcrumbs.Entry>();
        entries.add(new Breadcrumbs.Entry("Home", "/"));
        entries.add(new Breadcrumbs.Entry("Channel", "/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(channelId) + "/view"));
        entries.add(new Breadcrumbs.Entry("Cleanup"));
        model.put("breadcrumbs", new Breadcrumbs(entries));
    }
}

