/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.internal.servlet;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.packagedrone.repo.adapter.p2.aspect.P2RepoConstants;
import org.eclipse.packagedrone.repo.adapter.p2.internal.servlet.MavenLocator;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;

public final class BinaryLocator {
    private BinaryLocator() {
    }

    private static List<ArtifactInformation> filterByMaven(ReadableChannel channel, String id, String version) {
        Collection arts = channel.getArtifacts();
        Stream<Object> matchingArts = BinaryLocator.findByKeys(arts, "binary", id, version);
        matchingArts = matchingArts.flatMap(art -> {
            String parentId = art.getParentId();
            Collection candidates = parentId != null ? (Collection)channel.getChildrenOf(parentId).orElse(Collections.emptyList()) : arts;
            if (candidates == null) {
                return Stream.empty();
            }
            String groupId = MavenLocator.getGroupId(art);
            String artifactId = MavenLocator.getArtifactId(art);
            String mavenVersion = MavenLocator.getVersion(art);
            String snapshotVersion = MavenLocator.getSnapshotVersion(art);
            String extension = MavenLocator.getExtension(art);
            String classifier = MavenLocator.getClassifier(art);
            return MavenLocator.filterByCoordinates(candidates.stream(), groupId, artifactId, mavenVersion, snapshotVersion, extension, classifier);
        });
        return matchingArts.collect(Collectors.toList());
    }

    public static Optional<ArtifactInformation> findByMaven(ReadableChannel channel, String id, String version) {
        List<ArtifactInformation> result = BinaryLocator.filterByMaven(channel, id, version);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        Collections.sort(result, Comparator.comparing(ArtifactInformation::getCreationInstant));
        return Optional.ofNullable(result.get(0));
    }

    private static Stream<ArtifactInformation> findByKeys(Collection<ArtifactInformation> artifacts, String classifier, String id, String version) {
        String key = String.format("%s::%s::%s", classifier, id, version);
        return artifacts.stream().filter(art -> BinaryLocator.hasKey(art, key));
    }

    private static boolean hasKey(ArtifactInformation art, String key) {
        String[] keys;
        if (key == null) {
            return false;
        }
        String keysString = (String)art.getMetaData().get(P2RepoConstants.KEY_FRAGMENT_KEYS);
        if (keysString == null) {
            return false;
        }
        String[] stringArray = keys = keysString.split(";");
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String actualKey = stringArray[n2];
            if (key.equals(actualKey)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

