/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.osgi.web;

import com.google.common.net.UrlEscapers;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.common.osgi.OsgiAspectFactory;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.web.breadcrumbs.Breadcrumbs;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformation;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.Modifier;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;

@Controller
@RequestMapping(value={"/osgi.info"})
@ViewResolver(value="/WEB-INF/views/%s.jsp")
public class OsgiController
implements InterfaceExtender {
    private ChannelService service;

    public void setService(ChannelService service) {
        this.service = service;
    }

    public List<MenuEntry> getViews(HttpServletRequest request, Object object) {
        if (object instanceof ChannelInformation) {
            return this.getChannelViews((ChannelInformation)object);
        }
        return null;
    }

    private List<MenuEntry> getChannelViews(ChannelInformation channel) {
        if (!channel.hasAspect("osgi")) {
            return null;
        }
        LinkedList<MenuEntry> result = new LinkedList<MenuEntry>();
        HashMap<String, String> model = new HashMap<String, String>(1);
        model.put("channelId", channel.getId());
        result.add(new MenuEntry("OSGi", 500, "Bundles", 500, LinkTarget.createFromController(OsgiController.class, (String)"infoBundles").expand(model), Modifier.DEFAULT, null, false, 0L));
        result.add(new MenuEntry("OSGi", 500, "Features", 600, LinkTarget.createFromController(OsgiController.class, (String)"infoFeatures").expand(model), Modifier.DEFAULT, null, false, 0L));
        return result;
    }

    @RequestMapping(value={"/channel/{channelId}/infoBundles"})
    public ModelAndView infoBundles(@PathVariable(value="channelId") String channelId) {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>(2);
            model.put("channel", channel.getInformation());
            LinkedList<ArtifactBundleInformation> bundles = new LinkedList<ArtifactBundleInformation>();
            for (ArtifactInformation art : channel.getArtifacts()) {
                ArtifactBundleInformation bi = (ArtifactBundleInformation)OsgiAspectFactory.fetchBundleInformation((Map)art.getMetaData(), ArtifactBundleInformation.class);
                if (bi == null) continue;
                bi.setChannelId(channel.getId().getId());
                bi.setArtifactId(art.getId());
                bundles.add(bi);
            }
            bundles.sort((i1, i2) -> {
                int rc = i1.getId().compareTo(i2.getId());
                if (rc != 0) {
                    return rc;
                }
                return i1.getVersion().compareTo(i2.getVersion());
            });
            model.put("bundles", bundles);
            return new ModelAndView("infoBundles", model);
        });
    }

    @RequestMapping(value={"/channel/{channelId}/artifact/{artifactId}/viewBundle"})
    public ModelAndView viewBundle(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId) {
        return Channels.withArtifact((ChannelService)this.service, (String)channelId, (String)artifactId, ReadableChannel.class, (channel, artifact) -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("artifact", artifact);
            BundleInformation bi = OsgiAspectFactory.fetchBundleInformation((Map)artifact.getMetaData());
            model.put("bundle", bi);
            String aid = artifact.getId();
            String cid = artifact.getChannelId().getId();
            LinkedList<Breadcrumbs.Entry> breadcrumbs = new LinkedList<Breadcrumbs.Entry>();
            breadcrumbs.add(new Breadcrumbs.Entry("Home", "/"));
            breadcrumbs.add(new Breadcrumbs.Entry("Channel", "/osgi.info/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(cid) + "/infoBundles"));
            breadcrumbs.add(new Breadcrumbs.Entry("Artifact", "/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(cid) + "/artifacts/" + UrlEscapers.urlPathSegmentEscaper().escape(aid) + "/view"));
            breadcrumbs.add(new Breadcrumbs.Entry("Bundle Information"));
            model.put("breadcrumbs", new Breadcrumbs(breadcrumbs));
            model.put("fullManifest", artifact.getMetaData().get(new MetaKey("osgi", "fullManifest")));
            return new ModelAndView("viewBundle", model);
        });
    }

    @RequestMapping(value={"/channel/{channelId}/artifact/{artifactId}/viewFeature"})
    public ModelAndView viewFeature(@PathVariable(value="channelId") String channelId, @PathVariable(value="artifactId") String artifactId) {
        return Channels.withArtifact((ChannelService)this.service, (String)channelId, (String)artifactId, ReadableChannel.class, (channel, artifact) -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            model.put("artifact", artifact);
            FeatureInformation bi = OsgiAspectFactory.fetchFeatureInformation((Map)artifact.getMetaData());
            model.put("feature", bi);
            String aid = artifact.getId();
            String cid = artifact.getChannelId().getId();
            LinkedList<Breadcrumbs.Entry> breadcrumbs = new LinkedList<Breadcrumbs.Entry>();
            breadcrumbs.add(new Breadcrumbs.Entry("Home", "/"));
            breadcrumbs.add(new Breadcrumbs.Entry("Channel", "/osgi.info/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(cid) + "/infoFeatures"));
            breadcrumbs.add(new Breadcrumbs.Entry("Artifact", "/channel/" + UrlEscapers.urlPathSegmentEscaper().escape(cid) + "/artifacts/" + UrlEscapers.urlPathSegmentEscaper().escape(aid) + "/view"));
            breadcrumbs.add(new Breadcrumbs.Entry("Feature Information"));
            model.put("breadcrumbs", new Breadcrumbs(breadcrumbs));
            return new ModelAndView("viewFeature", model);
        });
    }

    @RequestMapping(value={"/channel/{channelId}/infoFeatures"})
    public ModelAndView infoFeatures(@PathVariable(value="channelId") String channelId) {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>(2);
            model.put("channel", channel.getInformation());
            LinkedList<ArtifactFeatureInformation> features = new LinkedList<ArtifactFeatureInformation>();
            for (ArtifactInformation art : channel.getArtifacts()) {
                ArtifactFeatureInformation fi = (ArtifactFeatureInformation)OsgiAspectFactory.fetchFeatureInformation((Map)art.getMetaData(), ArtifactFeatureInformation.class);
                if (fi == null) continue;
                fi.setChannelId(channel.getId().getId());
                fi.setArtifactId(art.getId());
                features.add(fi);
            }
            features.sort((i1, i2) -> {
                int rc = i1.getId().compareTo(i2.getId());
                if (rc != 0) {
                    return rc;
                }
                return i1.getVersion().compareTo(i2.getVersion());
            });
            model.put("features", features);
            return new ModelAndView("infoFeatures", model);
        });
    }

    public static class ArtifactBundleInformation
    extends BundleInformation {
        private String channelId;
        private String artifactId;

        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }
    }

    public static class ArtifactFeatureInformation
    extends FeatureInformation {
        private String channelId;
        private String artifactId;

        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        public String getChannelId() {
            return this.channelId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }
    }
}

