/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.common;

import com.google.common.net.UrlEscapers;
import org.eclipse.packagedrone.repo.trigger.TriggerConfiguration;
import org.eclipse.packagedrone.repo.trigger.TriggerHandle;
import org.eclipse.packagedrone.repo.trigger.TriggeredChannel;
import org.eclipse.packagedrone.repo.trigger.common.AbstractCommonTriggerConfigurationController;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;

public abstract class SimpleTriggerConfigurationController<T>
extends AbstractCommonTriggerConfigurationController<T> {
    private final String factoryId;
    private final String viewName;

    protected abstract T newModel();

    protected abstract T parseModel(String var1);

    protected abstract String writeModel(T var1);

    public SimpleTriggerConfigurationController(String factoryId, String viewName) {
        this.factoryId = factoryId;
        this.viewName = viewName;
    }

    @Override
    protected ModelAndView handleCreate(TriggeredChannel channel) {
        return new ModelAndView(this.viewName, this.makeModel(channel, null, this::newModel));
    }

    @Override
    protected ModelAndView handleEdit(TriggeredChannel channel, TriggerHandle trigger) {
        return new ModelAndView(this.viewName, this.makeModel(channel, trigger, () -> this.parseModel(((TriggerConfiguration)trigger.getConfiguration().get()).getConfiguration())));
    }

    @Override
    protected ModelAndView handleCreateUpdate(TriggeredChannel channel, T command, BindingResult result) {
        if (result.hasErrors()) {
            return new ModelAndView(this.viewName, this.makeModel(channel, null, () -> command));
        }
        channel.addConfiguredTrigger(this.factoryId, this.writeModel(command));
        return new ModelAndView(String.format("redirect:/trigger/channel/%s/list", UrlEscapers.urlPathSegmentEscaper().escape(channel.getId().getId())));
    }

    @Override
    protected ModelAndView handleEditUpdate(TriggeredChannel channel, TriggerHandle triggerHandle, T command, BindingResult result) {
        if (result.hasErrors()) {
            return new ModelAndView(this.viewName, this.makeModel(channel, triggerHandle, () -> command));
        }
        channel.modifyConfiguredTrigger(triggerHandle.getId(), this.writeModel(command));
        return new ModelAndView(String.format("redirect:/trigger/channel/%s/list", UrlEscapers.urlPathSegmentEscaper().escape(channel.getId().getId())));
    }
}

