/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.packagedrone.repo.ChannelAspectInformation;
import org.eclipse.packagedrone.repo.Version;
import org.eclipse.packagedrone.repo.aspect.ChannelAspect;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectFactory;
import org.eclipse.packagedrone.repo.aspect.PropertiesHelper;
import org.eclipse.packagedrone.repo.aspect.group.Group;
import org.eclipse.packagedrone.repo.aspect.group.GroupInformation;
import org.eclipse.packagedrone.utils.profiler.Profile;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ChannelAspectProcessor {
    private final ServiceTracker<ChannelAspectFactory, FactoryEntry> tracker;
    private ServiceTracker<Group, GroupInformation> groupTracker;

    public ChannelAspectProcessor(final BundleContext context) {
        this.tracker = new ServiceTracker(context, ChannelAspectFactory.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ChannelAspectFactory, FactoryEntry>(){

            public FactoryEntry addingService(ServiceReference<ChannelAspectFactory> reference) {
                return ChannelAspectProcessor.makeEntry(context, reference);
            }

            public void modifiedService(ServiceReference<ChannelAspectFactory> reference, FactoryEntry service) {
            }

            public void removedService(ServiceReference<ChannelAspectFactory> reference, FactoryEntry service) {
                context.ungetService(reference);
            }
        });
        this.tracker.open();
        this.groupTracker = new ServiceTracker(context, Group.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Group, GroupInformation>(){

            public GroupInformation addingService(ServiceReference<Group> reference) {
                Group group = (Group)context.getService(reference);
                return group.getInformation();
            }

            public void modifiedService(ServiceReference<Group> reference, GroupInformation service) {
            }

            public void removedService(ServiceReference<Group> reference, GroupInformation service) {
                context.ungetService(reference);
            }
        });
        this.groupTracker.open();
    }

    public void close() {
        this.tracker.close();
        this.groupTracker.close();
    }

    protected Map<String, ChannelAspectFactory> getAllFactories() {
        SortedMap tracked = this.tracker.getTracked();
        HashMap<String, ChannelAspectFactory> result = new HashMap<String, ChannelAspectFactory>(tracked.size());
        for (Map.Entry entry : tracked.entrySet()) {
            Object key = ((ServiceReference)entry.getKey()).getProperty("drone.aspect.id");
            if (!(key instanceof String)) continue;
            result.put((String)key, ((FactoryEntry)entry.getValue()).getService());
        }
        return result;
    }

    public <T> void process(Collection<String> factoryIds, Function<ChannelAspect, T> getter, Consumer<T> consumer) {
        Collection<ChannelAspect> aspects = this.createAspects(factoryIds);
        for (ChannelAspect aspect : aspects) {
            Throwable throwable = null;
            Object var8_9 = null;
            try (Profile.Handle handle = Profile.start((String)("processAspect|" + aspect.getId()));){
                T t = getter.apply(aspect);
                if (t == null) continue;
                consumer.accept(t);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public <T> void process(Collection<String> factoryIds, Function<ChannelAspect, T> getter, BiConsumer<ChannelAspect, T> consumer) {
        Collection<ChannelAspect> aspects = this.createAspects(factoryIds);
        for (ChannelAspect aspect : aspects) {
            Throwable throwable = null;
            Object var8_9 = null;
            try (Profile.Handle handle = Profile.start((String)("processAspect|" + aspect.getId()));){
                T t = getter.apply(aspect);
                if (t == null) continue;
                consumer.accept(aspect, (ChannelAspect)t);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private Collection<ChannelAspect> createAspects(Collection<String> factoryIds) {
        LinkedList<String> missingAspects = new LinkedList<String>();
        Map<String, ChannelAspectFactory> factories = this.getAllFactories();
        ArrayList<ChannelAspect> result = new ArrayList<ChannelAspect>(factoryIds.size());
        for (String id : factoryIds) {
            ChannelAspectFactory factory = factories.get(id);
            if (factory == null) {
                missingAspects.add(id);
                continue;
            }
            ChannelAspect aspect = factory.createAspect();
            if (aspect != null) {
                result.add(aspect);
                continue;
            }
            missingAspects.add(id);
        }
        if (!missingAspects.isEmpty()) {
            throw new IllegalStateException(String.format("Missing aspects: %s", missingAspects));
        }
        return result;
    }

    public Map<String, ChannelAspectInformation> getAspectInformations() {
        HashMap<String, ChannelAspectInformation> result = new HashMap<String, ChannelAspectInformation>();
        for (FactoryEntry entry : this.tracker.getTracked().values()) {
            ChannelAspectInformation info = entry.getInformation();
            result.put(info.getFactoryId(), info);
        }
        return result;
    }

    public static Map<String, ChannelAspectInformation> scanAspectInformations(BundleContext context) {
        Collection refs;
        try {
            refs = context.getServiceReferences(ChannelAspectFactory.class, null);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return Collections.emptyMap();
        }
        if (refs == null) {
            return Collections.emptyMap();
        }
        HashMap<String, ChannelAspectInformation> result = new HashMap<String, ChannelAspectInformation>(refs.size());
        for (ServiceReference ref : refs) {
            ChannelAspectInformation info = ChannelAspectProcessor.makeInformation((ServiceReference<ChannelAspectFactory>)ref);
            result.put(info.getFactoryId(), info);
        }
        return result;
    }

    protected static FactoryEntry makeEntry(BundleContext context, ServiceReference<ChannelAspectFactory> ref) {
        ChannelAspectInformation info = ChannelAspectProcessor.makeInformation(ref);
        if (info == null) {
            return null;
        }
        return new FactoryEntry(info, (ChannelAspectFactory)context.getService(ref));
    }

    public static ChannelAspectInformation makeInformation(ServiceReference<ChannelAspectFactory> ref) {
        String factoryId = ChannelAspectProcessor.getString(ref, "drone.aspect.id", ChannelAspectProcessor.getString(ref, "service.pid", null));
        if (factoryId == null) {
            return null;
        }
        String label = ChannelAspectProcessor.getString(ref, "drone.aspect.name", null);
        String descUrl = ChannelAspectProcessor.getString(ref, "drone.aspect.description.file", null);
        String description = descUrl != null ? PropertiesHelper.loadUrl(ref.getBundle(), descUrl) : ChannelAspectProcessor.getString(ref, "drone.aspect.description", ChannelAspectProcessor.getString(ref, "service.description", null));
        String groupId = ChannelAspectProcessor.getString(ref, "drone.aspect.group.id", null);
        Version version = Version.valueOf((String)ChannelAspectProcessor.getString(ref, "drone.aspect.version", null));
        SortedSet<String> requires = ChannelAspectProcessor.makeRequires(ref);
        return new ChannelAspectInformation(factoryId, label, description, groupId, requires, version);
    }

    private static SortedSet<String> makeRequires(ServiceReference<ChannelAspectFactory> ref) {
        Object val = ref.getProperty("drone.aspect.requires");
        if (val instanceof String[]) {
            return new TreeSet<String>(Arrays.asList((String[])val));
        }
        if (val instanceof String) {
            String s = (String)val;
            if (s.isEmpty()) {
                return null;
            }
            return new TreeSet<String>(Arrays.asList(s.split("[\\p{Space},]+")));
        }
        return null;
    }

    public List<ChannelAspectInformation> resolve(Collection<String> aspects) {
        Map<String, ChannelAspectInformation> infos = this.getAspectInformations();
        ArrayList<ChannelAspectInformation> result = new ArrayList<ChannelAspectInformation>(aspects.size());
        for (String aspect : aspects) {
            ChannelAspectInformation ai = infos.get(aspect);
            if (ai == null) {
                result.add(ChannelAspectInformation.unresolved((String)aspect));
                continue;
            }
            result.add(ai);
        }
        return result;
    }

    private static String getString(ServiceReference<ChannelAspectFactory> ref, String name, String defaultValue) {
        Object v = ref.getProperty(name);
        if (v == null) {
            return defaultValue;
        }
        return v.toString();
    }

    public Collection<GroupInformation> getGroups() {
        return new ArrayList<GroupInformation>(this.groupTracker.getTracked().values());
    }

    public static class FactoryEntry {
        private final ChannelAspectInformation information;
        private final ChannelAspectFactory service;

        public FactoryEntry(ChannelAspectInformation info, ChannelAspectFactory service) {
            this.information = info;
            this.service = service;
        }

        public ChannelAspectInformation getInformation() {
            return this.information;
        }

        public ChannelAspectFactory getService() {
            return this.service;
        }
    }
}

