/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.npm.aspect;

import com.google.common.io.ByteStreams;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;

public class NpmExtractor
implements Extractor {
    public void extractMetaData(Extractor.Context context, Map<String, String> metadata) throws Exception {
        try {
            this.perform(context.getPath(), metadata);
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void perform(Path file, Map<String, String> metadata) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            GZIPInputStream gis = new GZIPInputStream(new FileInputStream(file.toFile()));
            try {
                try (TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)gis);){
                    TarArchiveEntry entry;
                    while ((entry = tis.getNextTarEntry()) != null) {
                        if (!entry.getName().equals("package/package.json")) continue;
                        byte[] data = new byte[(int)entry.getSize()];
                        ByteStreams.read((InputStream)tis, (byte[])data, (int)0, (int)data.length);
                        String str = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(data)).toString();
                        try {
                            new JsonParser().parse(str);
                            metadata.put("package.json", str);
                        }
                        catch (JsonParseException jsonParseException) {}
                        break;
                    }
                }
                if (gis == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (gis == null) throw throwable;
                gis.close();
                throw throwable;
            }
            gis.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

