/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.eclipse.scada.utils.io.RecursiveDeleteVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStore
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TransactionImpl.class);
    private Transaction transaction;
    private final Path dataPath;
    private final Path tmpPath;
    private final Path swapPath;

    public CacheStore(Path path) throws IOException {
        this.dataPath = path.resolve("data");
        this.tmpPath = path.resolve("tmp");
        this.swapPath = path.resolve("swap");
        Files.createDirectories(this.dataPath, new FileAttribute[0]);
        Files.createDirectories(this.tmpPath, new FileAttribute[0]);
    }

    protected void markFinished(TransactionImpl transaction) {
        if (transaction != this.transaction) {
            throw new IllegalStateException("Wrong transaction tries to finish");
        }
        this.transaction = null;
    }

    @Override
    public synchronized void close() {
        if (this.transaction != null) {
            this.transaction.rollback();
            this.transaction = null;
        }
    }

    public synchronized Transaction startTransaction() {
        if (this.transaction != null) {
            throw new IllegalStateException("Another transaction is already in progress");
        }
        this.transaction = new TransactionImpl();
        return this.transaction;
    }

    public boolean stream(MetaKey key, IOConsumer<InputStream> consumer) throws IOException {
        return this.streamFrom(this.dataPath, key, consumer);
    }

    private boolean streamFrom(Path basePath, MetaKey key, IOConsumer<InputStream> consumer) throws IOException {
        block13: {
            Path path = CacheStore.makePath(basePath, key);
            logger.trace("streamFrom - key: %s, path: %s", (Object)key, (Object)path);
            Throwable throwable = null;
            Object var6_7 = null;
            BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]));
            try {
                consumer.accept((Object)stream);
                if (stream == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        return false;
                    }
                }
            }
            ((InputStream)stream).close();
        }
        return true;
    }

    private static Path makePath(Path basePath, MetaKey key) {
        return basePath.resolve(key.getNamespace()).resolve(key.getKey());
    }

    public static interface Transaction {
        public long put(MetaKey var1, IOConsumer<OutputStream> var2) throws IOException;

        public boolean stream(MetaKey var1, IOConsumer<InputStream> var2) throws IOException;

        public void clear() throws IOException;

        public void commit();

        public void rollback();
    }

    public class TransactionImpl
    implements Transaction {
        private Path tmp;

        @Override
        public long put(MetaKey key, IOConsumer<OutputStream> source) throws IOException {
            this.makeTemp();
            Path path = CacheStore.makePath(this.tmp, key);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Throwable throwable = null;
            Object var5_6 = null;
            try (BufferedOutputStream stream = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                source.accept((Object)stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return Files.size(path);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() throws IOException {
            CacheStore cacheStore = CacheStore.this;
            synchronized (cacheStore) {
                if (this.tmp != null) {
                    Files.walkFileTree(this.tmp, (FileVisitor<? super Path>)new RecursiveDeleteVisitor());
                }
                this.makeTemp();
            }
        }

        private void makeTemp() throws IOException {
            if (this.tmp == null) {
                this.tmp = Files.createTempDirectory(CacheStore.this.tmpPath, "trans", new FileAttribute[0]);
            }
        }

        @Override
        public boolean stream(MetaKey key, IOConsumer<InputStream> consumer) throws IOException {
            if (CacheStore.this.streamFrom(this.tmp, key, (IOConsumer<InputStream>)consumer)) {
                return true;
            }
            return CacheStore.this.streamFrom(CacheStore.this.dataPath, key, (IOConsumer<InputStream>)consumer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            CacheStore cacheStore = CacheStore.this;
            synchronized (cacheStore) {
                CacheStore.this.markFinished(this);
                if (this.tmp == null) {
                    return;
                }
                try {
                    if (Files.exists(CacheStore.this.swapPath, new LinkOption[0])) {
                        Files.walkFileTree(CacheStore.this.swapPath, (FileVisitor<? super Path>)new RecursiveDeleteVisitor());
                    }
                    if (Files.exists(CacheStore.this.dataPath, new LinkOption[0])) {
                        Files.createDirectories(CacheStore.this.swapPath.getParent(), new FileAttribute[0]);
                        Files.move(CacheStore.this.dataPath, CacheStore.this.swapPath, StandardCopyOption.ATOMIC_MOVE);
                    }
                    Files.move(this.tmp, CacheStore.this.dataPath, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (Files.exists(CacheStore.this.swapPath, new LinkOption[0])) {
                    try {
                        Files.walkFileTree(CacheStore.this.swapPath, (FileVisitor<? super Path>)new RecursiveDeleteVisitor());
                    }
                    catch (IOException iOException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rollback() {
            CacheStore cacheStore = CacheStore.this;
            synchronized (cacheStore) {
                CacheStore.this.markFinished(this);
                if (this.tmp == null) {
                    return;
                }
                try {
                    Files.walkFileTree(this.tmp, (FileVisitor<? super Path>)new RecursiveDeleteVisitor());
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to roll back", e);
                }
            }
        }
    }
}

