/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm;

import java.io.IOException;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.apm.ChannelImpl;
import org.eclipse.packagedrone.repo.channel.apm.ChannelModelProvider;
import org.eclipse.packagedrone.repo.channel.provider.Channel;
import org.eclipse.packagedrone.repo.channel.provider.ChannelOperationContext;
import org.eclipse.packagedrone.repo.channel.provider.ChannelProvider;
import org.eclipse.packagedrone.repo.channel.provider.ProviderInformation;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.scada.utils.io.RecursiveDeleteVisitor;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelProviderImpl
implements ChannelProvider {
    private static final Logger logger = LoggerFactory.getLogger(ChannelProviderImpl.class);
    private static final String ID = "apm";
    private static final ProviderInformation INFO = new ProviderInformation("apm", "APM storage", "APM based channel storage");
    private StorageManager manager;
    private EventAdmin eventAdmin;
    private final CopyOnWriteArraySet<ChannelImpl> channels = new CopyOnWriteArraySet();

    public void setManager(StorageManager manager) {
        this.manager = manager;
    }

    public void setEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void start() {
    }

    public void stop() {
        for (ChannelImpl channel : this.channels) {
            channel.dispose();
        }
        this.channels.clear();
    }

    public Channel load(String channelId, Map<MetaKey, String> configuration) {
        Objects.requireNonNull(channelId);
        Objects.requireNonNull(configuration);
        return new ChannelImpl(channelId, this.eventAdmin, this.manager, this, configuration);
    }

    public void create(String channelId, Map<MetaKey, String> configuration) {
        Objects.requireNonNull(channelId);
        Objects.requireNonNull(configuration);
        this.createNewChannel(channelId, configuration);
    }

    protected void createNewChannel(String channelId, Map<MetaKey, String> configuration) {
        Objects.requireNonNull(channelId);
        Objects.requireNonNull(configuration);
        ChannelImpl channel = new ChannelImpl(channelId, this.eventAdmin, this.manager, this, configuration);
        try {
            channel.modifyRun(model -> {}, ChannelOperationContext.NOOP);
        }
        finally {
            channel.dispose();
        }
    }

    public void deleteChannel(ChannelImpl channel) {
        if (this.channels.remove(channel)) {
            String id = channel.getLocalId();
            channel.dispose();
            this.deleteChannelContent(id);
        }
    }

    private void deleteChannelContent(String id) {
        Path path = ChannelModelProvider.makeBasePath(this.manager.getContext(), id);
        Path dir = path.getParent();
        Path fn = path.getFileSystem().getPath("x-" + id, new String[0]);
        Path target = dir == null ? fn : dir.resolve(fn);
        try {
            Files.move(path, target, StandardCopyOption.ATOMIC_MOVE);
            path = target;
        }
        catch (IOException e) {
            logger.warn("Failed to rename the channel directoy first", (Throwable)e);
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new RecursiveDeleteVisitor());
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete channel content", e);
        }
    }

    public ProviderInformation getInformation() {
        return INFO;
    }
}

