/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.forms.tags;

import java.util.Collection;
import java.util.Collections;
import javax.servlet.jsp.JspException;
import org.eclipse.packagedrone.web.forms.tags.Helper;
import org.eclipse.packagedrone.web.forms.tags.OptionTagSupport;
import org.eclipse.packagedrone.web.forms.tags.WriterHelper;

public class OptionList
extends OptionTagSupport {
    private static final long serialVersionUID = 1L;
    private Collection<?> items = Collections.emptyList();
    private String itemValue;
    private String itemLabel;

    public int doStartTag() throws JspException {
        WriterHelper writer = new WriterHelper(this.pageContext);
        if (this.items != null) {
            for (Object o : this.items) {
                this.renderOption(writer, o);
            }
        }
        return 0;
    }

    protected void renderOption(WriterHelper writer, Object o) throws JspException {
        String value = Helper.makeString(o, this.itemValue, "");
        String label = this.itemLabel == null || this.itemLabel.isEmpty() ? value : Helper.makeString(o, this.itemLabel, value);
        this.renderOption(writer, value, label, this.isSelected(value, v -> Helper.makeString(v, this.itemValue, "")));
    }

    protected void renderOption(WriterHelper writer, String value, String label, boolean selected) throws JspException {
        writer.write("<option");
        writer.writeAttribute("value", value);
        writer.writeFlagAttribute("selected", selected);
        writer.write(" >");
        writer.writeEscaped(label != null ? label : value);
        writer.write("</option>");
    }

    public void setItems(Collection<?> items) {
        this.items = items;
    }

    public void setItemValue(String itemValue) {
        this.itemValue = itemValue;
    }

    public void setItemLabel(String itemLabel) {
        this.itemLabel = itemLabel;
    }
}

