/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.concurrent.task;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.eclipse.scada.utils.concurrent.NotifyFuture;
import org.eclipse.scada.utils.concurrent.task.TaskHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskHandler
implements TaskHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTaskHandler.class);
    private final Map<Long, NotifyFuture<?>> taskMap = new HashMap();
    private final Random random = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long allocateId(NotifyFuture<?> task) {
        Map<Long, NotifyFuture<?>> map = this.taskMap;
        synchronized (map) {
            Long value = this.random.nextLong();
            while (this.taskMap.containsKey(value)) {
                value = this.random.nextLong();
            }
            this.taskMap.put(value, task);
            logger.debug("{} items are in the map", (Object)this.taskMap.size());
            return value;
        }
    }

    @Override
    public TaskHandler.Handle addTask(NotifyFuture<?> task) {
        return new HandleImpl(this.allocateId(task), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelTask(Long id) {
        NotifyFuture<?> task;
        if (id == null) {
            return false;
        }
        DefaultTaskHandler defaultTaskHandler = this;
        synchronized (defaultTaskHandler) {
            task = this.taskMap.get(id);
        }
        if (task != null) {
            task.cancel(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<Long, NotifyFuture<?>> map = this.taskMap;
        synchronized (map) {
            for (Map.Entry<Long, NotifyFuture<?>> entry : this.taskMap.entrySet()) {
                entry.getValue().cancel(true);
            }
            this.taskMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTask(Long id) {
        if (id == null) {
            return false;
        }
        Map<Long, NotifyFuture<?>> map = this.taskMap;
        synchronized (map) {
            logger.debug("{} items are in the map", (Object)this.taskMap.size());
            return this.taskMap.remove(id) != null;
        }
    }

    private class HandleImpl
    implements TaskHandler.Handle {
        private volatile Long id;
        private final DefaultTaskHandler handler;

        public HandleImpl(long id, DefaultTaskHandler handler) {
            this.id = id;
            this.handler = handler;
        }

        @Override
        public Long getId() {
            return this.id;
        }

        protected void finalize() throws Throwable {
            this.handler.removeTask(this.id);
            super.finalize();
        }

        @Override
        public void dispose() {
            this.handler.removeTask(this.id);
            this.id = null;
        }
    }
}

