/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.deb.control;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.packagedrone.utils.deb.FieldFormatter;
import org.eclipse.packagedrone.utils.deb.control.GenericControlFile;

public class BinaryPackageControlFile
extends GenericControlFile {
    public static final Map<String, FieldFormatter> FORMATTERS;

    static {
        HashMap<String, FieldFormatter> formatters = new HashMap<String, FieldFormatter>();
        formatters.put("Description", FieldFormatter.MULTI);
        FORMATTERS = Collections.unmodifiableMap(formatters);
    }

    public void setPackage(String value) {
        this.values.put("Package", value);
    }

    public String getPackage() {
        return (String)this.values.get("Package");
    }

    public void setVersion(String value) {
        this.values.put("Version", value);
    }

    public String getVersion() {
        return (String)this.values.get("Version");
    }

    public String getArchitecture() {
        return (String)this.values.get("Architecture");
    }

    public void setArchitecture(String value) {
        this.values.put("Architecture", value);
    }

    public String getMaintainer() {
        return (String)this.values.get("Maintainer");
    }

    public void setMaintainer(String value) {
        this.values.put("Maintainer", value);
    }

    public String getDescription() {
        return (String)this.values.get("Description");
    }

    public void setDescription(String value) {
        this.values.put("Description", value);
    }

    public String getPriority() {
        return (String)this.values.get("Priority");
    }

    public void setPriority(String value) {
        this.values.put("Priority", value);
    }

    public String getSection() {
        return (String)this.values.get("Section");
    }

    public void setSection(String value) {
        this.values.put("Section", value);
    }

    public void validate() {
        BinaryPackageControlFile.validate(this);
    }

    public static void validate(BinaryPackageControlFile controlFile) {
        BinaryPackageControlFile.hasField(controlFile, "Package");
        BinaryPackageControlFile.hasField(controlFile, "Architecture");
        BinaryPackageControlFile.hasField(controlFile, "Version");
        BinaryPackageControlFile.hasField(controlFile, "Maintainer");
        BinaryPackageControlFile.hasField(controlFile, "Description");
    }

    private static void hasField(BinaryPackageControlFile controlFile, String field) {
        String result = (String)controlFile.values.get(field);
        if (result == null) {
            throw new IllegalStateException(String.format("Control file must have field '%s'", field));
        }
    }

    public String makeFileName() {
        String name = String.format("%s_%s_%s.deb", this.getPackage(), this.getVersion(), this.getArchitecture());
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface Fields {
        public static final String PACKAGE = "Package";
        public static final String VERSION = "Version";
        public static final String ARCHITECTURE = "Architecture";
        public static final String SECTION = "Section";
        public static final String PRIORITY = "Priority";
        public static final String ESSENTIAL = "Essential";
        public static final String DESCRIPTION = "Description";
        public static final String MAINTAINER = "Maintainer";
        public static final String INSTALLED_SIZE = "Installed-Size";
        public static final String CONFLICTS = "Conflicts";
        public static final String DEPENDS = "Depends";
        public static final String PRE_DEPENDS = "Pre-Depends";
    }
}

